/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.TermDefinition;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.IndexList;

public class IndexBuilder {
    private AdapterFactory adapterFactory;
    private static final Class ITreeItemContentProviderClass;
    private static final String INDEX_HTML_FILE = "index/contents.htm";
    private static final String INDEX_NAVIG_HTML_FILE = "index/navig.htm";
    private static final String INDEX_XSL_FILE = "xsl/index_contents.xsl";
    private static final String INDEX_NAVIG_XSL_FILE = "xsl/index_navig.xsl";
    private IndexList indexItems = new IndexList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProviderClass = clazz;
    }

    public void execute(MethodConfiguration config, String pubDir, String title, IProgressMonitor monitor) {
        this.indexItems.clear();
        ConfigurationFilter configFilter = new ConfigurationFilter(config, null);
        this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configFilter);
        this.iterate(config);
        this.createIndex(pubDir, title);
    }

    private void iterate(Object obj) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(obj, (Object)ITreeItemContentProviderClass);
        if (treeItemContentProvider != null) {
            Collection items = treeItemContentProvider.getChildren(obj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Object itorObj = LibraryUtil.unwrap(it.next());
                if (itorObj instanceof GuidanceGroupingItemProvider) {
                    this.iterate(itorObj);
                    continue;
                }
                if (itorObj instanceof GuidanceItemProvider) {
                    this.iterate(itorObj);
                    continue;
                }
                if (!(itorObj instanceof TermDefinition)) continue;
                TermDefinition term = (TermDefinition)itorObj;
                String name = term.getName();
                String content = "definition in glossary";
                String url = "../glossary/glossary.htm#" + term.getName();
                this.indexItems.add(name, content, url);
            }
        }
    }

    private void createIndex(String pubDir, String title) {
        try {
            URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), INDEX_XSL_FILE);
            if (url == null) {
                System.out.println("Unable to get index xsl template xsl/index_contents.xsl");
                return;
            }
            String xsl_uri = Platform.resolve((URL)url).getPath();
            StringBuffer xml = this.indexItems.getXml();
            File f = new File(pubDir, INDEX_HTML_FILE);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            Properties xslParams = new Properties();
            xslParams.setProperty("title", title);
            StringWriter sw = new StringWriter();
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)sw);
            sw.flush();
            String content = sw.getBuffer().toString();
            FileWriter output = new FileWriter(f);
            output.write(content);
            output.flush();
            output.close();
            url = new URL(PublishingPlugin.getDefault().getInstallURL(), INDEX_NAVIG_XSL_FILE);
            if (url == null) {
                System.out.println("Unable to get glossary xsl template xsl/index_navig.xsl");
                return;
            }
            xsl_uri = Platform.resolve((URL)url).getPath();
            f = new File(pubDir, INDEX_NAVIG_HTML_FILE);
            output = new FileWriter(f);
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

