/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Practice;
import com.ibm.uma.Roadmap;
import com.ibm.uma.SupportingMaterial;
import com.ibm.uma.TermDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.PublishingContentValidator;

public class ProcessPublishingContentValidator
extends PublishingContentValidator {
    List closureElements = null;
    private boolean isFinalClosure = false;
    Map objReferences = new HashMap();
    private boolean debug = PublishingPlugin.getDefault().isDebugging();

    public ProcessPublishingContentValidator(String pubDir, boolean validateExternalLinks) {
        super(pubDir, validateExternalLinks);
    }

    public void addClosureElements(List items) {
        if (this.closureElements == null) {
            this.closureElements = new ArrayList();
        }
        this.closureElements.addAll(items);
    }

    public void makeElementClosure() {
        this.isFinalClosure = true;
        if (this.debug) {
            System.out.println("====================== Closure elements =======================");
            Iterator it = this.closureElements.iterator();
            while (it.hasNext()) {
                System.out.println(LibraryUtil.getTypeName((MethodElement)((MethodElement)it.next())));
            }
            System.out.println("====================== Closure elements end =======================");
        }
    }

    public boolean hasClosure() {
        return this.closureElements != null && this.closureElements.size() > 0;
    }

    public boolean inClosure(MethodElement e) {
        if (e == null) {
            return false;
        }
        if (!this.hasClosure()) {
            return true;
        }
        if (this.closureElements.contains(e)) {
            return true;
        }
        if (e instanceof ContentCategory) {
            return true;
        }
        if (!(e instanceof Guidance)) {
            return false;
        }
        return e instanceof Practice || e instanceof Roadmap || e instanceof SupportingMaterial || e instanceof TermDefinition;
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e) {
        if (owner == null) {
            owner = this.defaultTarget;
        } else if (this.defaultTarget != null && owner != this.defaultTarget) {
            super.logWarning("Target mismatch" + LibraryUtil.getTypeName((MethodElement)owner) + "<--->" + LibraryUtil.getTypeName((MethodElement)this.defaultTarget));
        }
        if (super.isDiscarded(owner, feature, e)) {
            return true;
        }
        boolean inCls = this.inClosure(e);
        if (!inCls && !this.isFinalClosure) {
            boolean bl = inCls = this.inClosure(owner) && e instanceof Guidance;
        }
        return !inCls;
    }

    public void dispose() {
        if (this.closureElements != null) {
            this.closureElements.clear();
        }
        if (this.objReferences != null) {
            this.objReferences.clear();
        }
        super.dispose();
    }
}

