/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;

public final class ULocale
implements Serializable {
    private static final long serialVersionUID = 3715177670352309217L;
    public static final ULocale ENGLISH = new ULocale("en", Locale.ENGLISH);
    public static final ULocale FRENCH = new ULocale("fr", Locale.FRENCH);
    public static final ULocale GERMAN = new ULocale("de", Locale.GERMAN);
    public static final ULocale ITALIAN = new ULocale("it", Locale.ITALIAN);
    public static final ULocale JAPANESE = new ULocale("ja", Locale.JAPANESE);
    public static final ULocale KOREAN = new ULocale("ko", Locale.KOREAN);
    public static final ULocale CHINESE = new ULocale("zh", Locale.CHINESE);
    public static final ULocale SIMPLIFIED_CHINESE = new ULocale("zh_Hans", Locale.CHINESE);
    public static final ULocale TRADITIONAL_CHINESE = new ULocale("zh_Hant", Locale.CHINESE);
    public static final ULocale FRANCE = new ULocale("fr_FR", Locale.FRANCE);
    public static final ULocale GERMANY = new ULocale("de_DE", Locale.GERMANY);
    public static final ULocale ITALY = new ULocale("it_IT", Locale.ITALY);
    public static final ULocale JAPAN = new ULocale("ja_JP", Locale.JAPAN);
    public static final ULocale KOREA = new ULocale("ko_KR", Locale.KOREA);
    public static final ULocale CHINA;
    public static final ULocale PRC;
    public static final ULocale TAIWAN;
    public static final ULocale UK;
    public static final ULocale US;
    public static final ULocale CANADA;
    public static final ULocale CANADA_FRENCH;
    private static final String EMPTY_STRING = "";
    private static final char UNDERSCORE = '_';
    private static final Locale EMPTY_LOCALE;
    public static final ULocale ROOT;
    private static final HashMap CACHE;
    private transient Locale locale;
    private String localeID;
    private static String[] _languages;
    private static String[] _replacementLanguages;
    private static String[] _obsoleteLanguages;
    private static String[] _languages3;
    private static String[] _obsoleteLanguages3;
    private static String[] _countries;
    private static String[] _deprecatedCountries;
    private static String[] _replacementCountries;
    private static String[] _obsoleteCountries;
    private static String[] _countries3;
    private static String[] _obsoleteCountries3;
    private static String[][] _variantsToKeywords;
    private static ULocale defaultULocale;
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;
    static /* synthetic */ Class class$0;

    static {
        PRC = CHINA = new ULocale("zh_Hans_CN", Locale.CHINA);
        TAIWAN = new ULocale("zh_Hant_TW", Locale.TAIWAN);
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale(EMPTY_STRING, EMPTY_STRING);
        ROOT = new ULocale(EMPTY_STRING, EMPTY_LOCALE);
        CACHE = new HashMap(20);
        CACHE.put(EMPTY_LOCALE, ROOT);
        CACHE.put(Locale.ENGLISH, ENGLISH);
        CACHE.put(Locale.FRENCH, FRENCH);
        CACHE.put(Locale.GERMAN, GERMAN);
        CACHE.put(Locale.ITALIAN, ITALIAN);
        CACHE.put(Locale.JAPANESE, JAPANESE);
        CACHE.put(Locale.KOREAN, KOREAN);
        CACHE.put(Locale.CHINESE, CHINESE);
        CACHE.put(Locale.SIMPLIFIED_CHINESE, SIMPLIFIED_CHINESE);
        CACHE.put(Locale.TRADITIONAL_CHINESE, TRADITIONAL_CHINESE);
        CACHE.put(Locale.FRANCE, FRANCE);
        CACHE.put(Locale.GERMANY, GERMANY);
        CACHE.put(Locale.ITALY, ITALY);
        CACHE.put(Locale.JAPAN, JAPAN);
        CACHE.put(Locale.KOREA, KOREA);
        CACHE.put(Locale.CHINA, CHINA);
        CACHE.put(Locale.TAIWAN, TAIWAN);
        CACHE.put(Locale.UK, UK);
        CACHE.put(Locale.US, US);
        CACHE.put(Locale.CANADA, CANADA);
        CACHE.put(Locale.CANADA_FRENCH, CANADA_FRENCH);
        ACTUAL_LOCALE = new Type(0);
        VALID_LOCALE = new Type(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initLanguageTables() {
        if (_languages != null) return;
        String[] tempLanguages = new String[]{"aa", "ab", "ace", "ach", "ada", "ady", "ae", "af", "afa", "afh", "ak", "akk", "ale", "alg", "am", "an", "ang", "apa", "ar", "arc", "arn", "arp", "art", "arw", "as", "ast", "ath", "aus", "av", "awa", "ay", "az", "ba", "bad", "bai", "bal", "ban", "bas", "bat", "be", "bej", "bem", "ber", "bg", "bh", "bho", "bi", "bik", "bin", "bla", "bm", "bn", "bnt", "bo", "br", "bra", "bs", "btk", "bua", "bug", "byn", "ca", "cad", "cai", "car", "cau", "ce", "ceb", "cel", "ch", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "co", "cop", "cpe", "cpf", "cpp", "cr", "crh", "crp", "cs", "csb", "cu", "cus", "cv", "cy", "da", "dak", "dar", "day", "de", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "dv", "dyu", "dz", "ee", "efi", "egy", "eka", "el", "elx", "en", "enm", "eo", "es", "et", "eu", "ewo", "fa", "fan", "fat", "ff", "fi", "fiu", "fj", "fo", "fon", "fr", "frm", "fro", "fur", "fy", "ga", "gaa", "gay", "gba", "gd", "gem", "gez", "gil", "gl", "gmh", "gn", "goh", "gon", "gor", "got", "grb", "grc", "gu", "gv", "gwi", "ha", "hai", "haw", "he", "hi", "hil", "him", "hit", "hmn", "ho", "hr", "hsb", "ht", "hu", "hup", "hy", "hz", "ia", "iba", "id", "ie", "ig", "ii", "ijo", "ik", "ilo", "inc", "ine", "inh", "io", "ira", "iro", "is", "it", "iu", "ja", "jbo", "jpr", "jrb", "jv", "ka", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kg", "kha", "khi", "kho", "ki", "kj", "kk", "kl", "km", "kmb", "kn", "ko", "kok", "kos", "kpe", "kr", "krc", "kro", "kru", "ks", "ku", "kum", "kut", "kv", "kw", "ky", "la", "lad", "lah", "lam", "lb", "lez", "lg", "li", "ln", "lo", "lol", "loz", "lt", "lu", "lua", "lui", "lun", "luo", "lus", "lv", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mg", "mga", "mh", "mi", "mic", "min", "mis", "mk", "mkh", "ml", "mn", "mnc", "mni", "mno", "mo", "moh", "mos", "mr", "ms", "mt", "mul", "mun", "mus", "mwr", "my", "myn", "myv", "na", "nah", "nai", "nap", "nb", "nd", "nds", "ne", "new", "ng", "nia", "nic", "niu", "nl", "nn", "no", "nog", "non", "nr", "nso", "nub", "nv", "nwc", "ny", "nym", "nyn", "nyo", "nzi", "oc", "oj", "om", "or", "os", "osa", "ota", "oto", "pa", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pi", "pl", "pon", "pra", "pro", "ps", "pt", "qu", "raj", "rap", "rar", "rm", "rn", "ro", "roa", "rom", "ru", "rup", "rw", "sa", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "sc", "sco", "sd", "se", "sel", "sem", "sg", "sga", "sgn", "shn", "si", "sid", "sio", "sit", "sk", "sl", "sla", "sm", "sma", "smi", "smj", "smn", "sms", "sn", "snk", "so", "sog", "son", "sq", "sr", "srr", "ss", "ssa", "st", "su", "suk", "sus", "sux", "sv", "sw", "syr", "ta", "tai", "te", "tem", "ter", "tet", "tg", "th", "ti", "tig", "tiv", "tk", "tkl", "tl", "tlh", "tli", "tmh", "tn", "to", "tog", "tpi", "tr", "ts", "tsi", "tt", "tum", "tup", "tut", "tvl", "tw", "ty", "tyv", "udm", "ug", "uga", "uk", "umb", "und", "ur", "uz", "vai", "ve", "vi", "vo", "vot", "wa", "wak", "wal", "war", "was", "wen", "wo", "xal", "xh", "yao", "yap", "yi", "yo", "ypk", "za", "zap", "zen", "zh", "znd", "zu", "zun"};
        String[] tempReplacementLanguages = new String[]{"id", "he", "yi", "jv", "sr", "nb"};
        String[] tempObsoleteLanguages = new String[]{"in", "iw", "ji", "jw", "sh", "no"};
        String[] tempLanguages3 = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "ave", "afr", "afa", "afh", "aka", "akk", "ale", "alg", "amh", "arg", "ang", "apa", "ara", "arc", "arn", "arp", "art", "arw", "asm", "ast", "ath", "aus", "ava", "awa", "aym", "aze", "bak", "bad", "bai", "bal", "ban", "bas", "bat", "bel", "bej", "bem", "ber", "bul", "bih", "bho", "bis", "bik", "bin", "bla", "bam", "ben", "bnt", "bod", "bre", "bra", "bos", "btk", "bua", "bug", "byn", "cat", "cad", "cai", "car", "cau", "che", "ceb", "cel", "cha", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "cos", "cop", "cpe", "cpf", "cpp", "cre", "crh", "crp", "ces", "csb", "chu", "cus", "chv", "cym", "dan", "dak", "dar", "day", "deu", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "div", "dyu", "dzo", "ewe", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "spa", "est", "eus", "ewo", "fas", "fan", "fat", "ful", "fin", "fiu", "fij", "fao", "fon", "fra", "frm", "fro", "fur", "fry", "gle", "gaa", "gay", "gba", "gla", "gem", "gez", "gil", "glg", "gmh", "grn", "goh", "gon", "gor", "got", "grb", "grc", "guj", "glv", "gwi", "hau", "hai", "haw", "heb", "hin", "hil", "him", "hit", "hmn", "hmo", "hrv", "hsb", "hat", "hun", "hup", "hye", "her", "ina", "iba", "ind", "ile", "ibo", "iii", "ijo", "ipk", "ilo", "inc", "ine", "inh", "ido", "ira", "iro", "isl", "ita", "iku", "jpn", "jbo", "jpr", "jrb", "jaw", "kat", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kon", "kha", "khi", "kho", "kik", "kua", "kaz", "kal", "khm", "kmb", "kan", "kor", "kok", "kos", "kpe", "kau", "krc", "kro", "kru", "kas", "kur", "kum", "kut", "kom", "cor", "kir", "lat", "lad", "lah", "lam", "ltz", "lez", "lug", "lim", "lin", "lao", "lol", "loz", "lit", "lub", "lua", "lui", "lun", "luo", "lus", "lav", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mlg", "mga", "mah", "mri", "mic", "min", "mis", "mkd", "mkh", "mal", "mon", "mnc", "mni", "mno", "mol", "moh", "mos", "mar", "msa", "mlt", "mul", "mun", "mus", "mwr", "mya", "myn", "myv", "nau", "nah", "nai", "nap", "nob", "nde", "nds", "nep", "new", "ndo", "nia", "nic", "niu", "nld", "nno", "nor", "nog", "non", "nbl", "nso", "nub", "nav", "nwc", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "orm", "ori", "oss", "osa", "ota", "oto", "pan", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pli", "pol", "pon", "pra", "pro", "pus", "por", "que", "raj", "rap", "rar", "roh", "run", "ron", "roa", "rom", "rus", "rup", "kin", "san", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "srd", "sco", "snd", "sme", "sel", "sem", "sag", "sga", "sgn", "shn", "sin", "sid", "sio", "sit", "slk", "slv", "sla", "smo", "sma", "smi", "smj", "smn", "sms", "sna", "snk", "som", "sog", "son", "sqi", "srp", "srr", "ssw", "ssa", "sot", "sun", "suk", "sus", "sux", "swe", "swa", "syr", "tam", "tai", "tel", "tem", "ter", "tet", "tgk", "tha", "tir", "tig", "tiv", "tuk", "tkl", "tgl", "tlh", "tli", "tmh", "tsn", "ton", "tog", "tpi", "tur", "tso", "tsi", "tat", "tum", "tup", "tut", "tvl", "twi", "tah", "tyv", "udm", "uig", "uga", "ukr", "umb", "und", "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "wln", "wak", "wal", "war", "was", "wen", "wol", "xal", "xho", "yao", "yap", "yid", "yor", "ypk", "zha", "zap", "zen", "zho", "znd", "zul", "zun"};
        String[] tempObsoleteLanguages3 = new String[]{"ind", "heb", "yid", "jaw", "srp"};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_languages != null) return;
            _languages = tempLanguages;
            _replacementLanguages = tempReplacementLanguages;
            _obsoleteLanguages = tempObsoleteLanguages;
            _languages3 = tempLanguages3;
            _obsoleteLanguages3 = tempObsoleteLanguages3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initCountryTables() {
        if (_countries != null) return;
        String[] tempCountries = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZW"};
        String[] tempObsoleteCountries = new String[]{"FX", "RO", "TP", "ZR"};
        String[] tempDeprecatedCountries = new String[]{"BU", "DY", "FX", "HV", "NH", "RH", "TP", "YU", "ZR"};
        String[] tempReplacementCountries = new String[]{"MM", "BJ", "FR", "BF", "VU", "ZW", "TL", "CS", "CD"};
        String[] tempCountries3 = new String[]{"AND", "ARE", "AFG", "ATG", "AIA", "ALB", "ARM", "ANT", "AGO", "ATA", "ARG", "ASM", "AUT", "AUS", "ABW", "AZE", "BIH", "BRB", "BGD", "BEL", "BFA", "BGR", "BHR", "BDI", "BEN", "BMU", "BRN", "BOL", "BRA", "BHS", "BTN", "BVT", "BWA", "BLR", "BLZ", "CAN", "CCK", "COD", "CAF", "COG", "CHE", "CIV", "COK", "CHL", "CMR", "CHN", "COL", "CRI", "CUB", "CPV", "CXR", "CYP", "CZE", "DEU", "DJI", "DNK", "DMA", "DOM", "DZA", "ECU", "EST", "EGY", "ESH", "ERI", "ESP", "ETH", "FIN", "FJI", "FLK", "FSM", "FRO", "FRA", "GAB", "GBR", "GRD", "GEO", "GUF", "GHA", "GIB", "GRL", "GMB", "GIN", "GLP", "GNQ", "GRC", "SGS", "GTM", "GUM", "GNB", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IRL", "ISR", "IND", "IOT", "IRQ", "IRN", "ISL", "ITA", "JAM", "JOR", "JPN", "KEN", "KGZ", "KHM", "KIR", "COM", "KNA", "PRK", "KOR", "KWT", "CYM", "KAZ", "LAO", "LBN", "LCA", "LIE", "LKA", "LBR", "LSO", "LTU", "LUX", "LVA", "LBY", "MAR", "MCO", "MDA", "MDG", "MHL", "MKD", "MLI", "MMR", "MNG", "MAC", "MNP", "MTQ", "MRT", "MSR", "MLT", "MUS", "MDV", "MWI", "MEX", "MYS", "MOZ", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NLD", "NOR", "NPL", "NRU", "NIU", "NZL", "OMN", "PAN", "PER", "PYF", "PNG", "PHL", "PAK", "POL", "SPM", "PCN", "PRI", "PSE", "PRT", "PLW", "PRY", "QAT", "REU", "ROU", "RUS", "RWA", "SAU", "SLB", "SYC", "SDN", "SWE", "SGP", "SHN", "SVN", "SJM", "SVK", "SLE", "SMR", "SEN", "SOM", "SUR", "STP", "SLV", "SYR", "SWZ", "TCA", "TCD", "ATF", "TGO", "THA", "TJK", "TKL", "TLS", "TKM", "TUN", "TON", "TUR", "TTO", "TUV", "TWN", "TZA", "UKR", "UGA", "UMI", "USA", "URY", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "MYT", "YUG", "ZAF", "ZMB", "ZWE"};
        String[] tempObsoleteCountries3 = new String[]{"FXX", "ROM", "TMP", "ZAR"};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_countries != null) return;
            _countries = tempCountries;
            _deprecatedCountries = tempDeprecatedCountries;
            _replacementCountries = tempReplacementCountries;
            _obsoleteCountries = tempObsoleteCountries;
            _countries3 = tempCountries3;
            _obsoleteCountries3 = tempObsoleteCountries3;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initVariantsTable() {
        if (_variantsToKeywords != null) return;
        String[][] stringArrayArray = new String[52][];
        String[] stringArray = new String[4];
        stringArray[0] = "C";
        stringArray[1] = "en_US_POSIX";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[0] = "art_LOJBAN";
        stringArray2[1] = "jbo";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[4];
        stringArray3[0] = "az_AZ_CYRL";
        stringArray3[1] = "az_Cyrl_AZ";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[4];
        stringArray4[0] = "az_AZ_LATN";
        stringArray4[1] = "az_Latn_AZ";
        stringArrayArray[3] = stringArray4;
        stringArrayArray[4] = new String[]{"ca_ES_PREEURO", "ca_ES", "currency", "ESP"};
        String[] stringArray5 = new String[4];
        stringArray5[0] = "cel_GAULISH";
        stringArray5[1] = "cel__GAULISH";
        stringArrayArray[5] = stringArray5;
        String[] stringArray6 = new String[4];
        stringArray6[0] = "de_1901";
        stringArray6[1] = "de__1901";
        stringArrayArray[6] = stringArray6;
        String[] stringArray7 = new String[4];
        stringArray7[0] = "de_1906";
        stringArray7[1] = "de__1906";
        stringArrayArray[7] = stringArray7;
        stringArrayArray[8] = new String[]{"de__PHONEBOOK", "de", "collation", "phonebook"};
        stringArrayArray[9] = new String[]{"de_AT_PREEURO", "de_AT", "currency", "ATS"};
        stringArrayArray[10] = new String[]{"de_DE_PREEURO", "de_DE", "currency", "DEM"};
        stringArrayArray[11] = new String[]{"de_LU_PREEURO", "de_LU", "currency", "EUR"};
        stringArrayArray[12] = new String[]{"el_GR_PREEURO", "el_GR", "currency", "GRD"};
        String[] stringArray8 = new String[4];
        stringArray8[0] = "en_BOONT";
        stringArray8[1] = "en__BOONT";
        stringArrayArray[13] = stringArray8;
        String[] stringArray9 = new String[4];
        stringArray9[0] = "en_SCOUSE";
        stringArray9[1] = "en__SCOUSE";
        stringArrayArray[14] = stringArray9;
        stringArrayArray[15] = new String[]{"en_BE_PREEURO", "en_BE", "currency", "BEF"};
        stringArrayArray[16] = new String[]{"en_IE_PREEURO", "en_IE", "currency", "IEP"};
        stringArrayArray[17] = new String[]{"es__TRADITIONAL", "es", "collation", "traditional"};
        stringArrayArray[18] = new String[]{"es_ES_PREEURO", "es_ES", "currency", "ESP"};
        stringArrayArray[19] = new String[]{"eu_ES_PREEURO", "eu_ES", "currency", "ESP"};
        stringArrayArray[20] = new String[]{"fi_FI_PREEURO", "fi_FI", "currency", "FIM"};
        stringArrayArray[21] = new String[]{"fr_BE_PREEURO", "fr_BE", "currency", "BEF"};
        stringArrayArray[22] = new String[]{"fr_FR_PREEURO", "fr_FR", "currency", "FRF"};
        stringArrayArray[23] = new String[]{"fr_LU_PREEURO", "fr_LU", "currency", "LUF"};
        stringArrayArray[24] = new String[]{"ga_IE_PREEURO", "ga_IE", "currency", "IEP"};
        stringArrayArray[25] = new String[]{"gl_ES_PREEURO", "gl_ES", "currency", "ESP"};
        stringArrayArray[26] = new String[]{"hi__DIRECT", "hi", "collation", "direct"};
        stringArrayArray[27] = new String[]{"it_IT_PREEURO", "it_IT", "currency", "ITL"};
        stringArrayArray[28] = new String[]{"ja_JP_TRADITIONAL", "ja_JP", "calendar", "japanese"};
        stringArrayArray[29] = new String[]{"nl_BE_PREEURO", "nl_BE", "currency", "BEF"};
        stringArrayArray[30] = new String[]{"nl_NL_PREEURO", "nl_NL", "currency", "NLG"};
        stringArrayArray[31] = new String[]{"pt_PT_PREEURO", "pt_PT", "currency", "PTE"};
        String[] stringArray10 = new String[4];
        stringArray10[0] = "sl_ROZAJ";
        stringArray10[1] = "sl__ROZAJ";
        stringArrayArray[32] = stringArray10;
        String[] stringArray11 = new String[4];
        stringArray11[0] = "sr_SP_CYRL";
        stringArray11[1] = "sr_Cyrl_CS";
        stringArrayArray[33] = stringArray11;
        String[] stringArray12 = new String[4];
        stringArray12[0] = "sr_SP_LATN";
        stringArray12[1] = "sr_Latn_CS";
        stringArrayArray[34] = stringArray12;
        String[] stringArray13 = new String[4];
        stringArray13[0] = "sr_YU_CYRILLIC";
        stringArray13[1] = "sr_Cyrl_CS";
        stringArrayArray[35] = stringArray13;
        String[] stringArray14 = new String[4];
        stringArray14[0] = "uz_UZ_CYRILLIC";
        stringArray14[1] = "uz_Cyrl_UZ";
        stringArrayArray[36] = stringArray14;
        String[] stringArray15 = new String[4];
        stringArray15[0] = "uz_UZ_CYRL";
        stringArray15[1] = "uz_Cyrl_UZ";
        stringArrayArray[37] = stringArray15;
        String[] stringArray16 = new String[4];
        stringArray16[0] = "uz_UZ_LATN";
        stringArray16[1] = "uz_Latn_UZ";
        stringArrayArray[38] = stringArray16;
        String[] stringArray17 = new String[4];
        stringArray17[0] = "zh_CHS";
        stringArray17[1] = "zh_Hans";
        stringArrayArray[39] = stringArray17;
        String[] stringArray18 = new String[4];
        stringArray18[0] = "zh_CHT";
        stringArray18[1] = "zh_Hant";
        stringArrayArray[40] = stringArray18;
        String[] stringArray19 = new String[4];
        stringArray19[0] = "zh_GAN";
        stringArray19[1] = "zh__GAN";
        stringArrayArray[41] = stringArray19;
        String[] stringArray20 = new String[4];
        stringArray20[0] = "zh_GUOYU";
        stringArray20[1] = "zh";
        stringArrayArray[42] = stringArray20;
        String[] stringArray21 = new String[4];
        stringArray21[0] = "zh_HAKKA";
        stringArray21[1] = "zh__HAKKA";
        stringArrayArray[43] = stringArray21;
        String[] stringArray22 = new String[4];
        stringArray22[0] = "zh_MIN";
        stringArray22[1] = "zh__MIN";
        stringArrayArray[44] = stringArray22;
        String[] stringArray23 = new String[4];
        stringArray23[0] = "zh_MIN_NAN";
        stringArray23[1] = "zh__MINNAN";
        stringArrayArray[45] = stringArray23;
        String[] stringArray24 = new String[4];
        stringArray24[0] = "zh_WUU";
        stringArray24[1] = "zh__WUU";
        stringArrayArray[46] = stringArray24;
        String[] stringArray25 = new String[4];
        stringArray25[0] = "zh_XIANG";
        stringArray25[1] = "zh__XIANG";
        stringArrayArray[47] = stringArray25;
        String[] stringArray26 = new String[4];
        stringArray26[0] = "zh_YUE";
        stringArray26[1] = "zh__YUE";
        stringArrayArray[48] = stringArray26;
        stringArrayArray[49] = new String[]{"th_TH_TRADITIONAL", "th_TH", "calendar", "buddhist"};
        stringArrayArray[50] = new String[]{"zh_TW_STROKE", "zh_TW", "collation", "stroke"};
        stringArrayArray[51] = new String[]{"zh__PINYIN", "zh", "collation", "pinyin"};
        String[][] tempVariantsToKeywords = stringArrayArray;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_variantsToKeywords != null) return;
            _variantsToKeywords = tempVariantsToKeywords;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ULocale(String localeID, Locale locale) {
        this.localeID = localeID;
        this.locale = locale;
    }

    private ULocale(Locale loc) {
        this.localeID = ULocale.getName(loc.toString());
        this.locale = loc;
    }

    public static ULocale forLocale(Locale loc) {
        if (loc == null) {
            return null;
        }
        ULocale result = (ULocale)CACHE.get(loc);
        result = result == null && defaultULocale != null && loc == ULocale.defaultULocale.locale ? defaultULocale : new ULocale(loc.toString(), loc);
        return result;
    }

    public ULocale(String localeID) {
        this.localeID = ULocale.getName(localeID);
    }

    public ULocale(String a, String b) {
        this(a, b, null);
    }

    public ULocale(String a, String b, String c) {
        this.localeID = ULocale.getName(ULocale.lscvToID(a, b, c, EMPTY_STRING));
    }

    public static ULocale createCanonical(String nonCanonicalID) {
        return new ULocale(ULocale.canonicalize(nonCanonicalID), null);
    }

    private static String lscvToID(String lang, String script, String country, String variant) {
        StringBuffer buf = new StringBuffer();
        if (lang != null && lang.length() > 0) {
            buf.append(lang);
        }
        if (script != null && script.length() > 0) {
            buf.append('_');
            buf.append(script);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            if (country == null || country.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append(variant);
        }
        return buf.toString();
    }

    public Locale toLocale() {
        if (this.locale == null) {
            String[] names = new IDParser(this.localeID).getLanguageScriptCountryVariant();
            this.locale = new Locale(names[0], names[2], names[3]);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Locale defaultLocale = Locale.getDefault();
            if (defaultULocale == null || defaultULocale.toLocale() != defaultLocale) {
                defaultULocale = new ULocale(defaultLocale);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultULocale;
        }
    }

    public static synchronized void setDefault(ULocale newLocale) {
        Locale.setDefault(newLocale.toLocale());
        defaultULocale = newLocale;
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return this.localeID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof String) {
            return this.localeID.equals((String)obj);
        }
        if (obj instanceof ULocale) {
            return this.localeID.equals(((ULocale)obj).localeID);
        }
        return false;
    }

    public static ULocale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public static String[] getISOCountries() {
        ULocale.initCountryTables();
        return (String[])_countries.clone();
    }

    public static String[] getISOLanguages() {
        ULocale.initLanguageTables();
        return (String[])_languages.clone();
    }

    public String getLanguage() {
        return ULocale.getLanguage(this.localeID);
    }

    public static String getLanguage(String localeID) {
        return new IDParser(localeID).getLanguage();
    }

    public String getScript() {
        return ULocale.getScript(this.localeID);
    }

    public static String getScript(String localeID) {
        return new IDParser(localeID).getScript();
    }

    public String getCountry() {
        return ULocale.getCountry(this.localeID);
    }

    public static String getCountry(String localeID) {
        return new IDParser(localeID).getCountry();
    }

    public String getVariant() {
        return ULocale.getVariant(this.localeID);
    }

    public static String getVariant(String localeID) {
        return new IDParser(localeID).getVariant();
    }

    public static String getFallback(String localeID) {
        return ULocale.getFallbackString(ULocale.getName(localeID));
    }

    public ULocale getFallback() {
        if (this.localeID.length() == 0 || this.localeID.charAt(0) == '@') {
            return null;
        }
        return new ULocale(ULocale.getFallbackString(this.localeID), null);
    }

    private static String getFallbackString(String fallback) {
        int start;
        int limit = fallback.indexOf(64);
        if (limit == -1) {
            limit = fallback.length();
        }
        if ((start = fallback.lastIndexOf(95, limit)) == -1) {
            start = 0;
        }
        return String.valueOf(fallback.substring(0, start)) + fallback.substring(limit);
    }

    public String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String localeID) {
        return new IDParser(localeID).getBaseName();
    }

    public String getName() {
        return this.localeID;
    }

    public static String getName(String localeID) {
        return new IDParser(localeID).getName();
    }

    public String toString() {
        return this.localeID;
    }

    public Iterator getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    public static Iterator getKeywords(String localeID) {
        return new IDParser(localeID).getKeywords();
    }

    public String getKeywordValue(String keywordName) {
        return ULocale.getKeywordValue(this.localeID, keywordName);
    }

    public static String getKeywordValue(String localeID, String keywordName) {
        return new IDParser(localeID).getKeywordValue(keywordName);
    }

    private static int findIndex(String[] array, String target) {
        int i = 0;
        while (i < array.length) {
            if (target.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String canonicalize(String localeID) {
        int idx;
        IDParser parser = new IDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        ULocale.initVariantsTable();
        int i = 0;
        while (i < _variantsToKeywords.length) {
            if (_variantsToKeywords[i][0].equals(baseName)) {
                foundVariant = true;
                String[] vals = _variantsToKeywords[i];
                parser.setBaseName(vals[1]);
                if (vals[2] == null) break;
                parser.defaultKeywordValue(vals[2], vals[3]);
                break;
            }
            ++i;
        }
        if (!foundVariant && (idx = baseName.indexOf("_EURO")) > -1) {
            parser.setBaseName(baseName.substring(0, idx));
            parser.defaultKeywordValue("currency", "EUR");
        }
        if (!foundVariant && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        return parser.getName();
    }

    public ULocale setKeywordValue(String keyword, String value) {
        return new ULocale(ULocale.setKeywordValue(this.localeID, keyword, value), null);
    }

    public static String setKeywordValue(String localeID, String keyword, String value) {
        IDParser parser = new IDParser(localeID);
        parser.setKeywordValue(keyword, value);
        return parser.getName();
    }

    private static String defaultKeywordValue(String localeID, String keyword, String value) {
        IDParser parser = new IDParser(localeID);
        parser.defaultKeywordValue(keyword, value);
        return parser.getName();
    }

    public String getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    public static String getISO3Language(String localeID) {
        ULocale.initLanguageTables();
        String language = ULocale.getLanguage(localeID);
        int offset = ULocale.findIndex(_languages, language);
        if (offset >= 0) {
            return _languages3[offset];
        }
        offset = ULocale.findIndex(_obsoleteLanguages, language);
        if (offset >= 0) {
            return _obsoleteLanguages3[offset];
        }
        return EMPTY_STRING;
    }

    public String getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    public static String getISO3Country(String localeID) {
        ULocale.initCountryTables();
        String country = ULocale.getCountry(localeID);
        int offset = ULocale.findIndex(_countries, country);
        if (offset >= 0) {
            return _countries3[offset];
        }
        offset = ULocale.findIndex(_obsoleteCountries, country);
        if (offset >= 0) {
            return _obsoleteCountries3[offset];
        }
        return EMPTY_STRING;
    }

    private static String getTableString(String tableName, String subtableName, String item, String displayLocaleID) {
        if (item.length() > 0) {
            try {
                ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", displayLocaleID);
                return ULocale.getTableString(tableName, subtableName, item, bundle);
            }
            catch (Exception exception) {}
        }
        return item;
    }

    private static String getTableString(String tableName, String subtableName, String item, ICUResourceBundle bundle) {
        try {
            while (true) {
                ICUResourceBundle table;
                if ("currency".equals(subtableName)) {
                    table = bundle.getWithFallback("Currencies");
                    table = table.getWithFallback(item);
                    return table.getString(1);
                }
                table = bundle.getWithFallback(tableName);
                try {
                    if (subtableName != null) {
                        table = table.getWithFallback(subtableName);
                    }
                    return table.getStringWithFallback(item);
                }
                catch (MissingResourceException missingResourceException) {
                    String fallbackLocale;
                    if (subtableName == null) {
                        try {
                            String currentName = null;
                            if (tableName.equals("Countries")) {
                                currentName = ULocale.getCurrentCountryID(item);
                            } else if (tableName.equals("Languages")) {
                                currentName = ULocale.getCurrentLanguageID(item);
                            }
                            return table.getStringWithFallback(currentName);
                        }
                        catch (MissingResourceException missingResourceException2) {}
                    }
                    if ((fallbackLocale = table.getWithFallback("Fallback").getString()).length() == 0) {
                        fallbackLocale = "root";
                    }
                    if (fallbackLocale.equals(table.getULocale().localeID)) {
                        return item;
                    }
                    bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", fallbackLocale);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return item;
        }
    }

    public String getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayLanguage(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayLanguage(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayLanguage(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(localeID, displayLocale.localeID);
    }

    static String getCurrentCountryID(String oldID) {
        ULocale.initCountryTables();
        int offset = ULocale.findIndex(_deprecatedCountries, oldID);
        if (offset >= 0) {
            return _replacementCountries[offset];
        }
        return oldID;
    }

    static String getCurrentLanguageID(String oldID) {
        ULocale.initLanguageTables();
        int offset = ULocale.findIndex(_obsoleteLanguages, oldID);
        if (offset >= 0) {
            return _replacementLanguages[offset];
        }
        return oldID;
    }

    private static String getDisplayLanguageInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Languages", null, new IDParser(localeID).getLanguage(), displayLocaleID);
    }

    public String getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayScript(ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayScript(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayScript(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayScriptInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Scripts", null, new IDParser(localeID).getScript(), displayLocaleID);
    }

    public String getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayCountry(ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayCountry(String localeID, String displayLocaleID) {
        return ULocale.getDisplayCountryInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayCountry(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayCountryInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Countries", null, new IDParser(localeID).getCountry(), displayLocaleID);
    }

    public String getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayVariant(ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayVariant(String localeID, String displayLocaleID) {
        return ULocale.getDisplayVariantInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayVariant(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayVariantInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Variants", null, new IDParser(localeID).getVariant(), displayLocaleID);
    }

    public static String getDisplayKeyword(String keyword) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getDefault().localeID);
    }

    public static String getDisplayKeyword(String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeyword(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordInternal(keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordInternal(String keyword, String displayLocaleID) {
        return ULocale.getTableString("Keys", null, keyword.trim().toLowerCase(), displayLocaleID);
    }

    public String getDisplayKeywordValue(String keyword) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, ULocale.getDefault().localeID);
    }

    public String getDisplayKeywordValue(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, displayLocale.localeID);
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordValueInternal(String localeID, String keyword, String displayLocaleID) {
        keyword = keyword.trim().toLowerCase();
        String value = new IDParser(localeID).getKeywordValue(keyword);
        return ULocale.getTableString("Types", keyword, value, displayLocaleID);
    }

    public String getDisplayName() {
        return ULocale.getDisplayNameInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayName(ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayName(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayName(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayNameInternal(String localeID, String displayLocaleID) {
        String[] tableNames = new String[]{"Languages", "Scripts", "Countries", "Variants"};
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", displayLocaleID);
        StringBuffer buf = new StringBuffer();
        IDParser parser = new IDParser(localeID);
        String[] names = parser.getLanguageScriptCountryVariant();
        boolean haveLanguage = names[0].length() > 0;
        boolean openParen = false;
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (name.length() > 0) {
                name = ULocale.getTableString(tableNames[i], null, name, bundle);
                if (buf.length() > 0) {
                    if (haveLanguage & !openParen) {
                        buf.append(" (");
                        openParen = true;
                    } else {
                        buf.append(", ");
                    }
                }
                buf.append(name);
            }
            ++i;
        }
        Map m = parser.getKeywordMap();
        if (!m.isEmpty()) {
            Iterator keys = m.entrySet().iterator();
            while (keys.hasNext()) {
                if (buf.length() > 0) {
                    if (haveLanguage & !openParen) {
                        buf.append(" (");
                        openParen = true;
                    } else {
                        buf.append(", ");
                    }
                }
                Map.Entry e = keys.next();
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(ULocale.getTableString("Keys", null, key, bundle));
                buf.append("=");
                buf.append(ULocale.getTableString("Types", key, val, bundle));
            }
        }
        if (openParen) {
            buf.append(")");
        }
        return buf.toString();
    }

    public static ULocale acceptLanguage(String acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        class ULocaleAcceptLanguageQ
        implements Comparable {
            private double q;
            private double serial;

            public ULocaleAcceptLanguageQ(double theq, int theserial) {
                this.q = theq;
                this.serial = theserial;
            }

            public int compareTo(Object o) {
                ULocaleAcceptLanguageQ other = (ULocaleAcceptLanguageQ)o;
                if (this.q > other.q) {
                    return -1;
                }
                if (this.q < other.q) {
                    return 1;
                }
                if (this.serial < other.serial) {
                    return -1;
                }
                if (this.serial > other.serial) {
                    return 1;
                }
                return 0;
            }
        }
        TreeMap<ULocaleAcceptLanguageQ, ULocale> map = new TreeMap<ULocaleAcceptLanguageQ, ULocale>();
        int l = acceptLanguageList.length();
        int n = 0;
        while (n < l) {
            int itemEnd = acceptLanguageList.indexOf(44, n);
            if (itemEnd == -1) {
                itemEnd = l;
            }
            int paramEnd = acceptLanguageList.indexOf(59, n);
            double q = 1.0;
            if (paramEnd != -1 && paramEnd < itemEnd) {
                int t = paramEnd + 1;
                while (UCharacter.isWhitespace(acceptLanguageList.charAt(t))) {
                    ++t;
                }
                if (acceptLanguageList.charAt(t) == 'q') {
                    ++t;
                }
                while (UCharacter.isWhitespace(acceptLanguageList.charAt(t))) {
                    ++t;
                }
                if (acceptLanguageList.charAt(t) == '=') {
                    ++t;
                }
                while (UCharacter.isWhitespace(acceptLanguageList.charAt(t))) {
                    ++t;
                }
                try {
                    String val = acceptLanguageList.substring(t, itemEnd).trim();
                    q = Double.parseDouble(val);
                }
                catch (NumberFormatException numberFormatException) {
                    q = 1.0;
                }
            } else {
                q = 1.0;
                paramEnd = itemEnd;
            }
            String loc = acceptLanguageList.substring(n, paramEnd).trim();
            int serial = map.size();
            ULocaleAcceptLanguageQ entry = new ULocaleAcceptLanguageQ(q, serial);
            map.put(entry, new ULocale(ULocale.canonicalize(loc)));
            n = itemEnd;
            ++n;
        }
        ULocale[] acceptList = map.values().toArray(new ULocale[map.size()]);
        return ULocale.acceptLanguage(acceptList, availableLocales, fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (fallback != null) {
            fallback[0] = true;
        }
        int i = 0;
        while (i < acceptLanguageList.length) {
            ULocale aLocale = acceptLanguageList[i];
            boolean[] setFallback = fallback;
            do {
                int j = 0;
                while (j < availableLocales.length) {
                    if (availableLocales[j].equals(aLocale)) {
                        if (setFallback != null) {
                            setFallback[0] = false;
                        }
                        return availableLocales[j];
                    }
                    ++j;
                }
                Locale loc = aLocale.toLocale();
                Locale parent = LocaleUtility.fallback(loc);
                aLocale = parent != null ? new ULocale(parent) : null;
                setFallback = null;
            } while (aLocale != null);
            ++i;
        }
        return null;
    }

    public static ULocale acceptLanguage(String acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    private static final class IDParser {
        private char[] id;
        private int index;
        private char[] buffer;
        private int blen;
        private boolean canonicalize;
        private boolean hadCountry;
        Map keywords;
        String baseName;
        private static final char KEYWORD_SEPARATOR = '@';
        private static final char HYPHEN = '-';
        private static final char KEYWORD_ASSIGN = '=';
        private static final char COMMA = ',';
        private static final char ITEM_SEPARATOR = ';';
        private static final char DOT = '.';
        private static final char DONE = '\uffff';

        IDParser(String localeID) {
            this(localeID, false);
        }

        IDParser(String localeID, boolean canonicalize) {
            this.id = localeID.toCharArray();
            this.index = 0;
            this.buffer = new char[this.id.length + 5];
            this.blen = 0;
            this.canonicalize = canonicalize;
        }

        private void reset() {
            this.blen = 0;
            this.index = 0;
        }

        private void append(char c) {
            try {
                this.buffer[this.blen] = c;
            }
            catch (IndexOutOfBoundsException e) {
                if (this.buffer.length > 512) {
                    throw e;
                }
                char[] nbuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, nbuffer, 0, this.buffer.length);
                nbuffer[this.blen] = c;
                this.buffer = nbuffer;
            }
            ++this.blen;
        }

        private void addSeparator() {
            this.append('_');
        }

        private String getString(int start) {
            if (start == this.blen) {
                return ULocale.EMPTY_STRING;
            }
            return new String(this.buffer, start, this.blen - start);
        }

        private void set(int pos, String s) {
            this.blen = pos;
            this.append(s);
        }

        private void append(String s) {
            int i = 0;
            while (i < s.length()) {
                this.append(s.charAt(i));
                ++i;
            }
        }

        private char next() {
            if (this.index == this.id.length) {
                ++this.index;
                return '\uffff';
            }
            return this.id[this.index++];
        }

        private void skipUntilTerminatorOrIDSeparator() {
            while (!this.isTerminatorOrIDSeparator(this.next())) {
            }
            --this.index;
        }

        private boolean atTerminator() {
            return this.index >= this.id.length || this.isTerminator(this.id[this.index]);
        }

        private boolean isIDSeparator(char c) {
            return c == '_' || c == '-';
        }

        private boolean isTerminator(char c) {
            return c == '@' || c == '\uffff' || c == '.';
        }

        private boolean isTerminatorOrIDSeparator(char c) {
            return c == '@' || c == '_' || c == '-' || c == '\uffff' || c == '.';
        }

        private boolean haveExperimentalLanguagePrefix() {
            char c;
            if (this.id.length > 2 && ((c = this.id[1]) == '-' || c == '_')) {
                c = this.id[0];
                return c == 'x' || c == 'X' || c == 'i' || c == 'I';
            }
            return false;
        }

        private boolean haveKeywordAssign() {
            int i = this.index;
            while (i < this.id.length) {
                if (this.id[i] == '=') {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private int parseLanguage() {
            char c;
            if (this.haveExperimentalLanguagePrefix()) {
                this.append(Character.toLowerCase(this.id[0]));
                this.append('-');
                this.index = 2;
            }
            while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                this.append(Character.toLowerCase(c));
            }
            --this.index;
            if (this.blen == 3) {
                ULocale.initLanguageTables();
                String lang = this.getString(0);
                int offset = ULocale.findIndex(_languages3, lang);
                if (offset >= 0) {
                    this.set(0, _languages[offset]);
                } else {
                    offset = ULocale.findIndex(_obsoleteLanguages3, lang);
                    if (offset >= 0) {
                        this.set(0, _obsoleteLanguages[offset]);
                    }
                }
            }
            return 0;
        }

        private void skipLanguage() {
            if (this.haveExperimentalLanguagePrefix()) {
                this.index = 2;
            }
            this.skipUntilTerminatorOrIDSeparator();
        }

        private int parseScript() {
            if (!this.atTerminator()) {
                char c;
                int oldIndex = this.index++;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (this.blen == oldBlen) {
                        this.addSeparator();
                        this.append(Character.toUpperCase(c));
                        continue;
                    }
                    this.append(Character.toLowerCase(c));
                }
                --this.index;
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                    this.blen = oldBlen;
                } else {
                    ++oldBlen;
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipScript() {
            if (!this.atTerminator()) {
                int oldIndex = this.index++;
                this.skipUntilTerminatorOrIDSeparator();
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                }
            }
        }

        private int parseCountry() {
            if (!this.atTerminator()) {
                char c;
                ++this.index;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (oldBlen == this.blen) {
                        this.hadCountry = true;
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.append(Character.toUpperCase(c));
                }
                --this.index;
                if (this.blen - oldBlen == 3) {
                    ULocale.initCountryTables();
                    int offset = ULocale.findIndex(_countries3, this.getString(oldBlen));
                    if (offset >= 0) {
                        this.set(oldBlen, _countries[offset]);
                    } else {
                        offset = ULocale.findIndex(_obsoleteCountries3, this.getString(oldBlen));
                        if (offset >= 0) {
                            this.set(oldBlen, _obsoleteCountries[offset]);
                        }
                    }
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipCountry() {
            if (!this.atTerminator()) {
                ++this.index;
                this.skipUntilTerminatorOrIDSeparator();
            }
        }

        private int parseVariant() {
            char c;
            int oldBlen = this.blen;
            boolean start = true;
            boolean needSeparator = true;
            boolean skipping = false;
            while ((c = this.next()) != '\uffff') {
                if (c == '.') {
                    start = false;
                    skipping = true;
                    continue;
                }
                if (c == '@') {
                    if (this.haveKeywordAssign()) break;
                    skipping = false;
                    start = false;
                    needSeparator = true;
                    continue;
                }
                if (start) {
                    start = false;
                    continue;
                }
                if (skipping) continue;
                if (needSeparator) {
                    boolean incOldBlen = this.blen == oldBlen;
                    needSeparator = false;
                    if (incOldBlen && !this.hadCountry) {
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.addSeparator();
                    if (incOldBlen) {
                        ++oldBlen;
                    }
                }
                if ((c = Character.toUpperCase(c)) == '-' || c == ',') {
                    c = '_';
                }
                this.append(c);
            }
            --this.index;
            return oldBlen;
        }

        public String getLanguage() {
            this.reset();
            return this.getString(this.parseLanguage());
        }

        public String getScript() {
            this.reset();
            this.skipLanguage();
            return this.getString(this.parseScript());
        }

        public String getCountry() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            return this.getString(this.parseCountry());
        }

        public String getVariant() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            this.skipCountry();
            return this.getString(this.parseVariant());
        }

        public String[] getLanguageScriptCountryVariant() {
            this.reset();
            return new String[]{this.getString(this.parseLanguage()), this.getString(this.parseScript()), this.getString(this.parseCountry()), this.getString(this.parseVariant())};
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void parseBaseName() {
            if (this.baseName != null) {
                this.set(0, this.baseName);
            } else {
                this.reset();
                this.parseLanguage();
                this.parseScript();
                this.parseCountry();
                this.parseVariant();
                if (this.blen > 1 && this.buffer[this.blen - 1] == '_') {
                    --this.blen;
                }
            }
        }

        public String getBaseName() {
            if (this.baseName != null) {
                return this.baseName;
            }
            this.parseBaseName();
            return this.getString(0);
        }

        public String getName() {
            this.parseBaseName();
            this.parseKeywords();
            return this.getString(0);
        }

        private boolean setToKeywordStart() {
            int i = this.index;
            while (i < this.id.length) {
                if (this.id[i] == '@') {
                    if (this.canonicalize) {
                        int j = ++i;
                        while (j < this.id.length) {
                            if (this.id[j] == '=') {
                                this.index = i;
                                return true;
                            }
                            ++j;
                        }
                        break;
                    }
                    if (++i >= this.id.length) break;
                    this.index = i;
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isDoneOrKeywordAssign(char c) {
            return c == '\uffff' || c == '=';
        }

        private static boolean isDoneOrItemSeparator(char c) {
            return c == '\uffff' || c == ';';
        }

        private String getKeyword() {
            int start = this.index;
            while (!IDParser.isDoneOrKeywordAssign(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim().toLowerCase();
        }

        private String getValue() {
            int start = this.index;
            while (!IDParser.isDoneOrItemSeparator(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim();
        }

        private Comparator getKeyComparator() {
            Comparator comp = new Comparator(this){
                final /* synthetic */ IDParser this$1;
                {
                    this.this$1 = iDParser;
                }

                public int compare(Object lhs, Object rhs) {
                    return ((String)lhs).compareTo((String)rhs);
                }
            };
            return comp;
        }

        private Map getKeywordMap() {
            block6: {
                TreeMap<String, String> m;
                block7: {
                    String key;
                    if (this.keywords != null) break block6;
                    m = null;
                    if (!this.setToKeywordStart()) break block7;
                    while ((key = this.getKeyword()).length() != 0) {
                        block9: {
                            String value;
                            block11: {
                                block10: {
                                    block8: {
                                        char c = this.next();
                                        if (c == '=') break block8;
                                        if (c == '\uffff') {
                                            break;
                                        }
                                        break block9;
                                    }
                                    value = this.getValue();
                                    if (value.length() == 0) break block9;
                                    if (m != null) break block10;
                                    m = new TreeMap<String, String>(this.getKeyComparator());
                                    break block11;
                                }
                                if (m.containsKey(key)) break block9;
                            }
                            m.put(key, value);
                        }
                        if (this.next() == ';') continue;
                    }
                }
                this.keywords = m != null ? m : Collections.EMPTY_MAP;
            }
            return this.keywords;
        }

        private int parseKeywords() {
            int oldBlen = this.blen;
            Map m = this.getKeywordMap();
            if (!m.isEmpty()) {
                Iterator iter = m.entrySet().iterator();
                boolean first = true;
                while (iter.hasNext()) {
                    this.append(first ? (char)'@' : ';');
                    first = false;
                    Map.Entry e = iter.next();
                    this.append((String)e.getKey());
                    this.append('=');
                    this.append((String)e.getValue());
                }
                if (this.blen != oldBlen) {
                    ++oldBlen;
                }
            }
            return oldBlen;
        }

        public Iterator getKeywords() {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : m.keySet().iterator();
        }

        public String getKeywordValue(String keywordName) {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : (String)m.get(keywordName.trim().toLowerCase());
        }

        public void defaultKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, false);
        }

        public void setKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, true);
        }

        private void setKeywordValue(String keywordName, String value, boolean reset) {
            if (keywordName == null) {
                if (reset) {
                    this.keywords = Collections.EMPTY_MAP;
                }
            } else {
                if ((keywordName = keywordName.trim().toLowerCase()).length() == 0) {
                    throw new IllegalArgumentException("keyword must not be empty");
                }
                if (value != null && (value = value.trim()).length() == 0) {
                    throw new IllegalArgumentException("value must not be empty");
                }
                Map m = this.getKeywordMap();
                if (m.isEmpty()) {
                    if (value != null) {
                        this.keywords = new TreeMap(this.getKeyComparator());
                        this.keywords.put(keywordName, value.trim());
                    }
                } else if (reset || !m.containsKey(keywordName)) {
                    if (value != null) {
                        m.put(keywordName, value);
                    } else {
                        m.remove(keywordName);
                        if (m.isEmpty()) {
                            this.keywords = Collections.EMPTY_MAP;
                        }
                    }
                }
            }
        }
    }

    public static final class Type {
        private int localeType;

        private Type(int type) {
            this.localeType = type;
        }
    }
}

