/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.SiteWithTimestamp;

public class ExtendedSite
extends SiteWithTimestamp {
    private boolean digestExist;
    private String[] availableLanguages;
    private String[] availableLocals;
    private String digestURL;
    private LiteFeature[] liteFeatures;
    private IURLEntry[] associateSites;
    private boolean pack200 = false;

    public String getDigestURL() {
        return this.digestURL;
    }

    public void setDigestURL(String digestURL) {
        this.digestURL = digestURL;
    }

    public String[] getAvailableLanguages() {
        return this.availableLanguages;
    }

    public void setAvailableLanguages(String[] availableLanguages) {
        this.availableLanguages = availableLanguages;
    }

    public String[] getAvailableLocals() {
        return this.availableLocals;
    }

    public void setAvailableLocals(String[] availableLocals) {
        this.availableLocals = availableLocals;
    }

    public boolean isDigestExist() {
        return this.digestExist;
    }

    public void setDigestExist(boolean digestExist) {
        this.digestExist = digestExist;
    }

    public LiteFeature[] getLiteFeatures() {
        if (this.getCurrentConfiguredSite() != null) {
            return this.filterFeatures(this.getNonFilteredLiteFeatures());
        }
        return this.getNonFilteredLiteFeatures();
    }

    public void setLiteFeatures(LiteFeature[] liteFeatures) {
        this.liteFeatures = liteFeatures;
    }

    public LiteFeature[] getNonFilteredLiteFeatures() {
        return this.liteFeatures;
    }

    public void setNonFilteredLiteFeatures(LiteFeature[] liteFeatures) {
        this.liteFeatures = liteFeatures;
    }

    public boolean supportsPack200() {
        return this.pack200;
    }

    public void setSupportsPack200(boolean pack) {
        this.pack200 = pack;
    }

    private LiteFeature[] filterFeatures(LiteFeature[] allIncluded) {
        ArrayList<LiteFeature> list = new ArrayList<LiteFeature>();
        if (allIncluded != null) {
            int i = 0;
            while (i < allIncluded.length) {
                LiteFeature included = allIncluded[i];
                if (UpdateManagerUtils.isValidEnvironment(included)) {
                    list.add(included);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + included);
                }
                ++i;
            }
        }
        LiteFeature[] result = new LiteFeature[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public IURLEntry[] getAssociateSites() {
        return this.associateSites;
    }

    public void setAssociateSites(IURLEntry[] associateSites) {
        this.associateSites = associateSites;
    }
}

