/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.internal.core.DeltaInstallHandler;

public class JarDeltaInstallHandler
extends DeltaInstallHandler {
    protected void overlayPlugin(IPluginEntry oldPlugin, IPluginEntry newPlugin, IFeatureContentConsumer consumer) throws CoreException, IOException {
        if (newPlugin instanceof PluginEntry && ((PluginEntry)newPlugin).isUnpack()) {
            super.overlayPlugin(oldPlugin, newPlugin, consumer);
        }
        this.oldFeature.getFeatureContentProvider().getPluginEntryContentReferences(oldPlugin, null);
        this.feature.getFeatureContentProvider().getPluginEntryContentReferences(newPlugin, null);
        URI oldURI = null;
        try {
            oldURI = new URI(String.valueOf(consumer.getFeature().getSite().getURL().getPath()) + "plugins/" + oldPlugin.getVersionedIdentifier().toString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        File oldJarFile = new File(oldURI);
        JarFile oldJar = new JarFile(oldJarFile);
        URI newURI = null;
        try {
            newURI = new URI(String.valueOf(consumer.getFeature().getSite().getURL().getPath()) + "plugins/" + newPlugin.getVersionedIdentifier().toString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        File newJarFile = new File(newURI);
        JarFile newJar = new JarFile(newJarFile);
        String tempFileName = oldURI + "-" + new Date().getTime();
        File tempFile = new File(tempFileName);
        FileOutputStream fos = new FileOutputStream(tempFile);
        JarOutputStream jos = new JarOutputStream(fos);
        JarDeltaInstallHandler.addToJar(jos, newJar);
        JarDeltaInstallHandler.addToJar(jos, oldJar);
        jos.closeEntry();
        jos.finish();
        fos.close();
        newJar.close();
        oldJar.close();
        newJarFile = new File(newURI);
        newJarFile.delete();
        newJarFile.createNewFile();
        FileChannel in = new FileInputStream(tempFile).getChannel();
        FileChannel out = new FileOutputStream(newJarFile).getChannel();
        in.transferTo(0L, in.size(), out);
        in.close();
        out.close();
    }

    public static void addToJar(JarOutputStream jos, JarFile jf) throws IOException {
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            ZipEntry je = e.nextElement();
            InputStream io = jf.getInputStream(je);
            byte[] b = new byte[4096];
            int read = 0;
            jos.putNextEntry(je);
            while ((read = io.read(b, 0, 4096)) != -1) {
                jos.write(b, 0, read);
            }
        }
    }
}

