/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.util.IFileManager;
import java.io.File;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.util.PersistenceResources;
import sun.security.action.GetPropertyAction;

public class FileManager
implements IFileManager {
    public static final String PLUGIN_ID;
    private static FileManager instance;
    private static String tmpdir;
    private boolean validateEditInitialized = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.persistence.FileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PLUGIN_ID = clazz.getPackage().getName();
        instance = null;
    }

    public static String getTempDir() {
        if (tmpdir == null) {
            GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
            tmpdir = AccessController.doPrivileged(a);
        }
        return tmpdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FileManager getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.persistence.FileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new FileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FileManager() {
    }

    public static IResource getResourceForLocation(String location) {
        IFile resource;
        File file = new File(location);
        if (!file.exists()) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(location);
        if (file.isFile()) {
            IResource parentResource;
            resource = workspaceRoot.getFileForLocation((IPath)path);
            if (resource == null && (parentResource = FileManager.getResourceForLocation(file.getParent())) != null) {
                try {
                    parentResource.refreshLocal(1, null);
                }
                catch (CoreException e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
                resource = workspaceRoot.getFileForLocation((IPath)path);
            }
        } else {
            resource = workspaceRoot.getContainerForLocation((IPath)path);
        }
        return resource;
    }

    public static boolean refresh(IResource resource) throws CoreException {
        if (!resource.exists()) {
            ArrayList<IContainer> foldersToRefresh = new ArrayList<IContainer>();
            IContainer container = resource.getParent();
            while (!container.exists()) {
                foldersToRefresh.add(0, container);
                container = container.getParent();
            }
            if (container.exists()) {
                container.refreshLocal(1, null);
            }
            if (!foldersToRefresh.isEmpty()) {
                Iterator iter = foldersToRefresh.iterator();
                while (iter.hasNext()) {
                    IFolder folder = (IFolder)iter.next();
                    if (folder.exists()) {
                        folder.refreshLocal(1, null);
                        continue;
                    }
                    return false;
                }
            }
        }
        resource.refreshLocal(1, null);
        return true;
    }

    private static boolean refresh(String path) throws CoreException {
        IResource resource = FileManager.getResourceForLocation(path);
        if (resource != null) {
            return FileManager.refresh(resource);
        }
        return false;
    }

    public boolean refresh(Resource resource) {
        try {
            return FileManager.refresh(resource.getURI().toFileString());
        }
        catch (CoreException e) {
            CommonPlugin.INSTANCE.log((Object)e);
            return false;
        }
    }

    public boolean move(String oldPath, String newPath) {
        return this.move(oldPath, newPath, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean move(String oldPath, String newPath, boolean forceRemoveSource) {
        block15: {
            try {
                block16: {
                    FileManager.refresh(oldPath);
                    resource /* !! */  = null;
                    workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    destPath = new Path(newPath);
                    resource /* !! */  = new File(oldPath).isFile() != false ? workspaceRoot.getFileForLocation((IPath)destPath) : workspaceRoot.getContainerForLocation((IPath)destPath);
                    if (resource /* !! */ .exists()) {
                        throw new MultiFileIOException(PersistenceResources.formatString("Persistence.moveError.msg", oldPath, newPath));
                    }
                    foldersToCreate = new ArrayList<IContainer>();
                    container = resource /* !! */ .getParent();
                    while (!container.exists()) {
                        foldersToCreate.add(0, container);
                        container = container.getParent();
                    }
                    if (!foldersToCreate.isEmpty()) {
                        container.refreshLocal(1, null);
                        iter = foldersToCreate.iterator();
                        while (iter.hasNext()) {
                            folder = (IFolder)iter.next();
                            if (!folder.exists()) {
                                folder.create(true, true, null);
                                continue;
                            }
                            folder.refreshLocal(1, null);
                        }
                    }
                    destPath = resource /* !! */ .getFullPath();
                    path = new Path(oldPath);
                    file = workspaceRoot.getFileForLocation((IPath)path);
                    resource /* !! */  = file != null && file.exists() != false ? file : workspaceRoot.getContainerForLocation((IPath)path);
                    if (resource /* !! */  == null) break block15;
                    try {
                        resource /* !! */ .move((IPath)destPath, true, null);
                        break block16;
                    }
                    catch (ResourceException e) {
                        if (forceRemoveSource) {
                            throw e;
                        }
                        failed = false;
                        statuses = e.getStatus().getChildren();
                        i = 0;
                        ** while (i < statuses.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        status = statuses[i];
                        if (status.getCode() == 273 && status.getMessage() == Messages.localstore_deleteProblem) {
                            msg = MessageFormat.format("Warning while moving ''{0}'' to ''{1}'': {2}", new Object[]{oldPath, newPath, status.getMessage()});
                            CommonPlugin.INSTANCE.log((Object)msg);
                        } else {
                            failed = true;
                        }
                        ++i;
                        continue;
                    }
lbl49:
                    // 1 sources

                    if (failed || !new File(newPath).exists()) {
                        return false;
                    }
                }
                return true;
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        return false;
    }

    public boolean rename(File oldFile, File newFile) {
        return this.move(oldFile.getAbsolutePath(), newFile.getAbsolutePath());
    }

    public void deleteResource(String path, IProgressMonitor monitor) throws CoreException {
        IResource resource = FileManager.getResourceForLocation(path);
        if (resource != null) {
            resource.delete(true, monitor);
        }
    }

    public boolean delete(String path) {
        try {
            this.deleteResource(path, null);
            return true;
        }
        catch (CoreException e) {
            CommonPlugin.INSTANCE.log((Object)e);
            return false;
        }
    }

    private static boolean fromCC(IStatus status) {
        String pluginId = status.getPlugin();
        return pluginId != null && pluginId.toLowerCase().indexOf("clearcase") != -1;
    }

    public IStatus checkModify(String[] paths, Object context) {
        IFile file;
        IStatus status = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = new IFile[paths.length];
        ArrayList<String> notFoundFiles = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            try {
                FileManager.refresh(path);
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
            file = workspace.getRoot().getFileForLocation((IPath)new Path(path));
            if (file == null) {
                notFoundFiles.add(path);
            } else {
                files[i] = file;
            }
            ++i;
        }
        if (!notFoundFiles.isEmpty()) {
            return new Status(2, PLUGIN_ID, 2, PersistenceResources.formatString("Persistence.fileNotFoundError.msg", notFoundFiles), null);
        }
        if (!this.validateEditInitialized) {
            status = workspace.validateEdit(files, context);
            this.validateEditInitialized = true;
            if (status.isOK()) {
                status = workspace.validateEdit(files, context);
            }
        } else {
            status = workspace.validateEdit(files, context);
        }
        if (status.isOK()) {
            ArrayList<IFile> readOnlyFiles = new ArrayList<IFile>();
            int i2 = 0;
            while (i2 < files.length) {
                file = files[i2];
                try {
                    file.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
                if (file.isReadOnly()) {
                    readOnlyFiles.add(file);
                }
                ++i2;
            }
            if (!readOnlyFiles.isEmpty()) {
                MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, 0, PersistenceResources.getString("Persistence.modifyFilesError.msg"), null);
                Iterator iter = readOnlyFiles.iterator();
                while (iter.hasNext()) {
                    IFile file2 = (IFile)iter.next();
                    String localPath = file2.getLocation().toOSString();
                    String msg = MessageFormat.format(PersistenceResources.getString("Persistence.FileManager.fileReadOnly"), localPath);
                    multiStatus.add((IStatus)new ResourceStatus(4, 0, file2.getFullPath(), msg, null));
                }
                status = multiStatus;
                return status;
            }
        } else if (FileManager.fromCC(status)) {
            String msg = PersistenceResources.getString("Persistence.modifyFilesError.msg");
            MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, status.getCode(), msg, null);
            multiStatus.add(status);
            return multiStatus;
        }
        if (status instanceof MultiStatus) {
            MultiStatus ms = (MultiStatus)status;
            int i3 = 0;
            while (i3 < ms.getChildren().length) {
                IStatus childStatus = ms.getChildren()[i3];
                if (childStatus instanceof IResourceStatus && childStatus.getCode() == 279) {
                    IResourceStatus resourceStatus = (IResourceStatus)childStatus;
                    IPath path = resourceStatus.getPath();
                    IFile file3 = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    String localPath = file3.getLocation().toOSString();
                    String msg = MessageFormat.format(PersistenceResources.getString("Persistence.FileManager.fileReadOnly"), localPath);
                    ms.getChildren()[i3] = new ResourceStatus(childStatus.getSeverity(), childStatus.getCode(), resourceStatus.getPath(), msg, childStatus.getException());
                }
                ++i3;
            }
        }
        return status;
    }

    public IStatus checkModify(String path, Object context) {
        return this.checkModify(new String[]{path}, context);
    }
}

