/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.MethodUnit;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;

public class MethodLibraryPersister
implements IMethodLibraryPersister {
    public static final MethodLibraryPersister INSTANCE = new MethodLibraryPersister();
    public static final String RESOURCE_FOLDER = "resources";
    private static final List folderInfos = new ArrayList();
    protected List warnings;
    private static final IMethodLibraryPersister.FailSafeMethodLibraryPersister nonFailSafePersister;

    static {
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getGuidance(), false));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getWorkProduct(), true));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getActivity(), true));
        nonFailSafePersister = new NonFailSafePersister();
    }

    public static String getCorrectPath(ContentDescription content) {
        return MethodLibraryPersister.getCorrectPath((DescribableElement)content.eContainer(), content);
    }

    private static String getCorrectPath(DescribableElement e, ContentDescription content) {
        if (e == null) {
            return null;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            return null;
        }
        Resource resource = plugin.eResource();
        URI uri = resource instanceof MultiFileXMIResourceImpl ? ((MultiFileXMIResourceImpl)resource).getFinalURI() : resource.getURI();
        File pluginDir = new File(uri.toFileString()).getParentFile();
        String folderPath = MethodLibraryPersister.staticGetFolderPath(e.eClass());
        String dir = pluginDir.getAbsolutePath() + File.separator + folderPath + File.separator;
        return MethodLibraryPersister.getNextAvailableFileName(dir, e, content);
    }

    static String getNextAvailableFileName(String dir, String requestedName, MultiResourceEObject e) {
        String path;
        File currentFile;
        File file;
        String currentFilename = null;
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eDirectResource();
        if (resource != null && !(file = new File(dir, currentFilename = (currentFile = new File(path = ((MultiFileXMIResourceImpl)e.eResource()).getFinalURI().toFileString())).getName())).exists()) {
            return file.getAbsolutePath();
        }
        path = dir + requestedName + ".xmi";
        if (currentFilename != null && currentFilename.equals(requestedName) || new File(path).exists()) {
            int i = 2;
            while (true) {
                if (!new File(path = dir + requestedName + ' ' + i + ".xmi").exists()) {
                    return path;
                }
                ++i;
            }
        }
        return path;
    }

    static String getNextAvailableFileName(String dir, ContentDescription content) {
        return MethodLibraryPersister.getNextAvailableFileName(dir, (DescribableElement)content.eContainer(), content);
    }

    private static String getNextAvailableFileName(String dir, DescribableElement e, ContentDescription content) {
        return MethodLibraryPersister.getNextAvailableFileName(dir, e.getName(), (MultiResourceEObject)content);
    }

    private static String staticGetFolderPath(EClass eClazz) {
        int size = folderInfos.size();
        FolderInfo info = null;
        int i = 0;
        while (i < size) {
            FolderInfo folderInfo = (FolderInfo)folderInfos.get(i);
            if (folderInfo.eClazz.isSuperTypeOf(eClazz)) {
                info = folderInfo;
            }
            ++i;
        }
        if (info != null) {
            if (info.eClazz == eClazz || info.shared) {
                return info.name;
            }
            return info.name + File.separatorChar + MethodLibraryPersister.lowerAndPluralize(eClazz.getName());
        }
        return MethodLibraryPersister.lowerAndPluralize(eClazz.getName());
    }

    public static String lowerAndPluralize(String name) {
        if ((name = name.toLowerCase()).endsWith("children")) {
            return name;
        }
        if (name.endsWith("child")) {
            return String.valueOf(name) + "ren";
        }
        if (name.endsWith("data")) {
            return name;
        }
        if (name.endsWith("datum")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "a";
        }
        if (name.endsWith("by")) {
            return String.valueOf(name) + "s";
        }
        if (name.endsWith("y")) {
            return String.valueOf(name.substring(0, name.length() - 1)) + "ies";
        }
        if (name.endsWith("ex")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "ices";
        }
        if (name.endsWith("x")) {
            return String.valueOf(name) + "es";
        }
        if (name.endsWith("us")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "i";
        }
        if (name.endsWith("ss")) {
            return String.valueOf(name) + "es";
        }
        if (name.endsWith("s")) {
            return name;
        }
        return String.valueOf(name) + "s";
    }

    public static String getResourcePath(MethodElement e) {
        String folderPath = MethodLibraryPersister.getElementPath(e);
        if (folderPath == null || folderPath.equals("")) {
            return RESOURCE_FOLDER;
        }
        if (folderPath.endsWith(File.separator)) {
            return folderPath + RESOURCE_FOLDER;
        }
        return folderPath + File.separator + RESOURCE_FOLDER;
    }

    public static String getElementPath(MethodElement e) {
        String relPluginPath;
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            if (!(e instanceof MethodConfiguration) && !(e instanceof MethodLibrary)) {
                System.out.println("error in MethodLibraryPersister.getElementPath(): plugin element without a valid plugin. This problem needs to be fixed.");
            }
            return "";
        }
        if (plugin.eContainer() == null) {
            System.out.println("error in MethodLibraryPersister.getElementPath(): plugin without library set. This problem needs to be fixed.");
            return "";
        }
        if (plugin.eResource() != null) {
            Resource libRes = UmaUtil.getMethodLibrary((EObject)plugin).eResource();
            if (libRes == plugin.eResource()) {
                relPluginPath = plugin.getName();
            } else {
                URI uri = MultiFileSaveUtil.getFinalURI(plugin.eResource());
                URI relUri = uri.deresolve(MultiFileSaveUtil.getFinalURI(libRes));
                relPluginPath = relUri.trimSegments(1).toFileString();
            }
        } else {
            relPluginPath = plugin.getName();
        }
        String folderPath = MethodLibraryPersister.staticGetFolderRelativePath(e);
        return folderPath.length() == 0 ? relPluginPath : relPluginPath + File.separatorChar + folderPath + File.separatorChar;
    }

    public static void main(String[] args) {
        EClass eCls = UmaPackage.eINSTANCE.getTemplate();
        System.out.println(eCls.getName());
    }

    public void adjustLocation(Resource resource) {
        HashSet modifiedResources = new HashSet();
        MultiFileSaveUtil.adjustLocation(resource, modifiedResources);
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        Iterator iter = modifiedResources.iterator();
        while (iter.hasNext()) {
            try {
                resourceSet.save((Resource)iter.next(), null);
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public void save(Resource resource) throws Exception {
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        resourceSet.save(resource, null);
    }

    protected void deleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
        if (new File(path).isDirectory() && !e.eIsProxy()) {
            Iterator iter = resourceSet.getResources().iterator();
            while (iter.hasNext()) {
                Resource res = (Resource)iter.next();
                MethodElement me = MultiFileSaveUtil.getMethodElement(res);
                if (me == null || !UmaUtil.isContainedBy((EObject)me, (Object)e)) continue;
                res.unload();
                iter.remove();
            }
        }
        try {
            FileManager.getInstance().deleteResource(path, null);
        }
        catch (CoreException ex) {
            CommonPlugin.INSTANCE.log((Object)ex);
            throw new WrappedException((Exception)((Object)ex));
        }
    }

    protected void delete(MethodElement e, Set modifiedResources) {
        String path;
        if (!UmaUtil.hasDirectResource((EObject)e)) {
            return;
        }
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eResource();
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof MethodElement) || element == e) continue;
            resourceSet.removeURIMappings((EObject)e, modifiedResources);
            resource.getContents().remove((Object)e);
            modifiedResources.add(resource);
            return;
        }
        if (MultiFileSaveUtil.hasOwnFolder(e)) {
            path = new File(resource.getFinalURI().toFileString()).getParent();
            ArrayList<Resource> unloadedResources = new ArrayList<Resource>();
            do {
                Resource res;
                unloadedResources.clear();
                Iterator iter2 = new ArrayList(resourceSet.getResources()).iterator();
                while (iter2.hasNext()) {
                    MethodElement me;
                    res = (Resource)iter2.next();
                    if (!res.isLoaded() || (me = MultiFileSaveUtil.getMethodElement(res)) == null || !UmaUtil.isContainedBy((EObject)me, (Object)e)) continue;
                    unloadedResources.add(res);
                }
                iter2 = unloadedResources.iterator();
                while (iter2.hasNext()) {
                    res = (Resource)iter2.next();
                    res.unload();
                }
                resourceSet.getResources().removeAll(unloadedResources);
            } while (!unloadedResources.isEmpty());
        } else {
            path = resource.getFinalURI().toFileString();
        }
        try {
            resourceSet.cleanUp((Resource)resource, modifiedResources);
        }
        catch (Exception e1) {
            CommonPlugin.INSTANCE.log((Object)e1);
        }
        this.deleteFiles(e, path, (ResourceSet)resourceSet);
    }

    private static void getObjectsWithDirectResources(EObject e, Collection objectsWithDirectResources) {
        if (UmaUtil.hasDirectResource((EObject)e)) {
            objectsWithDirectResources.add(e);
        } else {
            Iterator iter = e.eContents().iterator();
            while (iter.hasNext()) {
                MethodLibraryPersister.getObjectsWithDirectResources((EObject)iter.next(), objectsWithDirectResources);
            }
        }
    }

    public void delete(MethodElement e) {
        ArrayList elements = new ArrayList();
        MethodLibraryPersister.getObjectsWithDirectResources((EObject)e, elements);
        if (!elements.isEmpty()) {
            HashSet modifiedResources = new HashSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.delete((MethodElement)iter.next(), modifiedResources);
            }
            iter = modifiedResources.iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                try {
                    this.save(resource);
                }
                catch (Exception ex) {
                    throw new WrappedException(ex);
                }
            }
        }
    }

    private static String staticGetFolderRelativePath(MethodElement e) {
        if (e instanceof MethodPlugin) {
            return "";
        }
        if (e instanceof ContentElement) {
            return MethodLibraryPersister.staticGetFolderPath(e.eClass());
        }
        if (e instanceof MethodConfiguration) {
            return "configurations";
        }
        MethodUnit unit = UmaUtil.getMethodUnit((MethodElement)e);
        if (unit instanceof ProcessComponent) {
            Process proc = ((ProcessComponent)unit).getProcess();
            if (proc instanceof CapabilityPattern) {
                return "capabilitypatterns";
            }
            if (proc instanceof DeliveryProcess) {
                return "deliveryprocesses";
            }
            if (proc instanceof ProcessContribution) {
                return "processcontributions";
            }
        } else if (unit instanceof ContentDescription) {
            return MethodLibraryPersister.staticGetFolderRelativePath((MethodElement)unit.eContainer());
        }
        return "";
    }

    public String getFolderRelativePath(MethodElement e) {
        return MethodLibraryPersister.staticGetFolderRelativePath(e);
    }

    public List getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        return this.warnings;
    }

    FailSafePersister getFailSafePersister(Map options) {
        FailSafePersister persister = new FailSafePersister();
        persister.saveOptions.putAll(options);
        persister.saveOptions.put("TX_RECORD", persister.txRecord);
        return persister;
    }

    public boolean hasOwnFolder(Object e) {
        return MultiFileSaveUtil.hasOwnFolder(e);
    }

    public boolean hasOwnResource(Object e) {
        return MultiFileSaveUtil.hasOwnResource(e, MultiFileResourceSetImpl.DEFAULT_SAVE_SEPARATELY_CLASS_SET);
    }

    public IMethodLibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
        return new FailSafePersister();
    }

    public String getFileExtension(Object e) {
        return ".xmi";
    }

    private static class FolderInfo {
        EClass eClazz;
        boolean shared;
        private String name;

        public FolderInfo(EClass clazz, boolean shared) {
            this.eClazz = clazz;
            this.shared = shared;
            this.name = MethodLibraryPersister.lowerAndPluralize(clazz.getName());
        }
    }

    static class FailSafePersister
    extends MethodLibraryPersister
    implements IMethodLibraryPersister.FailSafeMethodLibraryPersister {
        private Map saveOptions;
        private TxRecord txRecord = new TxRecord(this){
            final /* synthetic */ FailSafePersister this$1;
            {
                this.this$1 = failSafePersister;
            }

            public void clear() {
                if (this.warnings != null && !this.warnings.isEmpty()) {
                    this.this$1.warnings = Collections.unmodifiableList(this.warnings);
                }
                super.clear();
            }
        };
        private Map elementToInfoMapToDeleteFiles;

        public FailSafePersister() {
            this.saveOptions = new HashMap(MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS);
            this.txRecord = new TxRecord();
            this.saveOptions.put("TX_RECORD", this.txRecord);
            this.elementToInfoMapToDeleteFiles = new HashMap();
        }

        public List getWarnings() {
            if (this.txRecord.getTxID() == null) {
                return super.getWarnings();
            }
            return this.txRecord.getWarnings();
        }

        Map getSaveOptions() {
            return this.saveOptions;
        }

        void checkMove(Resource resource) {
            MultiFileXMIResourceImpl mfResource = (MultiFileXMIResourceImpl)resource;
            if (mfResource.txStarted()) {
                throw new MultiFileIOException(PersistenceResources.formatString("Persistence.moveResourceError.msg", resource));
            }
        }

        public void save(Resource resource) throws Exception {
            if (MultiFileXMISaveImpl.checkModifyRequired(this.saveOptions)) {
                MultiFileSaveUtil.checkModify(resource);
            }
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
            resourceSet.save(resource, this.saveOptions);
        }

        public void adjustLocation(Resource resource) {
            this.checkMove(resource);
            HashSet modifiedResources = new HashSet();
            if (MultiFileSaveUtil.prepareAdjustLocation((MultiFileXMIResourceImpl)resource, modifiedResources)) {
                this.txRecord.getResourcesToCommit().add(resource);
                if (!modifiedResources.isEmpty()) {
                    MultiFileSaveUtil.checkModify(modifiedResources);
                    MultiFileSaveUtil.checkOutOfSynch(modifiedResources);
                    Iterator iter = modifiedResources.iterator();
                    while (iter.hasNext()) {
                        try {
                            this.save((Resource)iter.next());
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                            throw new MultiFileIOException(e.toString());
                        }
                    }
                }
            }
            this.commit();
        }

        public void adjustLocation(Collection resources) {
            if (resources == null || resources.isEmpty()) {
                return;
            }
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                this.checkMove((Resource)iter.next());
            }
            HashSet modifiedResources = new HashSet();
            Iterator iter2 = resources.iterator();
            while (iter2.hasNext()) {
                MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)((Object)iter2.next());
                if (!MultiFileSaveUtil.prepareAdjustLocation(resource, modifiedResources)) continue;
                this.txRecord.getResourcesToCommit().add(resource);
            }
            if (!modifiedResources.isEmpty()) {
                MultiFileSaveUtil.checkModify(modifiedResources);
                MultiFileSaveUtil.checkOutOfSynch(modifiedResources);
                iter2 = modifiedResources.iterator();
                while (iter2.hasNext()) {
                    try {
                        this.save((Resource)iter2.next());
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                        throw new MultiFileIOException(e.toString());
                    }
                }
            }
            this.commit();
        }

        protected void deleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
            this.elementToInfoMapToDeleteFiles.put(e, new Object[]{path, resourceSet});
        }

        private void superDeleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
            super.deleteFiles(e, path, resourceSet);
        }

        public void commit() {
            int size = this.txRecord.getResourcesToCommit().size();
            int i = 0;
            while (i < size) {
                ((MultiFileXMIResourceImpl)((Object)this.txRecord.getResourcesToCommit().get(i))).commit();
                ++i;
            }
            i = 0;
            while (i < size) {
                ((MultiFileXMIResourceImpl)((Object)this.txRecord.getResourcesToCommit().get(i))).txFinished(true);
                ++i;
            }
            i = 0;
            while (i < size) {
                ((MultiFileXMIResourceImpl)((Object)this.txRecord.getResourcesToCommit().get(i))).deleteBackup();
                ++i;
            }
            this.txRecord.clear();
            Iterator iter = this.elementToInfoMapToDeleteFiles.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object[] info = (Object[])entry.getValue();
                String path = (String)info[0];
                try {
                    this.superDeleteFiles((MethodElement)entry.getKey(), path, (ResourceSet)info[1]);
                }
                catch (Exception e) {
                    IStatus status;
                    if (e instanceof WrappedException) {
                        e = ((WrappedException)e).exception();
                    }
                    String msg = PersistenceResources.getString("Persistence.ErrMsg.CouldNotDelete");
                    String otherMsg = null;
                    if (e instanceof CoreException && (status = ((CoreException)((Object)e)).getStatus()) != null) {
                        otherMsg = UmaUtil.getMessage((IStatus)status);
                    }
                    if (otherMsg == null) {
                        otherMsg = "";
                    }
                    msg = MessageFormat.format(msg, path, otherMsg);
                    e = new Exception(msg, e);
                    this.getWarnings().add(e);
                    CommonPlugin.INSTANCE.log((Object)e);
                }
            }
            this.elementToInfoMapToDeleteFiles.clear();
        }

        public void rollback() {
            if (!this.txRecord.getResourcesToCommit().isEmpty()) {
                try {
                    MultiFileXMIResourceImpl resource;
                    int max = this.txRecord.getResourcesToCommit().size() - 1;
                    ArrayList<MultiFileXMIResourceImpl> restoredResources = new ArrayList<MultiFileXMIResourceImpl>();
                    int i = max;
                    while (i > -1) {
                        resource = (MultiFileXMIResourceImpl)((Object)this.txRecord.getResourcesToCommit().get(i));
                        if (resource.restore()) {
                            restoredResources.add(resource);
                        }
                        --i;
                    }
                    Iterator iter = restoredResources.iterator();
                    while (iter.hasNext()) {
                        resource = (MultiFileXMIResourceImpl)((Object)iter.next());
                        resource.setModified(true);
                    }
                    i = max;
                    while (i > -1) {
                        resource = (MultiFileXMIResourceImpl)((Object)this.txRecord.getResourcesToCommit().get(i));
                        if (resource.hasTempURI()) {
                            try {
                                new File(resource.getURI().toFileString()).delete();
                            }
                            catch (Exception e) {
                                CommonPlugin.INSTANCE.log((Object)e);
                            }
                        }
                        --i;
                    }
                    i = max;
                    while (i > -1) {
                        ((MultiFileXMIResourceImpl)((Object)this.txRecord.getResourcesToCommit().get(i))).txFinished(false);
                        --i;
                    }
                }
                catch (RuntimeException e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    throw e;
                }
            }
            this.txRecord.clear();
        }

        public IMethodLibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
            return this;
        }

        public String getCurrentTxID() {
            return this.txRecord.getTxID();
        }
    }

    public static class NonFailSafePersister
    extends MethodLibraryPersister
    implements IMethodLibraryPersister.FailSafeMethodLibraryPersister {
        public void commit() {
        }

        public void rollback() {
        }

        public String getCurrentTxID() {
            return null;
        }

        public void adjustLocation(Collection resources) {
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                this.adjustLocation((Resource)iter.next());
            }
        }
    }
}

