/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.BreakdownElementDescription;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.MethodUnit;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerFactory;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;

public final class MultiFileSaveUtil {
    public static final String DEFAULT_MODEL_FILENAME = "model.xmi";
    public static final String DEFAULT_CONTENT_FILENAME = "content.xmi";
    public static final String DEFAULT_LIBRARY_MODEL_FILENAME = "library.xmi";
    public static final String DEFAULT_PLUGIN_MODEL_FILENAME = "plugin.xmi";
    public static final String DEFAULT_FILE_EXTENSION = ".xmi";
    public static final String LIBRARY_FILE_EXTENSION = "uma";
    public static final String CAPABILITY_PATTERN_PATH = "capabilitypatterns";
    public static final String DELIVERY_PROCESS_PATH = "deliveryprocesses";
    public static final String PROCESS_CONTRIBUTION_PATH = "processcontributions";
    public static final String METHOD_CONFIGURATION_FOLDER_NAME = "configurations";
    public static final boolean DEBUG = false;
    static final boolean PROFILE = false;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMddHHmmss.S");

    public static boolean isValidFileName(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.indexOf(58) == -1 && name.indexOf(42) == -1 && name.indexOf(63) == -1 && name.indexOf(34) == -1 && name.indexOf(60) == -1 && name.indexOf(62) == -1 && name.indexOf(124) == -1;
    }

    public static String getPath(MethodElement e) {
        StringBuffer strBuff = new StringBuffer(String.valueOf(e.getName()));
        e = (MethodElement)e.eContainer();
        while (e != null) {
            strBuff.insert(0, String.valueOf(String.valueOf(e.getName())) + " > ");
            e = (MethodElement)e.eContainer();
        }
        return strBuff.toString();
    }

    public static String createDirName(MethodElement obj) {
        String name = obj.getName();
        if (MultiFileSaveUtil.isValidFileName(name)) {
            return name;
        }
        throw new MultiFileIOException(PersistenceResources.formatString("Persistence.invalidNameError.msg", name), obj);
    }

    public static EObject resolve(EObject proxy) {
        if (!(proxy instanceof InternalEObject)) {
            return proxy;
        }
        InternalEObject obj = (InternalEObject)proxy;
        if (obj.eProxyURI() == null) {
            return proxy;
        }
        XMIResourceImpl res = new XMIResourceImpl(obj.eProxyURI());
        try {
            res.load(null);
            return MultiFileSaveUtil.getMethodElement((Resource)res);
        }
        catch (IOException e) {
            e.printStackTrace();
            return proxy;
        }
    }

    static Resource save(EObject o, URI uri, Map options) {
        String str;
        ResourceSet resourceSet = o.eResource().getResourceSet();
        Resource resource = MultiFileSaveUtil.save(resourceSet, o, uri, options);
        if (options == null) {
            options = ((MultiFileResourceSetImpl)resourceSet).getDefaultSaveOptions();
        }
        if ((str = (String)options.get("REFRESH_NEW_RESOURCE")) != null && Boolean.valueOf(str).booleanValue()) {
            FileManager.getInstance().refresh(resource);
        }
        return resource;
    }

    public static boolean canSaveTogether(Map options, Object obj) {
        Set saveTogetherClasses = (Set)options.get("SAVE_TOGETHER_CLASS_SET");
        if (saveTogetherClasses == null) {
            return false;
        }
        Iterator iter = saveTogetherClasses.iterator();
        while (iter.hasNext()) {
            EClass eCls = (EClass)iter.next();
            if (!eCls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private static void addTo(Resource resource, MultiResourceEObject o) {
        BasicEList contents = (BasicEList)resource.getContents();
        if (contents.isEmpty()) {
            contents.clear();
            contents.setData(1, new Object[]{o});
        } else {
            Object[] data = contents.toArray();
            Object[] newData = new Object[data.length + 1];
            System.arraycopy(data, 0, newData, 0, data.length);
            newData[data.length] = o;
            contents.setData(newData.length, newData);
        }
        o.eSetResource((Resource.Internal)resource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Resource save(ResourceSet resourceSet, EObject o, URI uri, Map options) {
        mrEObj = (MultiResourceEObject)o;
        currentResource = (MultiFileXMIResourceImpl)o.eResource();
        if (currentResource != null) {
            currentResource.detached(o);
        }
        newResourceDescriptors = null;
        modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        res = null;
        if (MultiFileSaveUtil.canSaveTogether(options, o)) {
            mfResourceSet = (MultiFileResourceSetImpl)resourceSet;
            tempURI = (URI)mfResourceSet.getURIToTempURIMap().get(uri);
            if (tempURI != null) {
                uri = tempURI;
            }
            if ((res = (MultiFileXMIResourceImpl)mfResourceSet.getResource(uri)) != null) {
                if (res.getContents().contains((Object)o) != false) return res;
                if (res.getFinalURI() == res.getURI() && MultiFileXMISaveImpl.checkModifyRequired(options)) {
                    MultiFileSaveUtil.checkModify((Resource)res);
                }
                MultiFileSaveUtil.addTo((Resource)res, mrEObj);
                desc = null;
                try {
                    resMgr = MultiFileSaveUtil.getResourceManagerFor(o, modifiedResources);
                    desc = MultiFileSaveUtil.registerWithResourceManager(resMgr, o, res.getFinalURI());
                    if (desc != null && modifiedResources != null) {
                        modifiedResources.add(resMgr.eResource());
                    }
                    res.setModified(true);
                    mfResourceSet.save((Resource)res, options, false);
                    res.attachedAll(o);
                    return res;
                }
                catch (Exception e) {
                    res.getContents().remove((Object)mrEObj);
                    mrEObj.eSetResource(null);
                    if (desc != null) {
                        EcoreUtil.remove((EObject)desc);
                    }
                    if (currentResource == null) throw new MultiFileIOException(e.getMessage());
                    currentResource.attached(o);
                    throw new MultiFileIOException(e.getMessage());
                }
            }
        }
        res = (MultiFileXMIResourceImpl)resourceSet.createResource(uri);
        MultiFileSaveUtil.addTo((Resource)res, mrEObj);
        objToContainerMap = null;
        try {
            try {
                newResourceDescriptors = MultiFileSaveUtil.registerWithResourceManager(res, modifiedResources);
                objToContainerMap = MultiFileSaveUtil.removeContainers((Resource)res);
                res.save(options);
                res.attachedAll(o);
                ** GOTO lbl-1000
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
                resourceSet.getResources().remove((Object)res);
                mrEObj.eSetResource(null);
                iter = newResourceDescriptors.iterator();
            }
            while (true) {
                if (!iter.hasNext()) {
                    if (currentResource == null) throw new MultiFileIOException(e.getMessage());
                    currentResource.attached(o);
                    throw new MultiFileIOException(e.getMessage());
                }
                EcoreUtil.remove((EObject)((EObject)iter.next()));
            }
        }
        catch (Throwable var13_18) {
            var12_16 = null;
            MultiFileSaveUtil.restoreContainers((Resource)res, objToContainerMap);
            throw var13_18;
        }
lbl-1000:
        // 1 sources

        {
            var12_17 = null;
        }
        MultiFileSaveUtil.restoreContainers((Resource)res, objToContainerMap);
        resMgr = MultiFileSaveUtil.addNewResourceManager((Resource)res);
        if (resMgr == null) {
            if (o instanceof MethodPlugin == false) return res;
            resMgr = MultiFileSaveUtil.getResourceManagerFor(o, modifiedResources);
            return res;
        }
        if (modifiedResources == null) return res;
        modifiedResources.add(resMgr.eContainer().eResource());
        return res;
    }

    private static Map removeContainers(Resource resource) {
        int size = resource.getContents().size();
        HashMap<MultiResourceEObject, InternalEObject> objToContainerMap = new HashMap<MultiResourceEObject, InternalEObject>();
        int i = 0;
        while (i < size) {
            MultiResourceEObject multiResEObj = (MultiResourceEObject)resource.getContents().get(i);
            InternalEObject container = (InternalEObject)multiResEObj.eContainer();
            if (container != null) {
                objToContainerMap.put(multiResEObj, container);
                multiResEObj.eBasicSetContainer(null, multiResEObj.eContainerFeatureID());
            }
            ++i;
        }
        return objToContainerMap;
    }

    static Map getContainers(Resource resource) {
        int size = resource.getContents().size();
        HashMap<MultiResourceEObject, InternalEObject> objToContainerMap = new HashMap<MultiResourceEObject, InternalEObject>();
        int i = 0;
        while (i < size) {
            MultiResourceEObject multiResEObj = (MultiResourceEObject)resource.getContents().get(i);
            InternalEObject container = (InternalEObject)multiResEObj.eContainer();
            if (container != null) {
                objToContainerMap.put(multiResEObj, container);
            }
            ++i;
        }
        return objToContainerMap;
    }

    private static void restoreContainers(Resource resource, Map objToContainerMap) {
        int size = resource.getContents().size();
        int i = 0;
        while (i < size) {
            MultiResourceEObject multiResEObj = (MultiResourceEObject)resource.getContents().get(i);
            InternalEObject container = (InternalEObject)objToContainerMap.get(multiResEObj);
            if (container != null) {
                multiResEObj.eBasicSetContainer(container, multiResEObj.eContainerFeatureID());
            }
            ++i;
        }
    }

    public static void checkModify(Resource resource) {
        if (resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)resource).hasTempURI()) {
            return;
        }
        String path = resource.getURI().toFileString();
        IStatus status = FileManager.getInstance().checkModify(path, (Object)MsgBox.getDefaultShell());
        if (!status.isOK()) {
            String msg = UmaUtil.getMessage((IStatus)status);
            if (msg == null) {
                msg = PersistenceResources.formatString("Persistence.modifyFileError.msg", path);
            }
            throw new MultiFileIOException(msg);
        }
    }

    public static void checkModify(Collection resources) {
        String[] paths = new String[resources.size()];
        int i = 0;
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            paths[i++] = resource.getURI().toFileString();
        }
        IStatus status = FileManager.getInstance().checkModify(paths, (Object)MsgBox.getDefaultShell());
        if (!status.isOK()) {
            String msg = UmaUtil.getMessage((IStatus)status);
            if (msg == null) {
                msg = PersistenceResources.formatString("Persistence.modifyFileError.msg", Arrays.asList(paths));
            }
            throw new MultiFileIOException(msg);
        }
    }

    public static void checkOutOfSynch(Collection resources) {
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            MultiFileXMIResourceImpl res = (MultiFileXMIResourceImpl)((Object)iter.next());
            long lastModified = new File(res.getURI().toFileString()).lastModified();
            if (res.getFileLastModified() == lastModified) continue;
            String msg = PersistenceResources.formatString("Persistence.resourceOutOfSynch.msg", res.getURI().toFileString());
            throw new MultiFileIOException(msg);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(Resource resource, Map options) {
        if (resource.getContents().isEmpty()) {
            return;
        }
        Set modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        Map objToContainerMap = MultiFileSaveUtil.removeContainers(resource);
        try {
            try {
                resource.save(options);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MultiFileIOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            MultiFileSaveUtil.restoreContainers(resource, objToContainerMap);
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        MultiFileSaveUtil.restoreContainers(resource, objToContainerMap);
        ResourceManager resMgr = MultiFileSaveUtil.addNewResourceManager(resource);
        if (resMgr != null && modifiedResources != null) {
            modifiedResources.add(resMgr.eContainer().eResource());
        }
    }

    private static ResourceManager addNewResourceManager(Resource resource) {
        ResourceManager parentResMgr;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(resource);
        MethodElement e = MultiFileSaveUtil.getMethodElement(resource);
        EObject container = e.eContainer();
        if (resMgr != null && container != null && resMgr.eContainer() == null && !(parentResMgr = MultiFileSaveUtil.getResourceManager(container.eResource())).getSubManagers().contains(resMgr)) {
            parentResMgr.getSubManagers().add(resMgr);
            return resMgr;
        }
        return null;
    }

    private static String toFileString(EObject eObj) {
        return eObj.eResource().getResourceSet().getURIConverter().normalize(eObj.eResource().getURI()).toFileString();
    }

    static boolean hasOwnFolder(Object e) {
        return e instanceof MethodPlugin || e instanceof ProcessComponent;
    }

    static boolean hasOwnResource(Object obj, Collection saveSeparatelyClassSet) {
        if (obj instanceof MethodUnit) {
            return true;
        }
        if (saveSeparatelyClassSet == null) {
            return false;
        }
        Iterator iter = saveSeparatelyClassSet.iterator();
        while (iter.hasNext()) {
            EClass eCls = (EClass)iter.next();
            if (!eCls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    static URI createFileURI(MethodElement e) {
        if (e.eContainer() == null) {
            return ((MultiFileXMIResourceImpl)e.eResource()).getFinalURI();
        }
        if (e instanceof ProcessComponent) {
            String pluginDir;
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            MethodLibrary lib = (MethodLibrary)plugin.eContainer();
            if (lib != null) {
                String libDir = new File(((MultiFileXMIResourceImpl)lib.eResource()).getFinalURI().toFileString()).getParent();
                pluginDir = String.valueOf(libDir) + File.separator + plugin.getName();
            } else {
                if (plugin.eResource() == null) {
                    return null;
                }
                pluginDir = new File(((MultiFileXMIResourceImpl)plugin.eResource()).getFinalURI().toFileString()).getParent();
            }
            Process proc = ((ProcessComponent)e).getProcess();
            String relativeDir = proc instanceof CapabilityPattern ? CAPABILITY_PATTERN_PATH : (proc instanceof DeliveryProcess ? DELIVERY_PROCESS_PATH : (proc instanceof ProcessContribution ? PROCESS_CONTRIBUTION_PATH : ""));
            String path = String.valueOf(pluginDir) + File.separator + relativeDir + File.separator + e.getName() + File.separator + DEFAULT_MODEL_FILENAME;
            return URI.createFileURI((String)path);
        }
        if (e instanceof BreakdownElementDescription) {
            String dir = null;
            dir = new File(((MultiFileXMIResourceImpl)UmaUtil.getProcessComponent((MethodElement)e).eResource()).getFinalURI().toFileString()).getParent();
            return URI.createFileURI((String)(String.valueOf(dir) + File.separator + DEFAULT_CONTENT_FILENAME));
        }
        if (e instanceof ContentDescription) {
            ContentDescription content = (ContentDescription)e;
            String path = MethodLibraryPersister.getCorrectPath(content);
            if (path == null) {
                String dir = String.valueOf(((MultiFileXMIResourceImpl)e.eResource()).getFinalURI().trimSegments(1).toFileString()) + File.separator;
                path = MethodLibraryPersister.getNextAvailableFileName(dir, content);
            }
            URI uri = URI.createFileURI((String)path);
            return uri;
        }
        if (e instanceof MethodConfiguration) {
            String dir = ((MultiFileXMIResourceImpl)e.eContainer().eResource()).getFinalURI().trimSegments(1).toFileString() + File.separator + METHOD_CONFIGURATION_FOLDER_NAME + File.separator;
            String path = MethodLibraryPersister.getNextAvailableFileName(dir, StrUtil.makeValidFileName((String)e.getName()), (MultiResourceEObject)e);
            return URI.createFileURI((String)path);
        }
        StringBuffer path = new StringBuffer();
        MethodElement lastContainer = null;
        MethodElement obj = (MethodElement)e.eContainer();
        while (obj != null) {
            lastContainer = obj;
            if (obj instanceof MethodLibrary) {
                path.insert(0, new File(((MultiFileXMIResourceImpl)obj.eResource()).getFinalURI().toFileString()).getParentFile().getAbsolutePath());
                break;
            }
            path.insert(0, obj.getName()).insert(0, File.separatorChar);
            obj = (MethodElement)obj.eContainer();
        }
        if (lastContainer == null) {
            return e.eResource() != null ? ((MultiFileXMIResourceImpl)e.eResource()).getFinalURI() : null;
        }
        if (!(lastContainer instanceof MethodLibrary)) {
            path.insert(0, new File(MultiFileSaveUtil.toFileString((EObject)lastContainer)).getParentFile().getParentFile().getAbsolutePath());
        }
        String modelFileName = e instanceof MethodPlugin ? DEFAULT_PLUGIN_MODEL_FILENAME : DEFAULT_MODEL_FILENAME;
        URI uri = URI.createFileURI((String)(String.valueOf(path.toString()) + File.separator + MultiFileSaveUtil.createDirName(e) + File.separator + modelFileName));
        return uri;
    }

    public static void delete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                MultiFileSaveUtil.delete(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    static void setURIMapping(EObject e, URI uri, Set modifiedResources) {
        MultiFileURIConverter uriConverter = (MultiFileURIConverter)e.eResource().getResourceSet().getURIConverter();
        uriConverter.setURIMapping(e, uri, modifiedResources);
    }

    static void updateURIMappings(MultiFileXMIResourceImpl resource, Set modifiedResources) {
        MultiFileSaveUtil.updateURIMappings(resource, modifiedResources, true);
    }

    static boolean hasLoadedResource(ResourceSet resourceSet, URI uri) {
        Iterator iter = resourceSet.getResources().iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (!resource.isLoaded() || !resource.getURI().equals((Object)uri)) continue;
            return true;
        }
        return false;
    }

    static void updateURIMappings(MultiFileXMIResourceImpl resource, Set modifiedResources, boolean afterMove) {
        MultiFileSaveUtil.updateURIMappings(resource, resource.getFinalURI(), modifiedResources, afterMove);
    }

    static void updateURIMappings(MultiFileXMIResourceImpl resource, URI uri, Set modifiedResources, boolean afterMove) {
        ResourceDescriptor desc;
        Object iter;
        HashMap<URI, ResourceDescriptor> oldURIToResourceDescriptorMap = null;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)resource);
        if (resMgr != null) {
            oldURIToResourceDescriptorMap = new HashMap<URI, ResourceDescriptor>();
            iter = resMgr.eAllContents();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ResourceDescriptor)) continue;
                desc = (ResourceDescriptor)obj;
                oldURIToResourceDescriptorMap.put(desc.getResolvedURI(), desc);
                if (!afterMove) continue;
                desc.clearResolvedURI();
            }
        }
        if (!resource.getContents().isEmpty()) {
            MethodElement element = MultiFileSaveUtil.getMethodElement((Resource)resource);
            MultiFileURIConverter uriConverter = (MultiFileURIConverter)resource.getResourceSet().getURIConverter();
            uriConverter.setURIMapping((EObject)element, uri, modifiedResources, afterMove);
        }
        if (oldURIToResourceDescriptorMap != null) {
            iter = resource.getResourceSet().getResources().iterator();
            while (iter.hasNext()) {
                Resource res = (Resource)iter.next();
                desc = (ResourceDescriptor)oldURIToResourceDescriptorMap.get(res.getURI());
                if (desc == null) continue;
                if (afterMove) {
                    res.setURI(desc.getResolvedURI());
                    continue;
                }
                if (!res.isLoaded()) continue;
                desc.clearResolvedURI();
                res.setURI(desc.getResolvedURI());
            }
        }
    }

    static ResourceManager getResourceManagerFor(EObject eObj, Set modifiedResources) {
        Resource resource = eObj.eContainer() != null ? eObj.eContainer().eResource() : eObj.eResource();
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(resource);
        if (resMgr == null) {
            ResourceManager parentResMgr;
            InternalEObject container;
            resMgr = ResourcemanagerFactory.eINSTANCE.createResourceManager();
            resource.getContents().add(0, (Object)resMgr);
            if (modifiedResources != null) {
                modifiedResources.add(resource);
            }
            if ((container = MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)eObj)) != null && container.eResource() != resource && (parentResMgr = MultiFileSaveUtil.getResourceManagerFor((EObject)container, modifiedResources)) != null) {
                parentResMgr.getSubManagers().add(resMgr);
                if (modifiedResources != null) {
                    modifiedResources.add(parentResMgr.eResource());
                }
            }
        }
        return resMgr;
    }

    static List registerWithResourceManager(MultiFileXMIResourceImpl resource, Set modifiedResources) {
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManagerFor((EObject)MultiFileSaveUtil.getMethodElement((Resource)resource), modifiedResources);
        ArrayList<ResourceDescriptor> resourceDescriptors = new ArrayList<ResourceDescriptor>();
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            ResourceDescriptor resDesc = MultiFileSaveUtil.registerWithResourceManager(resMgr, element, resource.getFinalURI());
            if (resDesc == null) continue;
            resourceDescriptors.add(resDesc);
        }
        if (!resourceDescriptors.isEmpty() && modifiedResources != null) {
            modifiedResources.add(resMgr.eResource());
        }
        return resourceDescriptors;
    }

    static ResourceDescriptor registerWithResourceManager(ResourceManager resMgr, Object element, URI uri) {
        String guid = MultiFileSaveUtil.getGuid(element);
        if (resMgr.getResourceDescriptor(guid) == null) {
            return MultiFileSaveUtil.createResourceDescriptor(resMgr, guid, uri);
        }
        return null;
    }

    private static ResourceDescriptor createResourceDescriptor(ResourceManager resMgr, String id, URI resolvedURI) {
        ResourceDescriptor resDesc = ResourcemanagerFactory.eINSTANCE.createResourceDescriptor();
        resDesc.setId(id);
        resMgr.getResourceDescriptors().add(resDesc);
        resDesc.setResolvedURI(resolvedURI);
        return resDesc;
    }

    public static void setGuid(MethodElement e) {
        if (e.getGuid() == null || e.getGuid().trim().length() == 0) {
            e.setGuid(EcoreUtil.generateUUID());
        }
    }

    public static void save(MethodElement e, Map options) {
        boolean createResource;
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eResource();
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        if (options == null) {
            options = resourceSet.getDefaultSaveOptions();
        }
        EObject container = e.eContainer();
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        URI uri = MultiFileSaveUtil.createFileURI(e);
        boolean bl = createResource = resource == null || container != null && resource == container.eResource();
        if (createResource) {
            MultiFileSaveUtil.save((EObject)e, uri, options);
        } else {
            URI oldUri = resource.getURI();
            if (!oldUri.equals((Object)uri) && FileManager.getInstance().move(oldUri.toFileString(), uri.toFileString())) {
                resource.setURI(uri);
                MultiFileSaveUtil.updateURIMappings(resource, modifiedResources);
            }
            if (resource.isModified()) {
                MultiFileSaveUtil.save((Resource)resource, options);
            }
        }
        resourceSet.saveModifiedResources(options);
    }

    public static void save(ResourceSet resourceSet, MethodElement e, Map options) {
        URI uri = MultiFileSaveUtil.createFileURI(e);
        MultiFileSaveUtil.save(resourceSet, (EObject)e, uri, options);
    }

    static void adjustLocation(Resource resource, Set modifiedResources) {
        MethodElement e = MultiFileSaveUtil.getMethodElement(resource);
        if (e == null) {
            return;
        }
        URI newFile = MultiFileSaveUtil.createFileURI(e);
        if (newFile != null && MultiFileSaveUtil.adjustLocation(resource, newFile)) {
            resource.setURI(newFile);
            MultiFileSaveUtil.updateURIMappings((MultiFileXMIResourceImpl)resource, modifiedResources);
        }
    }

    static URI getNewURI(MultiFileXMIResourceImpl resource) {
        MethodElement e = MultiFileSaveUtil.getMethodElement((Resource)resource);
        if (e == null) {
            return null;
        }
        URI newFile = MultiFileSaveUtil.createFileURI(e);
        if (newFile != null && MultiFileSaveUtil.adjustLocationRequired(resource, newFile)) {
            return newFile;
        }
        return null;
    }

    static boolean prepareAdjustLocation(MultiFileXMIResourceImpl resource, Set modifiedResources) {
        URI newFile = MultiFileSaveUtil.getNewURI(resource);
        if (newFile != null) {
            resource.backUpURI();
            resource.setFinalURI(newFile);
            MultiFileSaveUtil.updateURIMappings(resource, modifiedResources, false);
            return true;
        }
        return false;
    }

    public static String getGuid(Object e) {
        if (e instanceof MethodElement) {
            return ((MethodElement)e).getGuid();
        }
        if (e instanceof ResourceManager) {
            return ((ResourceManager)e).getGuid();
        }
        return null;
    }

    static boolean adjustLocationRequired(MultiFileXMIResourceImpl resource, URI newURI) {
        File newFile;
        File oldFile = new File(resource.getFinalURI().toFileString());
        return !oldFile.equals(newFile = new File(newURI.toFileString()));
    }

    static boolean adjustLocation(Resource resource, URI newUri) {
        File newFile;
        File oldFile = new File(resource.getURI().toFileString());
        if (oldFile.equals(newFile = new File(newUri.toFileString()))) {
            return false;
        }
        return MultiFileSaveUtil.move(resource, oldFile, newFile);
    }

    static boolean move(Resource resource, File oldFile, File newFile) {
        boolean ret = true;
        if (oldFile.equals(newFile)) {
            return false;
        }
        MethodElement obj = MultiFileSaveUtil.getMethodElement(resource);
        if (MultiFileSaveUtil.hasOwnFolder(obj)) {
            oldFile.getParentFile().toString();
            if (!oldFile.getParentFile().equals(newFile.getParentFile()) && !FileManager.getInstance().rename(oldFile.getParentFile(), newFile.getParentFile())) {
                ret = false;
            }
            if (!oldFile.getName().equals(newFile.getName())) {
                oldFile = new File(newFile.getParentFile(), oldFile.getName());
                if (!FileManager.getInstance().rename(oldFile, newFile)) {
                    ret = false;
                }
            }
            return ret;
        }
        if (oldFile.exists()) {
            oldFile.toString();
            if (FileManager.getInstance().rename(oldFile, newFile)) {
                return true;
            }
        }
        return false;
    }

    public static ResourceDescriptor findResourceDescriptor(ResourceManager resMgr, String guid) {
        return MultiFileSaveUtil.findResourceDescriptor(resMgr, guid, null);
    }

    public static ResourceDescriptor findResourceDescriptor(ResourceManager resMgr, String guid, Collection excludedResManagers) {
        ResourceDescriptor desc = resMgr.getResourceDescriptor(guid);
        if (desc != null) {
            return desc;
        }
        Iterator iter = resMgr.getSubManagers().iterator();
        while (iter.hasNext()) {
            ResourceManager mgr = null;
            mgr = (ResourceManager)iter.next();
            if (excludedResManagers != null && excludedResManagers.contains(mgr) || (desc = MultiFileSaveUtil.findResourceDescriptor(mgr, guid, excludedResManagers)) == null) continue;
            return desc;
        }
        return null;
    }

    public static int getCountResourceDescriptors(ResourceManager resMgr) {
        int count = resMgr.getResourceDescriptors().size();
        Iterator iter = resMgr.getSubManagers().iterator();
        while (iter.hasNext()) {
            ResourceManager mgr = (ResourceManager)iter.next();
            count += MultiFileSaveUtil.getCountResourceDescriptors(mgr);
        }
        return count;
    }

    public static ResourceDescriptor getResourceDescriptor(Resource resource) {
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            ResourceManager resMgr;
            InternalEObject container;
            Object element = iter.next();
            if (element instanceof MethodLibrary) {
                ResourceManager resMgr2 = MultiFileSaveUtil.getResourceManager(resource);
                if (resMgr2 == null) continue;
                ResourceDescriptor desc = resMgr2.getResourceDescriptor(((MethodElement)element).getGuid());
                if (desc == null) {
                    desc = MultiFileSaveUtil.registerWithResourceManager(resMgr2, element, ((MultiFileXMIResourceImpl)resource).getFinalURI());
                }
                return desc;
            }
            if (!(element instanceof MethodElement) || (container = MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)element)) == null || (resMgr = MultiFileSaveUtil.getResourceManager(container.eResource())) == null) continue;
            return resMgr.getResourceDescriptor(((MethodElement)element).getGuid());
        }
        return null;
    }

    public static ResourceManager getResourceManager(Resource resource) {
        ResourceManager resMgr = null;
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ResourceManager)) continue;
            resMgr = (ResourceManager)element;
            break;
        }
        return resMgr;
    }

    static InternalEObject getContainerWithDirectResource(InternalEObject obj) {
        if (obj.eContainer() == null) {
            return null;
        }
        MultiResourceEObject container = (MultiResourceEObject)((InternalEObject)obj.eContainer());
        if (container.eDirectResource() != null) {
            return container;
        }
        return MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)container);
    }

    static String getHREF(Resource resource, Object obj) {
        MethodElement owner = MultiFileSaveUtil.getMethodElement(resource);
        return MultiFileURIConverter.createURI(owner.getGuid()).appendFragment(MultiFileSaveUtil.getGuid(obj)).toString();
    }

    public static MethodElement getMethodElement(Resource resource) {
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof MethodElement)) continue;
            return (MethodElement)element;
        }
        return null;
    }

    public static String getBackupFileSuffix() {
        return "_" + dateFormatter.format(Calendar.getInstance().getTime());
    }

    public static void resolveProxies(Collection GUIDs, EObject parent) {
        Iterator iterator = parent.eClass().getEAllContainments().iterator();
        while (!GUIDs.isEmpty() && iterator.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iterator.next();
            if (feature.isMany()) {
                InternalEList list = (InternalEList)parent.eGet(feature);
                int index = 0;
                Iterator iter1 = list.basicIterator();
                while (!GUIDs.isEmpty() && iter1.hasNext()) {
                    InternalEObject child = (InternalEObject)iter1.next();
                    if (child.eIsProxy()) {
                        String guid = child.eProxyURI().fragment();
                        if (GUIDs.contains(guid)) {
                            list.get(index);
                            GUIDs.remove(guid);
                        }
                    } else {
                        MultiFileSaveUtil.resolveProxies(GUIDs, (EObject)child);
                    }
                    ++index;
                }
                continue;
            }
            InternalEObject child = (InternalEObject)parent.eGet(feature, false);
            if (child == null) continue;
            if (child.eIsProxy()) {
                String guid = child.eProxyURI().fragment();
                if (!GUIDs.contains(guid)) continue;
                parent.eGet(feature);
                GUIDs.remove(guid);
                continue;
            }
            MultiFileSaveUtil.resolveProxies(GUIDs, (EObject)child);
        }
    }

    public static URI getFinalURI(Resource resource) {
        return resource instanceof MultiFileXMIResourceImpl ? ((MultiFileXMIResourceImpl)resource).getFinalURI() : resource.getURI();
    }
}

