/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.refresh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.resources.refresh.RefreshProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class RefreshManager
implements IRefreshResult {
    private RefreshProvider[] providers;
    protected final Map registeredMonitors = Collections.synchronizedMap(new HashMap(10));
    private static final RefreshManager instance = new RefreshManager();

    private RefreshManager() {
    }

    private RefreshProvider[] getRefreshProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "refreshProviders");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        ArrayList<RefreshProvider> providerList = new ArrayList<RefreshProvider>(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            RefreshProvider provider = null;
            try {
                provider = (RefreshProvider)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Status status = new Status(2, "org.eclipse.core.resources", 1, Messages.refresh_installError, (Throwable)e);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            }
            if (provider != null) {
                providerList.add(provider);
            }
            ++i;
        }
        this.providers = providerList.toArray(new RefreshProvider[providerList.size()]);
        return this.providers;
    }

    private IRefreshMonitor safeInstallMonitor(RefreshProvider provider, IResource resource) {
        Throwable t = null;
        try {
            return provider.installMonitor(resource, (IRefreshResult)this);
        }
        catch (Exception e) {
            t = e;
        }
        catch (LinkageError e) {
            t = e;
        }
        if (t != null) {
            Status error = new Status(4, "org.eclipse.core.resources", 1, Messages.refresh_installError, t);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)error);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMonitor(IRefreshMonitor monitor, IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            ArrayList<IResource> resources = (ArrayList<IResource>)this.registeredMonitors.get(monitor);
            if (resources == null) {
                resources = new ArrayList<IResource>(1);
                this.registeredMonitors.put(monitor, resources);
            }
            if (!resources.contains(resource)) {
                resources.add(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMonitoring(IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List resources;
            Iterator i = this.registeredMonitors.keySet().iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while ((resources = (List)this.registeredMonitors.get(i.next())) == null || !resources.contains(resource));
            return true;
        }
    }

    public void monitor(IResource resource) {
        if (this.isMonitoring(resource)) {
            return;
        }
        RefreshProvider[] refreshProviders = this.getRefreshProviders();
        int i = 0;
        while (i < refreshProviders.length) {
            IRefreshMonitor monitor = this.safeInstallMonitor(refreshProviders[i], resource);
            if (monitor != null) {
                this.registerMonitor(monitor, resource);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmonitor(IResource resource) {
        if (resource == null || !this.isMonitoring(resource)) {
            return;
        }
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator i = this.registeredMonitors.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry current = i.next();
                List resources = (List)current.getValue();
                if (resources == null || resources.isEmpty() || !resources.contains(resource)) continue;
                ((IRefreshMonitor)current.getKey()).unmonitor(resource);
                resources.remove(resource);
            }
        }
        if (resource.getType() == 4) {
            this.unmonitorLinkedContents((IProject)resource);
        }
    }

    private void unmonitorLinkedContents(IProject project) {
        if (!project.isAccessible()) {
            return;
        }
        IResource[] children = null;
        try {
            children = project.members();
        }
        catch (CoreException e) {
            Status status = new Status(2, "org.eclipse.core.resources", 1, Messages.refresh_refreshErr, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        if (children != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isLinked()) {
                    this.unmonitor(children[i]);
                }
                ++i;
            }
        }
    }

    public void monitorFailed(IRefreshMonitor monitor, IResource resource) {
    }

    public void refresh(IResource resource) {
        System.out.println("RefreshManager.refresh(): " + resource);
        try {
            resource.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static final RefreshManager getInstance() {
        return instance;
    }
}

