/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import com.ibm.uma.MethodConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.wizards.ExportConfigDestinationPage;
import org.eclipse.epf.export.wizards.ExportConfigurationWizard;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportConfigSelectSpecsPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME;
    private Table table;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_briefDesc;
    private int checkedCount = 0;
    private List checkedConfigList = new ArrayList();
    private ConfigurationExportData data;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.export.wizards.ExportConfigSelectSpecsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public ExportConfigSelectSpecsPage(ConfigurationExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.getString("Export.selectConfigSpecsPage.title"));
        this.setDescription(ExportResources.getString("Export.selectConfigSpecsPage.desc"));
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/ExportLibraryConfiguration.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createLabel(container, ExportResources.getString("Export.selectConfigSpecsPage.configsLabel.text"));
        this.ctrl_chkboxTableViewer = this.createCheckboxTableViewer(container, 1);
        this.table = this.ctrl_chkboxTableViewer.getTable();
        MethodConfiguration[] configs = LibraryProcessor.getInstance().getConfigurations();
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodConfiguration) {
                    return ((MethodConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (configs != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)configs);
        }
        this.createLabel(container, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = this.createTextMulti(container, "", 360, 80, 3);
        if (configs != null && configs.length > 0) {
            this.table.select(0);
            this.setDisplayAttributes(configs[0]);
        }
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object obj = event.getElement();
        if (event.getChecked()) {
            ++this.checkedCount;
            this.checkedConfigList.add(obj);
        } else {
            --this.checkedCount;
            this.checkedConfigList.remove(obj);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] configs = selection.toArray();
            this.setDisplayAttributes((MethodConfiguration)configs[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodConfiguration config) {
        this.ctrl_briefDesc.setText(config.getBriefDescription());
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    private void saveDataToModel() {
        this.data.selectedConfigs = this.checkedConfigList;
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        ExportConfigDestinationPage page = ((ExportConfigurationWizard)this.getWizard()).destinationPage;
        return page;
    }
}

