/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

class StyledTextDragAndDropEffect
extends DragAndDropEffect {
    StyledText text;
    Rectangle caretBounds;

    StyledTextDragAndDropEffect(StyledText control) {
        this.text = control;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        int offset = -1;
        if ((effect & 1) != 0) {
            Point pt = this.text.getDisplay().map(null, this.text, x, y);
            try {
                offset = this.text.getOffsetAtLocation(pt);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int maxOffset = this.text.getCharCount();
                Point maxLocation = this.text.getLocationAtOffset(maxOffset);
                if (pt.y >= maxLocation.y) {
                    offset = pt.x >= maxLocation.x ? maxOffset : this.text.getOffsetAtLocation(new Point(pt.x, maxLocation.y));
                }
                offset = maxOffset;
            }
        }
        if (this.caretBounds != null) {
            this.drawCaret();
            this.caretBounds = null;
        }
        if (offset != -1) {
            this.text.setCaretOffset(offset);
            this.caretBounds = this.text.getCaret().getBounds();
            this.drawCaret();
        }
    }

    void drawCaret() {
        int window = OS.GTK_WIDGET_WINDOW(this.text.handle);
        int gc = OS.gdk_gc_new(window);
        GdkColor color = new GdkColor();
        color.red = (short)-1;
        color.green = (short)-1;
        color.blue = (short)-1;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(colormap, color, true, true);
        OS.gdk_gc_set_foreground(gc, color);
        OS.gdk_gc_set_function(gc, 2);
        int nWidth = this.caretBounds.width;
        int nHeight = this.caretBounds.height;
        if (nWidth <= 0) {
            nWidth = 1;
        }
        OS.gdk_draw_rectangle(window, gc, 1, this.caretBounds.x, this.caretBounds.y, nWidth, nHeight);
        OS.g_object_unref(gc);
        OS.gdk_colormap_free_colors(colormap, color, 1);
    }
}

