/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;

public final class ExternalActionManager {
    private static ExternalActionManager instance;
    private ICallback callback;

    public static ExternalActionManager getInstance() {
        if (instance == null) {
            instance = new ExternalActionManager();
        }
        return instance;
    }

    private ExternalActionManager() {
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void setCallback(ICallback callbackToUse) {
        this.callback = callbackToUse;
    }

    public static final class CommandCallback
    implements IBindingManagerListener,
    IBindingManagerCallback {
        private static final ResourceBundle RESOURCE_BUNDLE;
        private final IActiveChecker activeChecker;
        private final BindingManager bindingManager;
        private boolean bindingManagerListenerAttached = false;
        private final CommandManager commandManager;
        private final Set loggedCommandIds = new HashSet();
        private final Map registeredListeners = new HashMap();
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.action.ExternalActionManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager) {
            this(bindingManager, commandManager, new IActiveChecker(){

                public boolean isActive(String commandId) {
                    return true;
                }
            });
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager, IActiveChecker activeChecker) {
            if (bindingManager == null) {
                throw new NullPointerException("The callback needs a binding manager");
            }
            if (commandManager == null) {
                throw new NullPointerException("The callback needs a command manager");
            }
            if (activeChecker == null) {
                throw new NullPointerException("The callback needs an active callback");
            }
            this.activeChecker = activeChecker;
            this.bindingManager = bindingManager;
            this.commandManager = commandManager;
        }

        public final void addPropertyChangeListener(String commandId, IPropertyChangeListener listener) {
            this.registeredListeners.put(commandId, listener);
            if (!this.bindingManagerListenerAttached) {
                this.bindingManager.addBindingManagerListener(this);
                this.bindingManagerListenerAttached = true;
            }
        }

        public final void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveBindingsChanged()) {
                Iterator listenerItr = this.registeredListeners.entrySet().iterator();
                while (listenerItr.hasNext()) {
                    Map.Entry entry = listenerItr.next();
                    String commandId = (String)entry.getKey();
                    Command command = this.commandManager.getCommand(commandId);
                    ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
                    if (!event.isActiveBindingsChangedFor(parameterizedCommand)) continue;
                    IPropertyChangeListener listener = (IPropertyChangeListener)entry.getValue();
                    listener.propertyChange(new PropertyChangeEvent(event.getManager(), "text", null, null));
                }
            }
        }

        public final Integer getAccelerator(String commandId) {
            Trigger trigger;
            Trigger[] triggers;
            TriggerSequence triggerSequence = this.bindingManager.getBestActiveBindingFor(commandId);
            if (triggerSequence != null && (triggers = triggerSequence.getTriggers()).length == 1 && (trigger = triggers[0]) instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)trigger;
                int accelerator = SWTKeySupport.convertKeyStrokeToAccelerator(keyStroke);
                return new Integer(accelerator);
            }
            return null;
        }

        public final String getAcceleratorText(String commandId) {
            TriggerSequence triggerSequence = this.bindingManager.getBestActiveBindingFor(commandId);
            if (triggerSequence == null) {
                return null;
            }
            return triggerSequence.format();
        }

        public final TriggerSequence[] getActiveBindingsFor(String commandId) {
            return this.bindingManager.getActiveBindingsFor(commandId);
        }

        public final boolean isAcceleratorInUse(int accelerator) {
            KeySequence keySequence = KeySequence.getInstance(SWTKeySupport.convertAcceleratorToKeyStroke(accelerator));
            return this.bindingManager.isPerfectMatch(keySequence) || this.bindingManager.isPartialMatch(keySequence);
        }

        public final boolean isActive(String commandId) {
            if (commandId != null) {
                Command command = this.commandManager.getCommand(commandId);
                if (!command.isDefined() && !this.loggedCommandIds.contains(commandId)) {
                    String message = MessageFormat.format((String)Util.translateString(RESOURCE_BUNDLE, "undefinedCommand.WarningMessage", null), (Object[])new String[]{command.getId()});
                    Status status = new Status(4, "org.eclipse.jface", 0, message, (Throwable)new Exception());
                    Policy.getLog().log((IStatus)status);
                    this.loggedCommandIds.add(commandId);
                    command.addCommandListener(new ICommandListener(this, command, commandId){
                        final /* synthetic */ CommandCallback this$1;
                        private final /* synthetic */ Command val$command;
                        private final /* synthetic */ String val$commandId;
                        {
                            this.this$1 = commandCallback;
                            this.val$command = command;
                            this.val$commandId = string;
                        }

                        public final void commandChanged(CommandEvent commandEvent) {
                            if (this.val$command.isDefined()) {
                                this.val$command.removeCommandListener((ICommandListener)this);
                                CommandCallback.access$0(this.this$1).remove(this.val$commandId);
                            }
                        }
                    });
                    return true;
                }
                return this.activeChecker.isActive(commandId);
            }
            return true;
        }

        public final void removePropertyChangeListener(String commandId, IPropertyChangeListener listener) {
            IPropertyChangeListener existingListener = (IPropertyChangeListener)this.registeredListeners.get(commandId);
            if (existingListener == listener) {
                this.registeredListeners.remove(commandId);
                if (this.registeredListeners.isEmpty()) {
                    this.bindingManager.removeBindingManagerListener(this);
                    this.bindingManagerListenerAttached = false;
                }
            }
        }

        static /* synthetic */ Set access$0(CommandCallback commandCallback) {
            return commandCallback.loggedCommandIds;
        }
    }

    public static interface IActiveChecker {
        public boolean isActive(String var1);
    }

    public static interface IBindingManagerCallback
    extends ICallback {
        public TriggerSequence[] getActiveBindingsFor(String var1);
    }

    public static interface ICallback {
        public void addPropertyChangeListener(String var1, IPropertyChangeListener var2);

        public Integer getAccelerator(String var1);

        public String getAcceleratorText(String var1);

        public boolean isAcceleratorInUse(int var1);

        public boolean isActive(String var1);

        public void removePropertyChangeListener(String var1, IPropertyChangeListener var2);
    }
}

