/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ConfigurationContentProvider
implements ITreeContentProvider {
    private MethodConfiguration config = null;

    public Object[] getChildren(Object parentElement) {
        EList children;
        if (parentElement instanceof MethodConfiguration) {
            List sels = ((MethodConfiguration)parentElement).getMethodPluginSelection();
            if (sels != null) {
                return sels.toArray();
            }
            return null;
        }
        if (parentElement instanceof MethodPlugin) {
            List sels = ((MethodPlugin)parentElement).getMethodPackages();
            if (sels != null) {
                ArrayList<MethodPackage> items = new ArrayList<MethodPackage>();
                List selectedPackages = this.config.getMethodPackageSelection();
                Iterator it = sels.iterator();
                while (it.hasNext()) {
                    MethodPackage pkg = (MethodPackage)it.next();
                    if (selectedPackages == null || !selectedPackages.contains(pkg)) continue;
                    items.add(pkg);
                }
                return items.toArray();
            }
        } else if (parentElement instanceof EObject && (children = ((EObject)parentElement).eContents()) != null) {
            ArrayList showItems = new ArrayList();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (child instanceof MethodElement && !ConfigurationHelper.canShow((MethodElement)child, this.config)) continue;
                showItems.add(child);
            }
            return showItems.toArray();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof MethodConfiguration) {
            return null;
        }
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MethodConfiguration || element instanceof MethodPlugin) {
            return true;
        }
        if (element instanceof EObject) {
            EList children = ((EObject)element).eContents();
            return children != null && children.size() > 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof MethodConfiguration) {
            this.config = (MethodConfiguration)newInput;
        }
    }

    public void dispose() {
    }
}

