/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Milestone;
import com.ibm.uma.TeamProfile;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.viewers.Viewer;

public class ProcessConfigurator
extends ConfigurationFilter {
    public ProcessConfigurator(MethodConfiguration methodConfig, Viewer viewer) {
        super(methodConfig, viewer);
    }

    public void setMethodConfiguration(MethodConfiguration newConfig) {
        this.methodConfig = newConfig;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            return true;
        }
        if (obj instanceof BreakdownElement) {
            return this.accept((BreakdownElement)obj);
        }
        return super.accept(obj);
    }

    protected boolean accept(BreakdownElement e) {
        if (e instanceof Milestone || e instanceof TeamProfile) {
            return true;
        }
        if (e instanceof Activity) {
            Activity base = (Activity)((Activity)e).getVariabilityBasedOnElement();
            if (base == null) {
                return true;
            }
            return ConfigurationHelper.inConfig((MethodElement)TngUtil.getOwningProcess((BreakdownElement)base), this.methodConfig);
        }
        if (e instanceof Descriptor) {
            MethodElement linked_obj = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)e));
            if (linked_obj == null) {
                return true;
            }
            linked_obj = ConfigurationHelper.getCalculatedElement(linked_obj, this.methodConfig);
            return ConfigurationHelper.inConfig(linked_obj, this.methodConfig);
        }
        return super.accept(e);
    }
}

