/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.ProcessFamily;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IFileManager;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.configuration.ConfigurationFactory;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.ILibraryResourceManager;
import org.eclipse.epf.library.services.LibraryModificationHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.services.VersionManager;
import org.eclipse.epf.library.services.internal.LibraryResourceManager;
import org.eclipse.epf.library.util.CopyAttachmentsToNewLocation;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.Log;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.library.util.ResourceErrorDialogHelper;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LibraryProcessor {
    private static final String EMPTY_METHOD_LIBRARY_PATH_MSG = LibraryResources.getString("Library.emptyLibraryPathError.reason");
    private static final String MISSING_LIBRARY_FILE_MSG = LibraryResources.getString("Library.missingLibraryFileError.reason");
    private static final String COULD_NOT_LOCK_LIBRARY_MSG = LibraryResources.getString("Library.couldNotLockLibrary.reason");
    public static final IStatus EMPTY_METHOD_LIBRARY_PATH_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, EMPTY_METHOD_LIBRARY_PATH_MSG, null);
    public static final IStatus MISSING_LIBRARY_FILE_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, MISSING_LIBRARY_FILE_MSG, null);
    public static final IStatus COULD_NOT_LOCK_LIBRARY_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, COULD_NOT_LOCK_LIBRARY_MSG, null);
    public static final int PROP_DIRTY = 1;
    public static LibraryProcessor instance = null;
    protected AdapterFactoryEditingDomain editingDomain;
    private Map saveOptions;
    private List listeners = new ArrayList();
    private List tmp_listeners_tobe_deleted = new ArrayList();
    boolean loaded = false;
    private boolean inOperation = false;
    private VersionManager versionMgr = null;
    private ElementLayoutManager layoutMgr = null;
    private ConfigurationFactory configfactory = null;
    private boolean isSingletonInstance = false;
    private FileLock lock;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            if (!LibraryProcessor.this.inOperation) {
                SafeUpdateController.asyncExec(new Runnable(this, event){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ EventObject val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = eventObject;
                    }

                    public void run() {
                        Command mostRecentCommand = LibraryUtil.unwrap(((CommandStack)this.val$event.getSource()).getMostRecentCommand());
                        if (mostRecentCommand != null) {
                            if (mostRecentCommand instanceof AddCommand) {
                                AddCommand cmd = (AddCommand)mostRecentCommand;
                                EObject owner = cmd.getOwner();
                                if (owner instanceof MethodConfiguration) {
                                    ArrayList<EObject> objs = new ArrayList<EObject>();
                                    objs.add(owner);
                                    LibraryProcessor.access$1(1.access$0(this.this$1), 8, objs);
                                } else {
                                    Collection objs = mostRecentCommand.getResult();
                                    LibraryProcessor.access$1(1.access$0(this.this$1), 32, objs);
                                    if (owner instanceof MethodPackage && !(objs = LibraryUtil.getContainedElements(owner, objs)).isEmpty()) {
                                        LibraryProcessor.access$2(1.access$0(this.this$1), objs);
                                    }
                                }
                            } else if (mostRecentCommand instanceof PasteFromClipboardCommand) {
                                Collection objs = mostRecentCommand.getResult();
                                LibraryProcessor.access$1(1.access$0(this.this$1), 32, objs);
                                PasteFromClipboardCommand cmd = (PasteFromClipboardCommand)mostRecentCommand;
                                if (cmd.getOwner() instanceof MethodPackage && !(objs = LibraryUtil.getContainedElements(cmd.getOwner(), objs)).isEmpty()) {
                                    LibraryProcessor.access$2(1.access$0(this.this$1), objs);
                                }
                            } else if (mostRecentCommand instanceof CreateChildCommand) {
                                LibraryProcessor.access$1(1.access$0(this.this$1), 32, mostRecentCommand.getAffectedObjects());
                            } else if (mostRecentCommand != null) {
                                LibraryProcessor.access$1(1.access$0(this.this$1), 8, mostRecentCommand.getAffectedObjects());
                            }
                        }
                    }
                });
            }
        }

        static /* synthetic */ LibraryProcessor access$0(1 var0) {
            return var0.LibraryProcessor.this;
        }
    };
    private INotifyChangedListener notifyChangedListener = new INotifyChangedListener(){

        public void notifyChanged(Notification notification) {
            if (!LibraryProcessor.this.inOperation) {
                int eventType = notification.getEventType();
                switch (eventType) {
                    case 3: {
                        Object notifier = notification.getNotifier();
                        Object v = notification.getNewValue();
                        if (!(notifier instanceof MethodLibrary) || !(v instanceof MethodPlugin)) break;
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        affectedObjects.add(v);
                        LibraryProcessor.this.notifyListeners(32, affectedObjects);
                        break;
                    }
                    case 1: {
                        LibraryProcessor.this.setDirty(true);
                        Object notifier = notification.getNotifier();
                        if (notifier == null) break;
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        affectedObjects.add(notifier);
                        LibraryProcessor.this.notifyListeners(8, affectedObjects);
                        break;
                    }
                    case 4: {
                        LibraryProcessor.this.setDirty(true);
                        Object notifier = notification.getNotifier();
                        Object oldValue = notification.getOldValue();
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        if (oldValue instanceof EObject && ((EObject)oldValue).eContainer() == null) {
                            affectedObjects.add(oldValue);
                            LibraryProcessor.this.notifyListeners(16, affectedObjects);
                            break;
                        }
                        affectedObjects.add(notifier);
                        LibraryProcessor.this.notifyListeners(8, affectedObjects);
                        break;
                    }
                    case 6: {
                        LibraryProcessor.this.setDirty(true);
                        ArrayList oldValue = new ArrayList((Collection)notification.getOldValue());
                        ArrayList deletedElements = new ArrayList();
                        ArrayList removedReferences = new ArrayList();
                        if (!oldValue.isEmpty()) {
                            Iterator iter = oldValue.iterator();
                            while (iter.hasNext()) {
                                Object element = iter.next();
                                if (!(element instanceof EObject)) continue;
                                if (((EObject)element).eContainer() == null) {
                                    deletedElements.add(element);
                                    continue;
                                }
                                removedReferences.add(element);
                            }
                        }
                        if (!deletedElements.isEmpty()) {
                            LibraryProcessor.this.notifyListeners(16, deletedElements);
                        }
                        if (removedReferences.isEmpty()) break;
                        LibraryProcessor.this.notifyListeners(8, removedReferences);
                    }
                }
            }
        }
    };
    private boolean listenerAdded = false;
    private Adapter libChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            block15: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ibm.uma.MethodLibrary");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                block1 : switch (msg.getFeatureID((Class)clazz)) {
                    case 11: {
                        switch (msg.getEventType()) {
                            case 3: {
                                MethodPlugin plugin = (MethodPlugin)msg.getNewValue();
                                plugin.eResource().eAdapters().add((Object)LibraryProcessor.this.resourceChangedListener);
                                break block1;
                            }
                            case 5: {
                                Iterator iter = ((Collection)msg.getNewValue()).iterator();
                                while (iter.hasNext()) {
                                    MethodPlugin plugin = (MethodPlugin)iter.next();
                                    plugin.eResource().eAdapters().add((Object)LibraryProcessor.this.resourceChangedListener);
                                }
                                break block15;
                            }
                            case 4: {
                                MethodPlugin plugin = (MethodPlugin)msg.getOldValue();
                                plugin.eResource().eAdapters().remove((Object)LibraryProcessor.this.resourceChangedListener);
                                break block1;
                            }
                            case 6: {
                                Iterator iter = ((Collection)msg.getOldValue()).iterator();
                                while (iter.hasNext()) {
                                    MethodPlugin plugin = (MethodPlugin)iter.next();
                                    plugin.eResource().eAdapters().remove((Object)LibraryProcessor.this.resourceChangedListener);
                                }
                                break block1;
                            }
                        }
                    }
                }
            }
        }
    };
    private Adapter resourceChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(null) == 3 && msg.getEventType() == 1) {
                LibraryProcessor.this.firePropertyChange(msg.getNotifier(), 1);
            }
        }
    };
    private ListenerList propChangeListeners = new ListenerList();
    private IRefreshListener refreshListener = new IRefreshListener(){

        public void notifyRefreshed(IRefreshEvent event) {
            LibraryProcessor.this.handleRefreshEvent(event);
        }
    };
    private ILibraryResourceManager resourceManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewPackagesToConfiguration(Collection newobjs) {
        if (newobjs == null) return;
        if (newobjs.size() == 0) {
            return;
        }
        LibraryModificationHelper helper = new LibraryModificationHelper();
        try {
            try {
                Iterator it = newobjs.iterator();
                while (it.hasNext()) {
                    Object configs;
                    EObject parent;
                    EObject e = (EObject)it.next();
                    if (!(e instanceof MethodPackage) || (parent = e.eContainer()) == null || !(parent instanceof MethodPackage) || !((configs = ((MultiResourceEObject)parent).getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations)) instanceof List)) continue;
                    Iterator itconfig = ((List)configs).iterator();
                    while (itconfig.hasNext()) {
                        MethodConfiguration config = (MethodConfiguration)itconfig.next();
                        List pkgs = config.getMethodPackageSelection();
                        if (pkgs.contains(e)) continue;
                        helper.getActionManager().doAction(3, (EObject)config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPackageSelection(), (Object)e, -1);
                    }
                }
                helper.save();
            }
            catch (RuntimeException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            Object var10_13 = null;
            helper.dispose();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            helper.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryProcessor getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.epf.library.services.LibraryProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new LibraryProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void handleRefreshEvent(IRefreshEvent event) {
        if (Log.DEBUG) {
            System.out.println("LibraryProcessor.handleRefreshEvent()");
            System.out.println("  refreshed resources: " + event.getRefreshedResources());
        }
        if (!event.getUnloadedObjects().isEmpty()) {
            TngAdapterFactory.INSTANCE.cleanUp();
        }
    }

    private LibraryProcessor() {
        this.init();
        this.isSingletonInstance = true;
    }

    public LibraryProcessor(Resource res) {
        this();
        if (res != null) {
            this.setResource(res);
        }
        this.isSingletonInstance = false;
    }

    public LibraryProcessor(String libraryPath) throws Exception {
        this();
        this.openLibrary(libraryPath);
        this.isSingletonInstance = false;
    }

    public ILibraryResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    protected void firePropertyChange(final Object source, final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            SafeUpdateController.asyncExec(new Runnable(){

                public void run() {
                    l.propertyChanged(source, propertyId);
                }
            });
            ++nX;
        }
    }

    private void addLibraryListeners() {
        MethodLibrary library = this.getLibrary();
        if (library == null || library.eResource() == null) {
            return;
        }
        if (!library.eResource().eAdapters().contains((Object)this.resourceChangedListener)) {
            library.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        Iterator iter = library.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            if (plugin.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            plugin.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
    }

    private void removeLibraryListeners() {
        MethodLibrary library = this.getLibrary();
        if (library == null || library.eResource() == null) {
            return;
        }
        library.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        Iterator iter = library.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            plugin.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ILibraryChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ILibraryChangeListener listener) {
        List list = this.tmp_listeners_tobe_deleted;
        synchronized (list) {
            if (!this.tmp_listeners_tobe_deleted.contains(listener)) {
                this.tmp_listeners_tobe_deleted.add(listener);
            }
        }
    }

    private synchronized void notifyListeners(final int option, final Collection collection) {
        this.loaded = true;
        try {
            if (this.tmp_listeners_tobe_deleted.size() > 0) {
                Iterator it = this.tmp_listeners_tobe_deleted.iterator();
                while (it.hasNext()) {
                    Object l = it.next();
                    if (!this.listeners.contains(l)) continue;
                    this.listeners.remove(l);
                }
                this.tmp_listeners_tobe_deleted.clear();
            }
            int i = 0;
            while (i < this.listeners.size()) {
                final ILibraryChangeListener listener = (ILibraryChangeListener)this.listeners.get(i);
                if (listener != null) {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.libraryChanged(option, collection);
                        }
                    });
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void beginOperation() {
        this.inOperation = true;
    }

    private void endOperation() {
        this.inOperation = false;
    }

    public void updateShellTitle() {
        Shell shell;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (shell = window.getShell()) != null) {
            shell.setText(LibraryResources.formatString("Library.shellTitle.text", LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath()));
        }
    }

    public static String getLibraryModelFile(String path) {
        if (!StrUtil.isBlank((String)path)) {
            String suffix;
            String libPath = new File(path).getAbsolutePath();
            if (libPath.endsWith(suffix = String.valueOf(File.separator) + "library.xmi")) {
                return libPath;
            }
            return String.valueOf(libPath) + suffix;
        }
        return path;
    }

    public static IStatus isValidLibrary(String path, boolean validateModelFile) {
        String libFullPath;
        File libFile;
        if (path == null || path.trim().length() == 0) {
            return EMPTY_METHOD_LIBRARY_PATH_STATUS;
        }
        if (validateModelFile && !(libFile = new File(LibraryProcessor.getLibraryModelFile(path))).exists()) {
            return MISSING_LIBRARY_FILE_STATUS;
        }
        File libPath = new File(path);
        if (path.endsWith("library.xmi")) {
            libPath = libPath.getParentFile();
        }
        if ((libFullPath = libPath.getAbsolutePath()).startsWith("\\")) {
            boolean isValid = true;
            int index = libFullPath.indexOf(File.separatorChar, 2);
            if (index < 0) {
                isValid = false;
            } else {
                String uncPath = libFullPath.substring(index + 1);
                if (uncPath.length() == 0) {
                    isValid = false;
                } else {
                    uncPath = (index = libFullPath.indexOf(File.separatorChar, index + 1)) < 0 ? libFullPath : libFullPath.substring(0, index);
                    File f = new File(uncPath);
                    if (!f.exists()) {
                        isValid = false;
                    }
                }
            }
            if (!isValid) {
                return EMPTY_METHOD_LIBRARY_PATH_STATUS;
            }
        }
        IProjectDescription description = null;
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(libFullPath) + File.separator + ".project"));
            if (description != null) {
                return Status.OK_STATUS;
            }
        }
        catch (CoreException coreException) {}
        IProject project = ResourceUtil.findProject(libFullPath);
        if (project == null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(libPath.getName());
        }
        return ResourcesPlugin.getWorkspace().validateProjectLocation(project, (IPath)new Path(libFullPath));
    }

    public static IStatus isValidLibrary(String path) {
        return LibraryProcessor.isValidLibrary(path, false);
    }

    public boolean isValid(EObject object) {
        if (object != null && object.eIsProxy()) {
            EObject e = RefreshJob.getInstance().resolve(object);
            return e instanceof MethodElement && !e.eIsProxy() && UmaUtil.getMethodLibrary((EObject)e) == LibraryProcessor.getInstance().getLibrary();
        }
        return true;
    }

    public boolean ensureLibraryProjectOpen(IProgressMonitor monitor) {
        IProject prj;
        MethodLibrary lib = this.getLibrary();
        if (lib != null && (prj = ResourceUtil.findProject(lib)) != null && !prj.isOpen()) {
            try {
                prj.open(128, monitor);
                return true;
            }
            catch (CoreException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return false;
    }

    public void openLibrary() throws Exception {
        String openLibrary = String.valueOf(this.getLibraryRootPath().getAbsolutePath()) + File.separator + "library.xmi";
        if (openLibrary != null && !openLibrary.equals("")) {
            this.openLibrary(openLibrary);
        }
    }

    public boolean conversionRequired(String libraryPath) {
        return PersistenceUtil.conversionRequired((String)libraryPath);
    }

    public IStatus openLibrary(String libraryPath) throws Exception {
        try {
            IStatus status;
            this.beginOperation();
            File libDir = new File(libraryPath).getParentFile();
            File oldLibDir = this.getLibraryRootPath();
            boolean closeLibProject = oldLibDir != null && !libDir.equals(oldLibDir);
            this.closeOpenedLibrary(closeLibProject);
            this.lockLibrary(libDir);
            ResourceUtil.open(libDir.getAbsolutePath(), null);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
            this.assignLibrary(resourceSet.loadLibrary(libraryPath));
            resourceSet.getResourceErrorDialog().showResourceErrors();
            resourceSet.getResourceErrorDialog().setShowImmediately(true);
            if (!resourceSet.hasUnresolvedProxy()) {
                String msg = LibraryResources.getString("Library.unresolvedProxyError.reason");
                status = new Status(2, LibraryPlugin.getDefault().getId(), 0, msg, null);
            } else {
                status = Status.OK_STATUS;
            }
            this.notifyListeners(1, null);
            IStatus iStatus = status;
            Object var8_9 = null;
            this.endOperation();
            this.firePropertyChange(this.getLibrary(), 1);
            return iStatus;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.endOperation();
            this.firePropertyChange(this.getLibrary(), 1);
            throw throwable;
        }
    }

    private void assignLibrary(MethodLibrary lib) {
        this.removeLibraryListeners();
        this.addLibraryListeners();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void newLibrary(String libraryName, String libraryPath, boolean bMultiple) throws Exception {
        try {
            this.closeOpenedLibrary();
            this.beginOperation();
            File lib_path = new File(libraryPath);
            libraryPath = lib_path.getAbsolutePath();
            ResourceUtil.open(libraryPath, null);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
            ModelStorage.newLibrary(resourceSet, libraryName, libraryPath, bMultiple);
            this.assignLibrary(resourceSet.getMethodLibrary());
            this.lockLibrary(lib_path);
            resourceSet.getResourceErrorDialog().showResourceErrors();
            resourceSet.getResourceErrorDialog().setShowImmediately(true);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.endOperation();
            this.notifyListeners(4, null);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.endOperation();
            this.notifyListeners(4, null);
            return;
        }
    }

    public void save(Resource resource) throws Exception {
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
        if (resourceSet.getResources().contains((Object)resource)) {
            resourceSet.save(resource, this.saveOptions);
        }
    }

    public void saveLibrary() throws Exception {
        MethodLibrary library = this.getLibrary();
        if (library != null) {
            this.doSave(this.saveOptions);
            this.firePropertyChange(library, 1);
            this.notifyListeners(2, null);
        }
    }

    public void saveLibraryAs(String newDir, boolean regenerateGUID, IProgressMonitor monitor) throws Exception {
        String oldLibDir = LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath();
        ResourceUtil.open(newDir, monitor);
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.getLibrary().eResource().getResourceSet();
        resourceSet.saveAs(newDir, regenerateGUID, monitor);
        CopyAttachmentsToNewLocation.copyAttachmentsLibrary(oldLibDir, newDir, null, monitor);
    }

    public void saveLibraryAs(String libraryPath, boolean bMultiple) throws Exception {
        throw new UnsupportedOperationException();
    }

    private void setResource(Resource res) {
        if (res != null) {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
            resourceSet.reset();
            resourceSet.getResources().add((Object)res);
            this.assignLibrary(resourceSet.getMethodLibrary());
            this.notifyListeners(8, null);
        }
    }

    private Resource getLibraryResource() {
        EList res = this.getEditingDomain().getResourceSet().getResources();
        if (res.size() > 0) {
            return (Resource)res.get(0);
        }
        return null;
    }

    public MethodLibrary getLibrary() {
        Resource resource = this.getLibraryResource();
        if (resource != null && resource.getContents().size() > 0) {
            Iterator it = resource.getContents().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof MethodLibrary)) continue;
                return (MethodLibrary)o;
            }
        }
        return null;
    }

    public URI getLibraryURI() {
        Resource savedResource = this.getLibraryResource();
        if (savedResource != null) {
            return savedResource.getURI();
        }
        return null;
    }

    public URI getRelativeURI(MethodElement element) {
        URI libURI = this.getLibraryURI();
        URI elemetnURI = element.eResource().getURI();
        URI relUri = elemetnURI.deresolve(libURI);
        return relUri;
    }

    public synchronized ElementLayoutManager getLayoutManager() {
        if (this.layoutMgr == null && this.getLibrary() != null) {
            this.layoutMgr = new ElementLayoutManager();
        }
        return this.layoutMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationFactory getConfigurationFactory() {
        if (this.configfactory == null) {
            LibraryProcessor libraryProcessor = this;
            synchronized (libraryProcessor) {
                if (this.configfactory == null) {
                    this.configfactory = new ConfigurationFactory(this);
                }
            }
        }
        return this.configfactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionManager getVersionManager() {
        if (this.versionMgr == null) {
            LibraryProcessor libraryProcessor = this;
            synchronized (libraryProcessor) {
                if (this.versionMgr == null) {
                    this.versionMgr = new VersionManager(this);
                }
            }
        }
        return this.versionMgr;
    }

    public void setLibrary(MethodLibrary newLib) {
        this.assignLibrary(newLib);
        Resource res = (Resource)this.getEditingDomain().getResourceSet().getResources().get(0);
        res.getContents().clear();
        res.getContents().add((Object)newLib);
        this.notifyListeners(1, null);
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    private void init() {
        LibraryPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.epf.library.pref.back_up_before_save")) {
                    LibraryProcessor.this.saveOptions.put("BACK_UP_BEFORE_SAVE", event.getNewValue());
                } else if (event.getProperty().equals("org.eclipse.epf.library.pref.discard_unresolved_references")) {
                    LibraryProcessor.this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", event.getNewValue());
                }
            }
        });
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        MultiFileResourceSetImpl resourceSet = new MultiFileResourceSetImpl();
        this.resourceManager = new LibraryResourceManager(resourceSet);
        ResourceErrorDialogHelper dlgHelper = new ResourceErrorDialogHelper();
        dlgHelper.setShowImmediately(false);
        resourceSet.setResourceErrorDialog((MultiFileResourceSetImpl.ResourceErrorDialog)dlgHelper);
        resourceSet.addRefreshListener(this.refreshListener);
        RefreshJob.getInstance().setResourceSet((ResourceSet)resourceSet);
        this.saveOptions = resourceSet.getDefaultSaveOptions();
        boolean b = LibraryPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.epf.library.pref.back_up_before_save");
        this.saveOptions.put("BACK_UP_BEFORE_SAVE", b);
        b = LibraryPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.epf.library.pref.discard_unresolved_references");
        this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", b);
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        MethodLibraryPersister contentDescPersister = new MethodLibraryPersister();
        ContentDescriptionFactory.setMethodLibraryPersister((IMethodLibraryPersister)contentDescPersister);
        ContentDescriptionFactory.setFileManager((IFileManager)FileManager.getInstance());
        this.registerEditingDomain(this.editingDomain);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(Map options) throws Exception {
        if (Log.DEBUG) {
            System.out.println("Save options: " + options);
        }
        try {
            try {
                this.beginOperation();
                MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
                resourceSet.save(options);
                ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.endOperation();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.endOperation();
            return;
        }
    }

    public boolean isDirty() {
        return this.isAnyResourceModified();
    }

    public boolean isAnyResourceModified() {
        Iterator iter = this.editingDomain.getResourceSet().getResources().iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (!resource.isModified()) continue;
            return true;
        }
        return false;
    }

    public void discardChanges() {
        Iterator iter = this.editingDomain.getResourceSet().getResources().iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            resource.setModified(false);
        }
    }

    public boolean isLibraryLoaded() {
        return this.loaded;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return (ComposedAdapterFactory)this.getEditingDomain().getAdapterFactory();
    }

    public List getMethodModels() {
        MethodLibrary library = this.getLibrary();
        return library == null ? new ArrayList() : library.getMethodPlugins();
    }

    public MethodPlugin getMethodPlugin(String guid) {
        if (guid != null) {
            Iterator it = this.getMethodModels().iterator();
            while (it.hasNext()) {
                MethodPlugin p = (MethodPlugin)it.next();
                if (!guid.equals(p.getGuid())) continue;
                return p;
            }
        }
        return null;
    }

    public MethodConfiguration getConfiguration(String name) {
        MethodLibrary library = this.getLibrary();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)it.next();
                if (config instanceof ProcessFamily || !config.getName().equals(name)) continue;
                return config;
            }
        }
        return null;
    }

    public ProcessFamily getProcessFamily(String name) {
        MethodLibrary library = this.getLibrary();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)it.next();
                if (!(config instanceof ProcessFamily) || !config.getName().equals(name)) continue;
                return (ProcessFamily)config;
            }
        }
        return null;
    }

    public MethodConfiguration[] getConfigurations() {
        return this.getConfigurations(true);
    }

    public MethodConfiguration[] getConfigurations(boolean excludeProcessFamily) {
        ArrayList configs = null;
        MethodLibrary library = this.getLibrary();
        if (library != null) {
            configs = library.getPredefinedConfigurations();
        }
        if (excludeProcessFamily) {
            configs = new ArrayList(configs);
            int i = 0;
            while (i < configs.size()) {
                Object o = configs.get(i);
                if (o instanceof ProcessFamily) {
                    configs.remove(i);
                    continue;
                }
                ++i;
            }
        }
        MethodConfiguration[] items = new MethodConfiguration[configs.size()];
        configs.toArray(items);
        return items;
    }

    public String[] getConfigurationNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        MethodLibrary library = this.getLibrary();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)it.next();
                if (config instanceof ProcessFamily) continue;
                configNames.add(config.getName());
            }
        }
        String[] items = new String[configNames.size()];
        configNames.toArray(items);
        return items;
    }

    public String[] getProcessFamilyNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        MethodLibrary library = this.getLibrary();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)it.next();
                if (!(config instanceof ProcessFamily)) continue;
                configNames.add(config.getName());
            }
        }
        String[] items = new String[configNames.size()];
        configNames.toArray(items);
        return items;
    }

    public MethodConfiguration createMethodConfigByName(String configName) {
        return this.createMethodConfiguration(configName);
    }

    private MethodConfiguration createMethodConfiguration(String configName) {
        MethodConfiguration config = null;
        MethodLibrary library = this.getLibrary();
        List configs = library.getPredefinedConfigurations();
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            config = (MethodConfiguration)it.next();
            if (!configName.equals(config.getName())) continue;
            return config;
        }
        config = UmaFactory.eINSTANCE.createMethodConfiguration();
        config.setName(configName);
        configs.add(config);
        return config;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setGuid(MethodElement element) {
        EList children;
        String guid = element.getGuid();
        if (guid == null || guid.equals("")) {
            guid = EcoreUtil.generateUUID();
            boolean oldNotify = element.eDeliver();
            try {
                element.eSetDeliver(false);
                element.setGuid(guid);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                element.eSetDeliver(oldNotify);
                throw throwable;
            }
            {
                Object var4_8 = null;
            }
            element.eSetDeliver(oldNotify);
        }
        if ((children = element.eContents()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (!(child instanceof MethodElement)) continue;
                this.setGuid((MethodElement)child);
            }
        }
    }

    public void registerEditingDomain(AdapterFactoryEditingDomain domain) {
        ((ComposedAdapterFactory)domain.getAdapterFactory()).addListener(this.notifyChangedListener);
        domain.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    public void listenTo(ComposedAdapterFactory adapterFactory) {
        adapterFactory.addListener(this.notifyChangedListener);
    }

    public void stopListeningTo(ComposedAdapterFactory adapterFactory) {
        adapterFactory.removeListener(this.notifyChangedListener);
    }

    public void listenTo(CommandStack commandStack) {
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    public void stopListeningTo(CommandStack commandStack) {
        commandStack.removeCommandStackListener(this.commandStackListener);
    }

    public void setDirty(boolean b) {
    }

    public Map getSaveOptions() {
        return this.saveOptions;
    }

    public void setCurrentConfiguration(String configName) {
        this.getConfigurationFactory().setCurrentConfiguration(configName);
        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(this.getCurrentMethodConfiguration());
        this.notifyListeners(64, null);
    }

    public String getCurrentConfiguration() {
        return this.getConfigurationFactory().getCurrentConfiguration();
    }

    public MethodConfiguration getCurrentMethodConfiguration() {
        String configName = this.getCurrentConfiguration();
        if (configName != null) {
            return this.getConfiguration(configName);
        }
        return null;
    }

    public void listenToProcessEditor() {
        if (this.listenerAdded) {
            return;
        }
        this.listenTo(TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory());
        this.listenTo(TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
        this.listenTo(TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
        this.listenerAdded = true;
    }

    public File getLibraryRootPath() {
        URI uri = this.getLibraryURI();
        if (uri != null) {
            String path = uri.toFileString();
            File f = new File(path);
            return f.getParentFile();
        }
        return null;
    }

    public void addMethodPlugin(final MethodPlugin model) {
        final Exception[] exceptions = new Exception[1];
        SafeUpdateController.syncExec(new Runnable(){

            public void run() {
                LibraryProcessor.this.getLibrary().getMethodPlugins().add(model);
                IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                try {
                    persister.save(LibraryProcessor.this.getLibrary().eResource());
                    persister.commit();
                }
                catch (Exception e) {
                    persister.rollback();
                    exceptions[0] = e;
                    return;
                }
                model.eResource().eAdapters().add((Object)LibraryProcessor.this.resourceChangedListener);
            }
        });
        if (exceptions[0] != null) {
            throw new WrappedException(exceptions[0]);
        }
    }

    public void setNotificationEnabled(boolean b) {
        this.editingDomain.getResourceSet().eSetDeliver(b);
    }

    public boolean isNotificationEnabled() {
        return this.editingDomain.getResourceSet().eDeliver();
    }

    public MethodElement getElement(String guid) {
        MethodElement e = null;
        try {
            MultiFileResourceSetImpl resourceSet;
            if (this.editingDomain != null && (resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet()) != null) {
                e = (MethodElement)resourceSet.getEObject(guid);
            }
        }
        catch (Throwable throwable) {}
        return e;
    }

    public void closeOpenedLibrary() {
        this.closeOpenedLibrary(true);
    }

    public void closeOpenedLibrary(boolean closeLibProject) {
        this.notifyListeners(128, null);
        if (Log.DEBUG) {
            System.out.println("Used memory before closing library: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
        if (this.isSingletonInstance) {
            TngAdapterFactory.INSTANCE.reset();
            if (FilterConstants.hashMap != null) {
                FilterConstants.hashMap.clear();
            }
        }
        if (this.layoutMgr != null) {
            this.layoutMgr.clear();
        }
        if (this.configfactory != null) {
            this.configfactory.clear();
        }
        LayoutResources.clear();
        this.layoutMgr = null;
        this.configfactory = null;
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
        resourceSet.clearErrors();
        MethodLibrary library = this.getLibrary();
        if (closeLibProject && library != null) {
            try {
                ResourceUtil.close(library, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.unlockLibrary();
        resourceSet.reset();
        RefreshJob.getInstance().reset();
        Runtime.getRuntime().gc();
        if (Log.DEBUG) {
            System.out.println("Used memory after closing library: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
    }

    public boolean isReadOnly() {
        URI uri = this.getLibraryURI();
        String path = uri.toFileString();
        File f = new File(path);
        return f.exists() && !f.canWrite();
    }

    private void unlockLibrary() {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.lock.channel().close();
            }
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public boolean isLibraryLocked(File libDirFile) {
        if (this.getLibrary() != null && libDirFile.equals(this.getLibraryRootPath())) {
            return false;
        }
        File lockFile = new File(libDirFile, ".lock");
        return FileUtil.isFileLocked((File)lockFile);
    }

    public boolean isLibraryLocked(String libDir) {
        return this.isLibraryLocked(new File(libDir));
    }

    public void lockLibrary(File libDirFile) {
        File lockFile = new File(libDirFile, ".lock");
        this.lock = FileUtil.lockFile((File)lockFile);
    }

    public void refreshResources(IProgressMonitor monitor) throws Exception {
    }

    static /* synthetic */ void access$2(LibraryProcessor libraryProcessor, Collection collection) {
        libraryProcessor.addNewPackagesToConfiguration(collection);
    }
}

