/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;

public class ResourceErrorDialogHelper
extends MultiFileResourceSetImpl.BasicResourceErrorDialog {
    private Collection errors = new ArrayList();

    public void setShowImmediately(boolean show) {
    }

    public void addResourceError(String msg) {
        if (!this.errors.contains(msg)) {
            this.errors.add(msg);
        }
    }

    public void showResourceErrors() {
        if (!this.errors.isEmpty()) {
            final MultiStatus multiStatus = new MultiStatus(LibraryPlugin.getDefault().getId(), 0, LibraryResources.getString("Library.loadResourcesError.reason"), null);
            Iterator iter = this.errors.iterator();
            while (iter.hasNext()) {
                String e = (String)iter.next();
                Status status = new Status(4, LibraryPlugin.getDefault().getId(), 0, e, null);
                multiStatus.add((IStatus)status);
            }
            SafeUpdateController.syncExec(new Runnable(){

                public void run() {
                    try {
                        LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.getString("Library.loadResourcesError.title"), LibraryResources.getString("Library.loadResourcesError.msg"), (IStatus)multiStatus);
                        ResourceErrorDialogHelper.this.errors.clear();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

