/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.navigator.NavigatorContentService;

public class NavigatorContentServiceLabelProvider
extends EventManager
implements ILabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider {
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;

    public NavigatorContentServiceLabelProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public Image getImage(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        Image image = null;
        int i = 0;
        while (i < labelProviders.length && image == null) {
            image = labelProviders[i].getImage(anElement);
            ++i;
        }
        return image;
    }

    public String getText(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        String text = null;
        int i = 0;
        while (i < labelProviders.length && text == null) {
            text = labelProviders[i].getText(anElement);
            ++i;
        }
        return text == null ? "" : text;
    }

    public Font getFont(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IFontProvider fontProvider;
            Font font;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IFontProvider && (font = (fontProvider = (IFontProvider)provider).getFont(anElement)) != null) {
                return font;
            }
            ++i;
        }
        return null;
    }

    public Color getForeground(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getForeground(anElement)) != null) {
                return color;
            }
            ++i;
        }
        return null;
    }

    public Color getBackground(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getBackground(anElement)) != null) {
                return color;
            }
            ++i;
        }
        return null;
    }

    public boolean isLabelProperty(Object anElement, String aProperty) {
        boolean result = false;
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length && !result) {
            result = labelProviders[i].isLabelProperty(anElement, aProperty);
            ++i;
        }
        return result;
    }

    public void addListener(ILabelProviderListener aListener) {
        this.addListenerObject(aListener);
    }

    public void removeListener(ILabelProviderListener aListener) {
        this.removeListenerObject(aListener);
    }

    public void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] theListeners = this.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)theListeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(elementPath.getLastSegment());
        Object image = null;
        int i = 0;
        while (i < labelProviders.length && image == null) {
            ILabelProvider labelProvider = labelProviders[i];
            if (labelProvider instanceof ITreePathLabelProvider) {
                ITreePathLabelProvider tplp = (ITreePathLabelProvider)labelProvider;
                tplp.updateLabel(label, elementPath);
            } else {
                label.setImage(this.getImage(elementPath.getLastSegment()));
                label.setText(this.getText(elementPath.getLastSegment()));
            }
            ++i;
        }
    }
}

