/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class NavigatorPipelineService
implements INavigatorPipelineService {
    private NavigatorContentService contentService;

    public NavigatorPipelineService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        ContributorTrackingSet trackedSet = (ContributorTrackingSet)anAddModification.getChildren();
        Set contentDescriptors = this.contentService.findDescriptorsByTriggerPoint(anAddModification.getParent());
        Iterator descriptorsItr = contentDescriptors.iterator();
        while (descriptorsItr.hasNext()) {
            INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorsItr.next();
            this.pipelineInterceptAdd(anAddModification, trackedSet, descriptor);
        }
        return anAddModification;
    }

    private void pipelineInterceptAdd(PipelinedShapeModification anAddModification, ContributorTrackingSet trackedSet, INavigatorContentDescriptor descriptor) {
        if (descriptor.hasOverridingExtensions()) {
            Set overridingDescriptors = descriptor.getOverriddingExtensions();
            Iterator overridingDescriptorsItr = overridingDescriptors.iterator();
            while (overridingDescriptorsItr.hasNext()) {
                INavigatorContentDescriptor overridingDescriptor = (INavigatorContentDescriptor)overridingDescriptorsItr.next();
                if (!this.contentService.isActive(overridingDescriptor.getId())) continue;
                trackedSet.setContributor((NavigatorContentDescriptor)overridingDescriptor);
                NavigatorContentExtension extension = this.contentService.getExtension(overridingDescriptor);
                ((IPipelinedTreeContentProvider)extension.internalGetContentProvider()).interceptAdd(anAddModification);
                trackedSet.setContributor(null);
                this.pipelineInterceptAdd(anAddModification, trackedSet, overridingDescriptor);
            }
        }
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        ContributorTrackingSet trackedSet = (ContributorTrackingSet)aRemoveModification.getChildren();
        Set contentDescriptors = this.contentService.findDescriptorsByTriggerPoint(aRemoveModification.getParent());
        Iterator descriptorsItr = contentDescriptors.iterator();
        while (descriptorsItr.hasNext()) {
            INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorsItr.next();
            this.pipelineInterceptRemove(aRemoveModification, trackedSet, descriptor);
        }
        return aRemoveModification;
    }

    private void pipelineInterceptRemove(PipelinedShapeModification anAddModification, ContributorTrackingSet trackedSet, INavigatorContentDescriptor descriptor) {
        if (descriptor.hasOverridingExtensions()) {
            Set overridingDescriptors = descriptor.getOverriddingExtensions();
            Iterator overridingDescriptorsItr = overridingDescriptors.iterator();
            while (overridingDescriptorsItr.hasNext()) {
                INavigatorContentDescriptor overridingDescriptor = (INavigatorContentDescriptor)overridingDescriptorsItr.next();
                if (!this.contentService.isActive(overridingDescriptor.getId())) continue;
                trackedSet.setContributor((NavigatorContentDescriptor)overridingDescriptor);
                NavigatorContentExtension extension = this.contentService.getExtension(overridingDescriptor);
                ((IPipelinedTreeContentProvider)extension.internalGetContentProvider()).interceptRemove(anAddModification);
                trackedSet.setContributor(null);
                this.pipelineInterceptRemove(anAddModification, trackedSet, overridingDescriptor);
            }
        }
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        HashSet overrideableExtensions = new HashSet();
        Iterator iter = aRefreshSynchronization.getRefreshTargets().iterator();
        while (iter.hasNext()) {
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(iter.next()));
        }
        if (overrideableExtensions.isEmpty()) {
            return false;
        }
        return this.pipelineRefresh(overrideableExtensions, aRefreshSynchronization);
    }

    private boolean pipelineRefresh(Set overrideableExtensions, PipelinedViewerUpdate aRefreshSynchronization) {
        boolean intercepted = false;
        Iterator extensionsItr = overrideableExtensions.iterator();
        while (extensionsItr.hasNext()) {
            NavigatorContentExtension extension = (NavigatorContentExtension)extensionsItr.next();
            if (!(extension.getContentProvider() instanceof IPipelinedTreeContentProvider)) continue;
            intercepted |= ((IPipelinedTreeContentProvider)extension.getContentProvider()).interceptRefresh(aRefreshSynchronization);
            if (!extension.getDescriptor().hasOverridingExtensions()) continue;
            HashSet<NavigatorContentExtension> nextLevelOfOverrideableExtensions = new HashSet<NavigatorContentExtension>();
            Iterator refreshTargetsItr = aRefreshSynchronization.getRefreshTargets().iterator();
            while (refreshTargetsItr.hasNext()) {
                nextLevelOfOverrideableExtensions.addAll(Arrays.asList(extension.getOverridingExtensionsForPossibleChild(refreshTargetsItr.next())));
            }
            if (nextLevelOfOverrideableExtensions.isEmpty()) continue;
            intercepted |= this.pipelineRefresh(nextLevelOfOverrideableExtensions, aRefreshSynchronization);
        }
        return intercepted;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        HashSet overrideableExtensions = new HashSet();
        Iterator iter = anUpdateSynchronization.getRefreshTargets().iterator();
        while (iter.hasNext()) {
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(iter.next()));
        }
        if (overrideableExtensions.isEmpty()) {
            return false;
        }
        return this.pipelineUpdate(overrideableExtensions, anUpdateSynchronization);
    }

    private boolean pipelineUpdate(Set overrideableExtensions, PipelinedViewerUpdate anUpdateSynchronization) {
        boolean intercepted = false;
        Iterator extensionsItr = overrideableExtensions.iterator();
        while (extensionsItr.hasNext()) {
            NavigatorContentExtension extension = (NavigatorContentExtension)extensionsItr.next();
            if (!(extension.getContentProvider() instanceof IPipelinedTreeContentProvider)) continue;
            intercepted |= ((IPipelinedTreeContentProvider)extension.getContentProvider()).interceptUpdate(anUpdateSynchronization);
            if (!extension.getDescriptor().hasOverridingExtensions()) continue;
            HashSet<NavigatorContentExtension> nextLevelOfOverrideableExtensions = new HashSet<NavigatorContentExtension>();
            Iterator refreshTargetsItr = anUpdateSynchronization.getRefreshTargets().iterator();
            while (refreshTargetsItr.hasNext()) {
                nextLevelOfOverrideableExtensions.addAll(Arrays.asList(extension.getOverridingExtensionsForPossibleChild(refreshTargetsItr.next())));
            }
            if (nextLevelOfOverrideableExtensions.isEmpty()) continue;
            intercepted |= this.pipelineUpdate(nextLevelOfOverrideableExtensions, anUpdateSynchronization);
        }
        return intercepted;
    }
}

