/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.IViewerExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.SaveablesProviderFactory;
import org.osgi.framework.Bundle;

public class NavigatorSaveablesProviderFactoryManager {
    private static final NavigatorSaveablesProviderFactoryManager INSTANCE = new NavigatorSaveablesProviderFactoryManager();
    private final Map saveableModelProviderFactories = new HashMap();

    public static NavigatorSaveablesProviderFactoryManager getInstance() {
        return INSTANCE;
    }

    protected NavigatorSaveablesProviderFactoryManager() {
        new NavigatorSaveableModelProviderFactoryRegistry().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveablesProviderFactory[] getSaveablesProviderFactories(String contentExtensionId) {
        Map map = this.saveableModelProviderFactories;
        synchronized (map) {
            ArrayList result = new ArrayList();
            Iterator it = this.saveableModelProviderFactories.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Bundle bundle = (Bundle)entry.getKey();
                Object classnameOrObject = entry.getValue();
                if (classnameOrObject instanceof String) {
                    try {
                        Class clazz = bundle.loadClass((String)classnameOrObject);
                        SaveablesProviderFactory saveablesProviderFactory = (SaveablesProviderFactory)clazz.newInstance();
                        classnameOrObject = saveablesProviderFactory;
                        entry.setValue(classnameOrObject);
                    }
                    catch (ClassNotFoundException ex) {
                        NavigatorPlugin.logError(0, "could not load subclass of SaveablesProviderFactory", ex);
                    }
                    catch (InstantiationException ex) {
                        NavigatorPlugin.logError(0, "could not instantiate SaveablesProviderFactory", ex);
                    }
                    catch (IllegalAccessException ex) {
                        NavigatorPlugin.logError(0, "could not access subclass of SaveablesProviderFactory", ex);
                    }
                }
                if (!(classnameOrObject instanceof SaveablesProviderFactory)) continue;
                result.add(classnameOrObject);
            }
            return result.toArray(new SaveablesProviderFactory[result.size()]);
        }
    }

    private class NavigatorSaveableModelProviderFactoryRegistry
    extends RegistryReader
    implements IViewerExtPtConstants {
        protected NavigatorSaveableModelProviderFactoryRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, "saveablesProviderFactory");
        }

        protected boolean readElement(IConfigurationElement element) {
            if ("saveablesProviderFactory".equals(element.getName())) {
                String className = element.getAttribute("class");
                String bundleName = element.getDeclaringExtension().getContributor().getName();
                Bundle bundle = Platform.getBundle((String)bundleName);
                NavigatorSaveablesProviderFactoryManager.this.saveableModelProviderFactories.put(bundle, className);
                return true;
            }
            return false;
        }
    }
}

