/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.help.internal.index.IndexBuilder;
import org.eclipse.help.internal.util.ResourceLocator;

public class IndexFile {
    private String plugin;
    private String href;
    private String locale;

    protected IndexFile(String plugin, String href, String locale) {
        this.plugin = plugin;
        this.href = href;
        this.locale = locale;
    }

    public String getHref() {
        return this.href;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getPluginID() {
        return this.plugin;
    }

    public void build(IndexBuilder builder) {
        builder.buildIndexFile(this);
    }

    protected InputStream getInputStream() {
        InputStream stream = null;
        try {
            stream = this.plugin != null ? ResourceLocator.openFromPlugin(this.plugin, this.href, this.locale) : new FileInputStream(this.href);
        }
        catch (IOException iOException) {}
        return stream;
    }

    public String toString() {
        return String.valueOf(this.plugin) + "/" + this.href;
    }
}

