/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp;

import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.util.UmaUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;

public class PlanningUtil {
    public static Map getProcesses() {
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext()) {
            String[] deliveryProcessPaths;
            String[] capabilityPatternPaths;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (methodPackage instanceof ProcessPackage && methodPackage instanceof ProcessPackage) {
                PlanningUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
            }
            if (!((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath))) instanceof ProcessPackage) || !(methodPackage instanceof ProcessPackage)) continue;
            PlanningUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getCapabilityPatterns() {
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext()) {
            String[] capabilityPatternPaths;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            PlanningUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getDeliveryProcesses() {
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext()) {
            String[] deliveryProcessPaths;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            PlanningUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getContexts(Process process) {
        if (process == null) {
            return null;
        }
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        if (library == null) {
            return null;
        }
        TreeMap<String, MethodConfiguration> result = new TreeMap<String, MethodConfiguration>();
        MethodConfiguration defaultContext = process.getDefaultContext();
        if (defaultContext != null) {
            result.put(defaultContext.getName(), defaultContext);
        }
        List contexts = process.getValidContext();
        Iterator i = contexts.iterator();
        while (i.hasNext()) {
            MethodConfiguration context = (MethodConfiguration)i.next();
            if (context == null) continue;
            result.put(context.getName(), context);
        }
        return result;
    }

    protected static void getCapabilityPatterns(ProcessPackage processPackage, Map result) {
        List childPackages = processPackage.getChildPackages();
        Iterator i = childPackages.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)obj;
                Process process = processComponent.getProcess();
                if (!(process instanceof CapabilityPattern)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(obj instanceof ProcessPackage)) continue;
            PlanningUtil.getCapabilityPatterns((ProcessPackage)obj, result);
        }
    }

    protected static void getDeliveryProcesses(ProcessPackage processPackage, Map result) {
        List childPackages = processPackage.getChildPackages();
        Iterator i = childPackages.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)obj;
                Process process = processComponent.getProcess();
                if (!(process instanceof DeliveryProcess)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(obj instanceof ProcessPackage)) continue;
            PlanningUtil.getDeliveryProcesses((ProcessPackage)obj, result);
        }
    }
}

