/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.wizards;

import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.Process;
import java.io.File;
import org.eclipse.epf.export.msp.ExportMspResources;
import org.eclipse.epf.export.msp.MspPlugin;
import org.eclipse.epf.export.msp.PlanningServiceException;
import org.eclipse.epf.export.msp.services.MSProjectPlanningService;
import org.eclipse.epf.export.msp.wizards.ExportToMSProjectWizardPage1;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.publishing.wizards.PublishConfigPublishOptionsPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportToMSProjectWizard
extends Wizard
implements IExportWizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected ExportToMSProjectWizardPage1 page1;
    protected PublishConfigPublishOptionsPage page2;
    protected PublishOptions publishingOptions = new PublishOptions();
    static /* synthetic */ Class class$0;

    public ExportToMSProjectWizard() {
        this.setWindowTitle(ExportMspResources.getString("ExportMspUI.exportTemplateWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.page1 = new ExportToMSProjectWizardPage1(ExportToMSProjectWizardPage1.PAGE_NAME);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.publishing.wizards.PublishConfigPublishOptionsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.page2 = new PublishConfigPublishOptionsPage(clazz.getName(), false, this.publishingOptions);
        super.addPage((IWizardPage)this.page1);
        super.addPage((IWizardPage)this.page2);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(MspPlugin.getDefault().getSharedImage("full/obj16/ProjectTemplate.gif"));
    }

    public boolean canFinish() {
        if (this.page1.getPublishedConfiguration()) {
            return this.getContainer().getCurrentPage() == this.page2 && this.page2.isPageComplete();
        }
        return this.page1.isPageComplete();
    }

    public boolean performFinish() {
        boolean ok;
        ExportToMSProjectWizardPage1 page = this.page1;
        Process process = page.getProcess();
        String processContextName = page.getProcessContextName();
        boolean publishConfiguration = page.getPublishedConfiguration();
        if (publishConfiguration) {
            this.publishingOptions = this.page2.getPublishingOptions();
            PublishingUIPreferences.setTitle((String)this.publishingOptions.getTitle());
            PublishingUIPreferences.setBannerImage((String)this.publishingOptions.getBannerImage());
            PublishingUIPreferences.setAboutHTML((String)this.publishingOptions.getAboutHTML());
            PublishingUIPreferences.setFeedbackURL((String)this.publishingOptions.getFeedbackURL());
            PublishingUIPreferences.setIncludeGlossary((boolean)this.publishingOptions.isGenerateGlossary());
            PublishingUIPreferences.setIncludeIndex((boolean)this.publishingOptions.isGenerateIndex());
            PublishingUIPreferences.setIncludeSearch((boolean)this.publishingOptions.isGenerateSearchDB());
            PublishingUIPreferences.setIncludeProcessCustomization((boolean)this.publishingOptions.isUseApplet());
            PublishingUIPreferences.setCheckExternalLinks((boolean)this.publishingOptions.isCheckExtLinks());
            LibraryUIPreferences.setPublishUnopenActivitydd((boolean)this.publishingOptions.isAutoGenerateActivityDiagrams());
        } else {
            this.publishingOptions = null;
        }
        String msprojectName = page.getTemplateName();
        String targetDir = page.getTargetDirectory();
        String templateFileName = String.valueOf(msprojectName) + ".xml";
        File templateFile = new File(targetDir, templateFileName);
        if (templateFile.exists() && !(ok = MspPlugin.getDefault().getMsgDialog().displayPrompt(ExportMspResources.getString("ExportMspUI.exportTemplateDialog.title"), ExportMspResources.formatString("ExportMspUI.overwriteText.msg", new String[]{templateFileName, targetDir})))) {
            return false;
        }
        MSProjectPlanningService planningService = MSProjectPlanningService.getInstance();
        try {
            boolean exportOnlyPlannedElements = page.getExportOnlyPlannedElements();
            boolean success = planningService.exportToMSProject(process, msprojectName, new File(targetDir), exportOnlyPlannedElements, this.publishingOptions);
            if (success) {
                MspPlugin.getDefault().getMsgDialog().displayInfo(ExportMspResources.getString("ExportMspUI.exportTemplateDialog.title"), ExportMspResources.formatString("ExportMspUI.completedText.msg", new String[]{process.getName(), templateFile.getAbsolutePath()}));
            }
        }
        catch (PlanningServiceException e) {
            MspPlugin.getDefault().getMsgDialog().displayError(ExportMspResources.getString("ExportMspUI.exportTemplateDialog.title"), ExportMspResources.formatString("ExportMspUI.exportTemplateError.msg", new String[]{process.getName(), templateFile.getAbsolutePath()}), ExportMspResources.getString("ExportMspUI.exportTemplateError.reason"), (Throwable)e);
        }
        MspPlugin planningPlugin = MspPlugin.getDefault();
        IPreferenceStore prefStore = planningPlugin.getPreferenceStore();
        if (process != null) {
            if (process instanceof DeliveryProcess) {
                prefStore.setValue("processType", "DeliveryProcess");
            } else {
                prefStore.setValue("processType", "CapabilityPattern");
            }
            prefStore.setValue("processName", process.getName());
        }
        prefStore.setValue("context", processContextName);
        prefStore.setValue("templateNames", msprojectName);
        prefStore.setValue("targetDirs", targetDir);
        planningPlugin.savePluginPreferences();
        return true;
    }
}

