/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.richtext.html.Link;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddLinkDialog
extends BaseDialog {
    protected Link link = new Link();
    protected Text urlText;
    protected String basePath;
    protected Composite composite;
    protected Label urlLabel;

    public AddLinkDialog(Shell parent, String basePath) {
        super(parent);
        this.basePath = basePath;
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        this.urlLabel = new Label(this.composite, 0);
        this.urlLabel.setText(RichTextResources.getString("RichText.urlLabel.text"));
        this.urlText = new Text(this.composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.urlText.setLayoutData((Object)gridData);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddLinkDialog.this.okButton != null) {
                    AddLinkDialog.this.okButton.setEnabled(AddLinkDialog.this.urlText.getText().trim().length() > 0);
                }
            }
        });
        super.getShell().setText(RichTextResources.getString("RichText.addLinkDialog.title"));
        return this.composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        String url = this.urlText.getText();
        if (url != null && url.length() > 0) {
            this.link.setURL(url);
        }
        super.okPressed();
    }

    public Link getLink() {
        return this.link;
    }
}

