/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.richtext.RichTextResources;

public class BlockTag {
    private static final String NAME_PARAGRAPH = RichTextResources.getString("RichText.blockTag.paragraph");
    private static final String NAME_HEADING_1 = RichTextResources.getString("RichText.blockTag.heading1");
    private static final String NAME_HEADING_2 = RichTextResources.getString("RichText.blockTag.heading2");
    private static final String NAME_HEADING_3 = RichTextResources.getString("RichText.blockTag.heading3");
    private static final String NAME_HEADING_4 = RichTextResources.getString("RichText.blockTag.heading4");
    private static final String NAME_HEADING_5 = RichTextResources.getString("RichText.blockTag.heading5");
    private static final String NAME_HEADING_6 = RichTextResources.getString("RichText.blockTag.heading6");
    private static final String NAME_ADDRESS = RichTextResources.getString("RichText.blockTag.address");
    private static final String NAME_PREFORMATTED_TEXT = RichTextResources.getString("RichText.blockTag.preformattedText");
    private static final String VALUE_PARAGRAPH = "<p>";
    private static final String VALUE_HEADING_1 = "<h1>";
    private static final String VALUE_HEADING_2 = "<h2>";
    private static final String VALUE_HEADING_3 = "<h3>";
    private static final String VALUE_HEADING_4 = "<h4>";
    private static final String VALUE_HEADING_5 = "<h5>";
    private static final String VALUE_HEADING_6 = "<h6>";
    private static final String VALUE_ADDRESS = "<address>";
    private static final String VALUE_PREFORMATTED_TEXT = "<pre>";
    public static final BlockTag PARAGRAPH = new BlockTag(NAME_PARAGRAPH, "<p>");
    public static final BlockTag HEADING_1 = new BlockTag(NAME_HEADING_1, "<h1>");
    public static final BlockTag HEADING_2 = new BlockTag(NAME_HEADING_2, "<h2>");
    public static final BlockTag HEADING_3 = new BlockTag(NAME_HEADING_3, "<h3>");
    public static final BlockTag HEADING_4 = new BlockTag(NAME_HEADING_4, "<h4>");
    public static final BlockTag HEADING_5 = new BlockTag(NAME_HEADING_5, "<h5>");
    public static final BlockTag HEADING_6 = new BlockTag(NAME_HEADING_6, "<h6>");
    public static final BlockTag ADDRESS = new BlockTag(NAME_ADDRESS, "<address>");
    public static final BlockTag PREFORMATTED_TEXT = new BlockTag(NAME_PREFORMATTED_TEXT, "<pre>");
    private static final List BLOCK_TAGS = new ArrayList();
    private String name;
    private String value;

    static {
        BLOCK_TAGS.add(PARAGRAPH);
        BLOCK_TAGS.add(HEADING_1);
        BLOCK_TAGS.add(HEADING_2);
        BLOCK_TAGS.add(HEADING_3);
        BLOCK_TAGS.add(HEADING_4);
        BLOCK_TAGS.add(HEADING_5);
        BLOCK_TAGS.add(HEADING_6);
        BLOCK_TAGS.add(ADDRESS);
        BLOCK_TAGS.add(PREFORMATTED_TEXT);
    }

    public BlockTag(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static BlockTag getBlockTag(int index) {
        BlockTag result = (BlockTag)BLOCK_TAGS.get(index);
        if (result != null) {
            return result;
        }
        return PARAGRAPH;
    }
}

