/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;

public class SuccesorTaskFinder {
    private AbstractTask currentTask;
    ICompositeCheatSheetTask bestLaterTask;
    ICompositeCheatSheetTask bestEarlierTask;
    private boolean seenThisTask;

    public SuccesorTaskFinder(ICompositeCheatSheetTask task) {
        this.currentTask = (AbstractTask)task;
    }

    public ICompositeCheatSheetTask[] getRecommendedSuccessors() {
        List runnableChoices;
        if ("choice".equals(this.currentTask.getKind()) && (runnableChoices = this.findRunnableChoices()).size() != 0) {
            return runnableChoices.toArray(new ICompositeCheatSheetTask[runnableChoices.size()]);
        }
        return this.getBestSuccessor();
    }

    private List findRunnableChoices() {
        ArrayList<ICompositeCheatSheetTask> result = new ArrayList<ICompositeCheatSheetTask>();
        if (this.isStartable(this.currentTask)) {
            ICompositeCheatSheetTask[] subtasks = this.currentTask.getSubtasks();
            int i = 0;
            while (i < subtasks.length) {
                if (this.isStartable(subtasks[i])) {
                    result.add(subtasks[i]);
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isStartable(ICompositeCheatSheetTask task) {
        int state = task.getState();
        return state != 3 && state != 2 && task.requiredTasksCompleted();
    }

    private ICompositeCheatSheetTask[] getBestSuccessor() {
        this.bestLaterTask = null;
        this.bestEarlierTask = null;
        this.seenThisTask = false;
        this.searchRunnableChildren(this.currentTask.getCompositeCheatSheet().getRootTask());
        if (this.bestLaterTask != null) {
            return new ICompositeCheatSheetTask[]{this.bestLaterTask};
        }
        if (this.bestEarlierTask != null) {
            return new ICompositeCheatSheetTask[]{this.bestEarlierTask};
        }
        return new ICompositeCheatSheetTask[0];
    }

    private void searchRunnableChildren(ICompositeCheatSheetTask task) {
        if (task == this.currentTask) {
            this.seenThisTask = true;
        }
        if (task.getState() == 3 || task.getState() == 2 || this.bestLaterTask != null) {
            return;
        }
        if (this.isStartable(task) && task != this.currentTask) {
            if (this.seenThisTask) {
                if (this.bestLaterTask == null) {
                    this.bestLaterTask = task;
                }
            } else if (this.bestEarlierTask == null) {
                this.bestEarlierTask = task;
            }
        }
        ICompositeCheatSheetTask[] subtasks = task.getSubtasks();
        int i = 0;
        while (i < subtasks.length) {
            this.searchRunnableChildren(subtasks[i]);
            ++i;
        }
    }
}

