/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.OS;

class StyledTextDragAndDropEffect
extends DragAndDropEffect {
    StyledText text;

    StyledTextDragAndDropEffect(StyledText control) {
        this.text = control;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        block4: {
            if ((effect & 1) != 0) {
                Point pt = this.text.getDisplay().map(null, this.text, x, y);
                int oldOffset = this.text.getCaretOffset();
                try {
                    this.text.setFocus();
                    int offset = this.text.getOffsetAtLocation(pt);
                    if (offset != oldOffset) {
                        OS.ImageList_DragShowNolock(false);
                        this.text.setCaretOffset(offset);
                        OS.ImageList_DragShowNolock(true);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    int maxOffset = this.text.getCharCount();
                    Point maxLocation = this.text.getLocationAtOffset(maxOffset);
                    int offset = -1;
                    offset = pt.y >= maxLocation.y ? (pt.x >= maxLocation.x ? maxOffset : this.text.getOffsetAtLocation(new Point(pt.x, maxLocation.y))) : maxOffset;
                    if (offset == -1 || offset == oldOffset) break block4;
                    OS.ImageList_DragShowNolock(false);
                    this.text.setCaretOffset(offset);
                    OS.ImageList_DragShowNolock(true);
                }
            }
        }
    }
}

