/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.BLENDFUNCTION;
import org.eclipse.swt.internal.win32.EXTLOGPEN;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int hDC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, hDC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Device device = this.data.device;
        int hDC = device.internal_new_GC(null);
        Rectangle rect = image.getBounds();
        int memHdc = OS.CreateCompatibleDC(hDC);
        int hOldBitmap = OS.SelectObject(memHdc, image.handle);
        OS.BitBlt(memHdc, 0, 0, rect.width, rect.height, this.handle, x, y, 0xCC0020);
        OS.SelectObject(memHdc, hOldBitmap);
        OS.DeleteDC(memHdc);
        device.internal_dispose_GC(hDC, null);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        int hwnd;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((hwnd = this.data.hwnd) == 0) {
            OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
        } else {
            RECT lprcClip = null;
            int hrgn = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, hrgn) == 1) {
                lprcClip = new RECT();
                OS.GetRgnBox(hrgn, lprcClip);
            }
            OS.DeleteObject(hrgn);
            RECT lprcScroll = new RECT();
            OS.SetRect(lprcScroll, srcX, srcY, srcX + width, srcY + height);
            int flags = paint ? 6 : 0;
            int res = OS.ScrollWindowEx(hwnd, destX - srcX, destY - srcY, lprcScroll, lprcClip, 0, null, flags);
            if (res == 0 && OS.IsWinCE) {
                OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
                if (paint) {
                    boolean disjoint;
                    int deltaX = destX - srcX;
                    int deltaY = destY - srcY;
                    boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                    if (disjoint) {
                        OS.InvalidateRect(hwnd, lprcScroll, true);
                    } else {
                        if (deltaX != 0) {
                            int newX = destX - deltaX;
                            if (deltaX < 0) {
                                newX = destX + width;
                            }
                            OS.SetRect(lprcScroll, newX, srcY, newX + Math.abs(deltaX), srcY + height);
                            OS.InvalidateRect(hwnd, lprcScroll, true);
                        }
                        if (deltaY != 0) {
                            int newY = destY - deltaY;
                            if (deltaY < 0) {
                                newY = destY + height;
                            }
                            OS.SetRect(lprcScroll, srcX, newY, srcX + width, newY + Math.abs(deltaY));
                            OS.InvalidateRect(hwnd, lprcScroll, true);
                        }
                    }
                }
            }
        }
    }

    int createGdipBrush() {
        int brush;
        int colorRef = OS.GetBkColor(this.handle);
        int rgb = colorRef >> 16 & 0xFF | colorRef & 0xFF00 | (colorRef & 0xFF) << 16;
        int color = Gdip.Color_new(this.data.alpha << 24 | rgb);
        if (color == 0) {
            SWT.error(2);
        }
        if ((brush = Gdip.SolidBrush_new(color)) == 0) {
            SWT.error(2);
        }
        Gdip.Color_delete(color);
        return brush;
    }

    int createGdipFont() {
        return GC.createGdipFont(this.handle, OS.GetCurrentObject(this.handle, 6));
    }

    static int createGdipFont(int hDC, int hFont) {
        int font = Gdip.Font_new(hDC, hFont);
        if (font == 0) {
            SWT.error(2);
        }
        if (!Gdip.Font_IsAvailable(font)) {
            char[] chars;
            Gdip.Font_delete(font);
            LOGFONT logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.GetObject(hFont, LOGFONT.sizeof, logFont);
            int size = Math.abs(logFont.lfHeight);
            int style = 0;
            if (logFont.lfWeight == 700) {
                style |= 1;
            }
            if (logFont.lfItalic != 0) {
                style |= 2;
            }
            if (OS.IsUnicode) {
                chars = logFont.lfFaceName;
            } else {
                chars = new char[32];
                byte[] bytes = ((LOGFONTA)logFont).lfFaceName;
                OS.MultiByteToWideChar(0, 1, bytes, bytes.length, chars, chars.length);
            }
            int index = 0;
            while (index < chars.length) {
                if (chars[index] == '\u0000') break;
                ++index;
            }
            String name = new String(chars, 0, index);
            if (Compatibility.equalsIgnoreCase(name, "Courier")) {
                name = "Courier New";
            }
            char[] buffer = new char[name.length() + 1];
            name.getChars(0, name.length(), buffer, 0);
            font = Gdip.Font_new(buffer, size, style, 2, 0);
        }
        if (font == 0) {
            SWT.error(2);
        }
        return font;
    }

    int createGdipPen() {
        int style;
        int width;
        int colorRef;
        Object logPen;
        int hPen = OS.GetCurrentObject(this.handle, 1);
        int size = OS.GetObject(hPen, 0, null);
        if (size == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            colorRef = ((LOGPEN)logPen).lopnColor;
            width = ((LOGPEN)logPen).x;
            style = ((LOGPEN)logPen).lopnStyle;
            if (width <= 1) {
                style |= 0x2200;
            }
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            colorRef = ((EXTLOGPEN)logPen).elpColor;
            width = ((EXTLOGPEN)logPen).elpWidth;
            style = ((EXTLOGPEN)logPen).elpPenStyle;
        }
        int rgb = colorRef >> 16 & 0xFF | colorRef & 0xFF00 | (colorRef & 0xFF) << 16;
        int color = Gdip.Color_new(this.data.alpha << 24 | rgb);
        int pen = Gdip.Pen_new(color, Math.max(1, width));
        Gdip.Color_delete(color);
        if (this.data.foregroundPattern != null) {
            Gdip.Pen_SetBrush(pen, this.data.foregroundPattern.handle);
        }
        float[] dashes = null;
        int dashStyle = 0;
        switch (style & 0xF) {
            case 0: {
                break;
            }
            case 2: {
                dashStyle = 2;
                if (width != 0) break;
                dashes = LINE_DOT_ZERO;
                break;
            }
            case 1: {
                dashStyle = 1;
                if (width != 0) break;
                dashes = LINE_DASH_ZERO;
                break;
            }
            case 3: {
                dashStyle = 3;
                if (width != 0) break;
                dashes = LINE_DASHDOT_ZERO;
                break;
            }
            case 4: {
                dashStyle = 4;
                if (width != 0) break;
                dashes = LINE_DASHDOTDOT_ZERO;
                break;
            }
            case 7: {
                if (this.data.dashes == null) break;
                dashes = new float[this.data.dashes.length * 2];
                int i = 0;
                while (i < this.data.dashes.length) {
                    float dash;
                    dashes[i] = dash = (float)this.data.dashes[i] / (float)Math.max(1, width);
                    dashes[i + this.data.dashes.length] = dash;
                    ++i;
                }
                break;
            }
        }
        if (dashes != null) {
            Gdip.Pen_SetDashPattern(pen, dashes, dashes.length);
            Gdip.Pen_SetDashStyle(pen, 5);
        } else {
            Gdip.Pen_SetDashStyle(pen, dashStyle);
        }
        int joinStyle = 0;
        switch (style & 0xF000) {
            case 8192: {
                joinStyle = 0;
                break;
            }
            case 4096: {
                joinStyle = 1;
                break;
            }
            case 0: {
                joinStyle = 2;
            }
        }
        Gdip.Pen_SetLineJoin(pen, joinStyle);
        int dashCap = 0;
        int capStyle = 0;
        switch (style & 0xF00) {
            case 512: {
                capStyle = 0;
                break;
            }
            case 0: {
                capStyle = 2;
                dashCap = 2;
                break;
            }
            case 256: {
                capStyle = 1;
            }
        }
        Gdip.Pen_SetLineCap(pen, capStyle, capStyle, dashCap);
        return pen;
    }

    void destroyGdipBrush(int brush) {
        int type = Gdip.Brush_GetType(brush);
        switch (type) {
            case 0: {
                Gdip.SolidBrush_delete(brush);
                break;
            }
            case 1: {
                Gdip.HatchBrush_delete(brush);
                break;
            }
            case 4: {
                Gdip.LinearGradientBrush_delete(brush);
                break;
            }
            case 2: {
                Gdip.TextureBrush_delete(brush);
            }
        }
    }

    public void dispose() {
        Image image;
        int hNullBitmap;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_delete(this.data.gdipGraphics);
        }
        if (this.data.gdipPen != 0) {
            Gdip.Pen_delete(this.data.gdipPen);
        }
        if (this.data.gdipBrush != 0) {
            this.destroyGdipBrush(this.data.gdipBrush);
        }
        this.data.gdipGraphics = 0;
        this.data.gdipPen = 0;
        this.data.gdipBrush = 0;
        if (this.data.hPen != 0) {
            int nullPen = OS.GetStockObject(8);
            OS.SelectObject(this.handle, nullPen);
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            int nullBrush = OS.GetStockObject(5);
            OS.SelectObject(this.handle, nullBrush);
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
        if ((hNullBitmap = this.data.hNullBitmap) != 0) {
            OS.SelectObject(this.handle, hNullBitmap);
            this.data.hNullBitmap = 0;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        Device device = this.data.device;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.ps = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0) {
            this.initGdip(true, false);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            }
            if (width == height) {
                Gdip.Graphics_DrawArc(gdipGraphics, this.data.gdipPen, x, y, width, height, -startAngle, -arcAngle);
            } else {
                int matrix;
                int path = Gdip.GraphicsPath_new(0);
                if (path == 0) {
                    SWT.error(2);
                }
                if ((matrix = Gdip.Matrix_new(width, 0.0f, 0.0f, height, x, y)) == 0) {
                    SWT.error(2);
                }
                Gdip.GraphicsPath_AddArc(path, 0.0f, 0.0f, 1.0f, 1.0f, -startAngle, -arcAngle);
                Gdip.GraphicsPath_Transform(path, matrix);
                Gdip.Graphics_DrawPath(gdipGraphics, this.data.gdipPen, path);
                Gdip.Matrix_delete(matrix);
                Gdip.GraphicsPath_delete(path);
            }
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            }
            return;
        }
        if (OS.IsWinCE) {
            if (arcAngle < 0) {
                startAngle += arcAngle;
                arcAngle = -arcAngle;
            }
            if (arcAngle > 360) {
                arcAngle = 360;
            }
            int[] points = new int[(arcAngle + 1) * 2];
            int cteX = 2 * x + width;
            int cteY = 2 * y + height;
            int index = 0;
            int i = 0;
            while (i <= arcAngle) {
                points[index++] = Compatibility.cos(startAngle + i, width) + cteX >> 1;
                points[index++] = cteY - Compatibility.sin(startAngle + i, height) >> 1;
                ++i;
            }
            OS.Polyline(this.handle, points, points.length / 2);
        } else {
            int y1;
            int y2;
            int x1;
            int x2;
            if (arcAngle >= 360 || arcAngle <= -360) {
                x1 = x2 = x + width;
                y1 = y2 = y + height / 2;
            } else {
                boolean isNegative = arcAngle < 0;
                arcAngle += startAngle;
                if (isNegative) {
                    int tmp = startAngle;
                    startAngle = arcAngle;
                    arcAngle = tmp;
                }
                x1 = Compatibility.cos(startAngle, width) + x + width / 2;
                y1 = -1 * Compatibility.sin(startAngle, height) + y + height / 2;
                x2 = Compatibility.cos(arcAngle, width) + x + width / 2;
                y2 = -1 * Compatibility.sin(arcAngle, height) + y + height / 2;
            }
            int nullBrush = OS.GetStockObject(5);
            int oldBrush = OS.SelectObject(this.handle, nullBrush);
            OS.Arc(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
            OS.SelectObject(this.handle, oldBrush);
        }
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        OS.DrawFocusRect(this.handle, rect);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        if (this.data.gdipGraphics != 0) {
            int[] gdipImage = srcImage.createGdipImage();
            int img = gdipImage[0];
            int imgWidth = Gdip.Image_GetWidth(img);
            int imgHeight = Gdip.Image_GetHeight(img);
            if (simple) {
                srcWidth = destWidth = imgWidth;
                srcHeight = destHeight = imgHeight;
            } else {
                if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                    SWT.error(5);
                }
                simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            }
            Rect rect = new Rect();
            rect.X = destX;
            rect.Y = destY;
            rect.Width = destWidth;
            rect.Height = destHeight;
            int attrib = Gdip.ImageAttributes_new();
            Gdip.ImageAttributes_SetWrapMode(attrib, 3);
            if (this.data.alpha != 255) {
                float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (float)this.data.alpha / 255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                Gdip.ImageAttributes_SetColorMatrix(attrib, matrix, 0, 1);
            }
            Gdip.Graphics_DrawImage(this.data.gdipGraphics, img, rect, srcX, srcY, srcWidth, srcHeight, 2, attrib, 0, 0);
            Gdip.ImageAttributes_delete(attrib);
            Gdip.Bitmap_delete(img);
            if (gdipImage[1] != 0) {
                int hHeap = OS.GetProcessHeap();
                OS.HeapFree(hHeap, 0, gdipImage[1]);
            }
            return;
        }
        switch (srcImage.type) {
            case 0: {
                this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            case 1: {
                this.drawIcon(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            default: {
                SWT.error(42);
            }
        }
    }

    void drawIcon(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        boolean failed;
        int technology = OS.GetDeviceCaps(this.handle, 2);
        boolean drawIcon = true;
        int flags = 3;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            flags |= 0x10;
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            boolean bl = drawIcon = (OS.GetLayout(this.handle) & 1) == 0;
        }
        if (simple && technology != 2 && drawIcon) {
            OS.DrawIconEx(this.handle, destX, destY, srcImage.handle, 0, 0, 0, 0, flags);
            return;
        }
        ICONINFO srcIconInfo = new ICONINFO();
        if (OS.IsWinCE) {
            Image.GetIconInfo(srcImage, srcIconInfo);
        } else {
            OS.GetIconInfo(srcImage.handle, srcIconInfo);
        }
        int hBitmap = srcIconInfo.hbmColor;
        if (hBitmap == 0) {
            hBitmap = srcIconInfo.hbmMask;
        }
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, 24, bm);
        int iconWidth = bm.bmWidth;
        int iconHeight = bm.bmHeight;
        if (hBitmap == srcIconInfo.hbmMask) {
            iconHeight /= 2;
        }
        if (simple) {
            srcWidth = destWidth = iconWidth;
            srcHeight = destHeight = iconHeight;
        }
        boolean bl = failed = srcX + srcWidth > iconWidth || srcY + srcHeight > iconHeight;
        if (!failed) {
            boolean bl2 = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && srcHeight == destHeight && srcWidth == iconWidth && srcHeight == iconHeight;
            if (!drawIcon) {
                this.drawBitmapMask(srcImage, srcIconInfo.hbmColor, srcIconInfo.hbmMask, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, iconWidth, iconHeight, false);
            } else if (simple && technology != 2) {
                OS.DrawIconEx(this.handle, destX, destY, srcImage.handle, 0, 0, 0, 0, flags);
            } else {
                boolean stretch;
                ICONINFO newIconInfo = new ICONINFO();
                newIconInfo.fIcon = true;
                int srcHdc = OS.CreateCompatibleDC(this.handle);
                int dstHdc = OS.CreateCompatibleDC(this.handle);
                int srcColorY = srcY;
                int srcColor = srcIconInfo.hbmColor;
                if (srcColor == 0) {
                    srcColor = srcIconInfo.hbmMask;
                    srcColorY += iconHeight;
                }
                int oldSrcBitmap = OS.SelectObject(srcHdc, srcColor);
                newIconInfo.hbmColor = OS.CreateCompatibleBitmap(srcHdc, destWidth, destHeight);
                if (newIconInfo.hbmColor == 0) {
                    SWT.error(2);
                }
                int oldDestBitmap = OS.SelectObject(dstHdc, newIconInfo.hbmColor);
                boolean bl3 = stretch = !simple && (srcWidth != destWidth || srcHeight != destHeight);
                if (stretch) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(dstHdc, 3);
                    }
                    OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0xCC0020);
                } else {
                    OS.BitBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, 0xCC0020);
                }
                OS.SelectObject(srcHdc, srcIconInfo.hbmMask);
                newIconInfo.hbmMask = OS.CreateBitmap(destWidth, destHeight, 1, 1, null);
                if (newIconInfo.hbmMask == 0) {
                    SWT.error(2);
                }
                OS.SelectObject(dstHdc, newIconInfo.hbmMask);
                if (stretch) {
                    OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0xCC0020);
                } else {
                    OS.BitBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0xCC0020);
                }
                if (technology == 2) {
                    OS.SelectObject(srcHdc, newIconInfo.hbmColor);
                    OS.SelectObject(dstHdc, newIconInfo.hbmMask);
                    this.drawBitmapTransparentByClipping(srcHdc, dstHdc, 0, 0, destWidth, destHeight, destX, destY, destWidth, destHeight, true, destWidth, destHeight);
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(dstHdc, oldDestBitmap);
                } else {
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(dstHdc, oldDestBitmap);
                    int hIcon = OS.CreateIconIndirect(newIconInfo);
                    if (hIcon == 0) {
                        SWT.error(2);
                    }
                    OS.DrawIconEx(this.handle, destX, destY, hIcon, destWidth, destHeight, 0, 0, flags);
                    OS.DestroyIcon(hIcon);
                }
                OS.DeleteObject(newIconInfo.hbmMask);
                OS.DeleteObject(newIconInfo.hbmColor);
                OS.DeleteDC(dstHdc);
                OS.DeleteDC(srcHdc);
            }
        }
        OS.DeleteObject(srcIconInfo.hbmMask);
        if (srcIconInfo.hbmColor != 0) {
            OS.DeleteObject(srcIconInfo.hbmColor);
        }
        if (failed) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        BITMAP bm = new BITMAP();
        OS.GetObject(srcImage.handle, 24, bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
        }
        boolean mustRestore = false;
        GC memGC = srcImage.memGC;
        if (memGC != null && !memGC.isDisposed()) {
            memGC.flush();
            mustRestore = true;
            GCData data = memGC.data;
            if (data.hNullBitmap != 0) {
                OS.SelectObject(memGC.handle, data.hNullBitmap);
                data.hNullBitmap = 0;
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawBitmapAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1) {
            this.drawBitmapTransparent(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        }
        if (mustRestore) {
            int hOldBitmap;
            memGC.data.hNullBitmap = hOldBitmap = OS.SelectObject(memGC.handle, srcImage.handle);
        }
    }

    void drawBitmapAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        boolean hasAlphaChannel;
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
            return;
        }
        if (OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            BLENDFUNCTION blend = new BLENDFUNCTION();
            blend.BlendOp = 0;
            int srcHdc = OS.CreateCompatibleDC(this.handle);
            int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
            if (srcImage.alpha != -1) {
                blend.SourceConstantAlpha = (byte)srcImage.alpha;
                OS.AlphaBlend(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, blend);
            } else {
                int memDib = Image.createDIB(srcWidth, srcHeight, 32);
                if (memDib == 0) {
                    SWT.error(2);
                }
                int memHdc = OS.CreateCompatibleDC(this.handle);
                int oldMemBitmap = OS.SelectObject(memHdc, memDib);
                BITMAP dibBM = new BITMAP();
                OS.GetObject(memDib, 24, dibBM);
                OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc, srcX, srcY, 0xCC0020);
                byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
                OS.MoveMemory(srcData, dibBM.bmBits, srcData.length);
                int apinc = imgWidth - srcWidth;
                int ap = srcY * imgWidth + srcX;
                int sp = 0;
                byte[] alphaData = srcImage.alphaData;
                int y = 0;
                while (y < srcHeight) {
                    int x = 0;
                    while (x < srcWidth) {
                        int alpha = alphaData[ap++] & 0xFF;
                        int r = (srcData[sp + 0] & 0xFF) * alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (srcData[sp + 1] & 0xFF) * alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (srcData[sp + 2] & 0xFF) * alpha + 128;
                        b = b + (b >> 8) >> 8;
                        srcData[sp + 0] = (byte)r;
                        srcData[sp + 1] = (byte)g;
                        srcData[sp + 2] = (byte)b;
                        srcData[sp + 3] = (byte)alpha;
                        sp += 4;
                        ++x;
                    }
                    ap += apinc;
                    ++y;
                }
                OS.MoveMemory(dibBM.bmBits, srcData, srcData.length);
                blend.SourceConstantAlpha = (byte)-1;
                blend.AlphaFormat = 1;
                OS.AlphaBlend(this.handle, destX, destY, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, blend);
                OS.SelectObject(memHdc, oldMemBitmap);
                OS.DeleteDC(memHdc);
                OS.DeleteObject(memDib);
            }
            OS.SelectObject(srcHdc, oldSrcBitmap);
            OS.DeleteDC(srcHdc);
            return;
        }
        Rectangle rect = this.getClipping();
        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
            return;
        }
        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
        destX = rect.x;
        destY = rect.y;
        destWidth = rect.width;
        destHeight = rect.height;
        srcX = sx1;
        srcY = sy1;
        srcWidth = Math.max(1, sx2 - sx1);
        srcHeight = Math.max(1, sy2 - sy1);
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
        int memHdc = OS.CreateCompatibleDC(this.handle);
        int memDib = Image.createDIB(Math.max(srcWidth, destWidth), Math.max(srcHeight, destHeight), 32);
        if (memDib == 0) {
            SWT.error(2);
        }
        int oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, 24, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
        byte[] destData = new byte[sizeInBytes];
        OS.MoveMemory(destData, dibBM.bmBits, sizeInBytes);
        OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc, srcX, srcY, 0xCC0020);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int alpha = srcImage.alpha;
        boolean bl = hasAlphaChannel = srcImage.alpha == -1;
        if (hasAlphaChannel) {
            int apinc = imgWidth - srcWidth;
            int spinc = dibBM.bmWidthBytes - srcWidth * 4;
            int ap = srcY * imgWidth + srcX;
            int sp = 3;
            byte[] alphaData = srcImage.alphaData;
            int y = 0;
            while (y < srcHeight) {
                int x = 0;
                while (x < srcWidth) {
                    srcData[sp] = alphaData[ap++];
                    sp += 4;
                    ++x;
                }
                ap += apinc;
                sp += spinc;
                ++y;
            }
        }
        OS.MoveMemory(dibBM.bmBits, srcData, sizeInBytes);
        if (OS.IsWinCE && (destWidth > srcWidth || destHeight > srcHeight) || !OS.IsWinNT && !OS.IsWinCE) {
            int tempHdc = OS.CreateCompatibleDC(this.handle);
            int tempDib = Image.createDIB(destWidth, destHeight, 32);
            if (tempDib == 0) {
                SWT.error(2);
            }
            int oldTempBitmap = OS.SelectObject(tempHdc, tempDib);
            if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(memHdc, 3);
                }
                OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
            } else {
                OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
            }
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteObject(tempDib);
            OS.DeleteDC(tempHdc);
        } else if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(memHdc, 3);
            }
            OS.StretchBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
        } else {
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        }
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int dpinc = dibBM.bmWidthBytes - destWidth * 4;
        int dp = 0;
        int y = 0;
        while (y < destHeight) {
            int x = 0;
            while (x < destWidth) {
                if (hasAlphaChannel) {
                    alpha = srcData[dp + 3] & 0xFF;
                }
                int n = dp;
                destData[n] = (byte)(destData[n] + ((srcData[dp] & 0xFF) - (destData[dp] & 0xFF)) * alpha / 255);
                int n2 = dp + 1;
                destData[n2] = (byte)(destData[n2] + ((srcData[dp + 1] & 0xFF) - (destData[dp + 1] & 0xFF)) * alpha / 255);
                int n3 = dp + 2;
                destData[n3] = (byte)(destData[n3] + ((srcData[dp + 2] & 0xFF) - (destData[dp + 2] & 0xFF)) * alpha / 255);
                dp += 4;
                ++x;
            }
            dp += dpinc;
            ++y;
        }
        OS.MoveMemory(dibBM.bmBits, destData, sizeInBytes);
        OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        OS.SelectObject(memHdc, oldMemBitmap);
        OS.DeleteDC(memHdc);
        OS.DeleteObject(memDib);
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    void drawBitmapTransparentByClipping(int srcHdc, int maskHdc, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int dwRop;
        int rgn = OS.CreateRectRgn(0, 0, 0, 0);
        int y = 0;
        while (y < imgHeight) {
            int x = 0;
            while (x < imgWidth) {
                if (OS.GetPixel(maskHdc, x, y) == 0) {
                    int tempRgn = OS.CreateRectRgn(x, y, x + 1, y + 1);
                    OS.CombineRgn(rgn, rgn, tempRgn, 2);
                    OS.DeleteObject(tempRgn);
                }
                ++x;
            }
            ++y;
        }
        if (destWidth != srcWidth || destHeight != srcHeight) {
            int nBytes = OS.GetRegionData(rgn, 0, null);
            int[] lpRgnData = new int[nBytes / 4];
            OS.GetRegionData(rgn, nBytes, lpRgnData);
            float[] lpXform = new float[]{(float)destWidth / (float)srcWidth, 0.0f, 0.0f, (float)destHeight / (float)srcHeight, 0.0f, 0.0f};
            int tmpRgn = OS.ExtCreateRegion(lpXform, nBytes, lpRgnData);
            OS.DeleteObject(rgn);
            rgn = tmpRgn;
        }
        OS.OffsetRgn(rgn, destX, destY);
        int clip = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, clip);
        if (result == 1) {
            OS.CombineRgn(rgn, rgn, clip, 1);
        }
        OS.SelectClipRgn(this.handle, rgn);
        int rop2 = 0;
        if (!OS.IsWinCE) {
            rop2 = OS.GetROP2(this.handle);
        } else {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        }
        int n = dwRop = rop2 == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = 0;
            if (!OS.IsWinCE) {
                mode = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, mode);
            }
        } else {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, dwRop);
        }
        OS.SelectClipRgn(this.handle, result == 1 ? clip : 0);
        OS.DeleteObject(clip);
        OS.DeleteObject(rgn);
    }

    void drawBitmapMask(Image srcImage, int srcColor, int srcMask, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, boolean offscreen) {
        int srcColorY = srcY;
        if (srcColor == 0) {
            srcColor = srcMask;
            srcColorY += imgHeight;
        }
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcColor);
        int destHdc = this.handle;
        int x = destX;
        int y = destY;
        int tempHdc = 0;
        int tempBitmap = 0;
        int oldTempBitmap = 0;
        int oldBkColor = 0;
        int oldTextColor = 0;
        if (offscreen) {
            tempHdc = OS.CreateCompatibleDC(this.handle);
            tempBitmap = OS.CreateCompatibleBitmap(this.handle, destWidth, destHeight);
            oldTempBitmap = OS.SelectObject(tempHdc, tempBitmap);
            OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
            destHdc = tempHdc;
            y = 0;
            x = 0;
        } else {
            oldBkColor = OS.SetBkColor(this.handle, 0xFFFFFF);
            oldTextColor = OS.SetTextColor(this.handle, 0);
        }
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = 0;
            if (!OS.IsWinCE) {
                mode = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0x660046);
            OS.SelectObject(srcHdc, srcMask);
            OS.StretchBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 8913094);
            OS.SelectObject(srcHdc, srcColor);
            OS.StretchBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0x660046);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, mode);
            }
        } else {
            OS.BitBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, 0x660046);
            OS.SetTextColor(destHdc, 0);
            OS.SelectObject(srcHdc, srcMask);
            OS.BitBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcY, 8913094);
            OS.SelectObject(srcHdc, srcColor);
            OS.BitBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, 0x660046);
        }
        if (offscreen) {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteDC(tempHdc);
            OS.DeleteObject(tempBitmap);
        } else {
            OS.SetBkColor(this.handle, oldBkColor);
            OS.SetTextColor(this.handle, oldTextColor);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    void drawBitmapTransparent(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        int transBlue = 0;
        int transGreen = 0;
        int transRed = 0;
        boolean isDib = bm.bmBits != 0;
        int hBitmap = srcImage.handle;
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        byte[] originalColors = null;
        if (bm.bmBitsPixel <= 8) {
            if (isDib) {
                if (OS.IsWinCE) {
                    byte[] pBits = new byte[1];
                    OS.MoveMemory(pBits, bm.bmBits, 1);
                    byte oldValue = pBits[0];
                    int mask = 255 << 8 - bm.bmBitsPixel & 0xFF;
                    pBits[0] = (byte)(srcImage.transparentPixel << 8 - bm.bmBitsPixel | pBits[0] & ~mask);
                    OS.MoveMemory(bm.bmBits, pBits, 1);
                    int color = OS.GetPixel(srcHdc, 0, 0);
                    pBits[0] = oldValue;
                    OS.MoveMemory(bm.bmBits, pBits, 1);
                    transBlue = (color & 0xFF0000) >> 16;
                    transGreen = (color & 0xFF00) >> 8;
                    transRed = color & 0xFF;
                } else {
                    int maxColors = 1 << bm.bmBitsPixel;
                    byte[] oldColors = new byte[maxColors * 4];
                    OS.GetDIBColorTable(srcHdc, 0, maxColors, oldColors);
                    int offset = srcImage.transparentPixel * 4;
                    boolean fixPalette = false;
                    int i = 0;
                    while (i < oldColors.length) {
                        if (i != offset && oldColors[offset] == oldColors[i] && oldColors[offset + 1] == oldColors[i + 1] && oldColors[offset + 2] == oldColors[i + 2]) {
                            fixPalette = true;
                            break;
                        }
                        i += 4;
                    }
                    if (fixPalette) {
                        byte[] newColors = new byte[oldColors.length];
                        transBlue = 255;
                        transGreen = 255;
                        transRed = 255;
                        newColors[offset] = (byte)transBlue;
                        newColors[offset + 1] = (byte)transGreen;
                        newColors[offset + 2] = (byte)transRed;
                        OS.SetDIBColorTable(srcHdc, 0, maxColors, newColors);
                        originalColors = oldColors;
                    } else {
                        transBlue = oldColors[offset] & 0xFF;
                        transGreen = oldColors[offset + 1] & 0xFF;
                        transRed = oldColors[offset + 2] & 0xFF;
                    }
                }
            } else {
                int numColors = 1 << bm.bmBitsPixel;
                BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                bmiHeader.biSize = 40;
                bmiHeader.biPlanes = bm.bmPlanes;
                bmiHeader.biBitCount = bm.bmBitsPixel;
                byte[] bmi = new byte[40 + numColors * 4];
                OS.MoveMemory(bmi, bmiHeader, 40);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(srcHdc, srcImage.handle, 0, 0, 0, bmi, 0);
                int offset = 40 + 4 * srcImage.transparentPixel;
                transRed = bmi[offset + 2] & 0xFF;
                transGreen = bmi[offset + 1] & 0xFF;
                transBlue = bmi[offset] & 0xFF;
            }
        } else {
            int pixel = srcImage.transparentPixel;
            switch (bm.bmBitsPixel) {
                case 16: {
                    transBlue = (pixel & 0x1F) << 3;
                    transGreen = (pixel & 0x3E0) >> 2;
                    transRed = (pixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    transBlue = (pixel & 0xFF0000) >> 16;
                    transGreen = (pixel & 0xFF00) >> 8;
                    transRed = pixel & 0xFF;
                    break;
                }
                case 32: {
                    transBlue = (pixel & 0xFF000000) >>> 24;
                    transGreen = (pixel & 0xFF0000) >> 16;
                    transRed = (pixel & 0xFF00) >> 8;
                }
            }
        }
        int transparentColor = transBlue << 16 | transGreen << 8 | transRed;
        if (OS.IsWinCE) {
            OS.TransparentImage(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, transparentColor);
        } else if (originalColors == null && OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            int mode = OS.SetStretchBltMode(this.handle, 3);
            OS.TransparentBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, transparentColor);
            OS.SetStretchBltMode(this.handle, mode);
        } else {
            int maskHdc = OS.CreateCompatibleDC(this.handle);
            int maskBitmap = OS.CreateBitmap(imgWidth, imgHeight, 1, 1, null);
            int oldMaskBitmap = OS.SelectObject(maskHdc, maskBitmap);
            OS.SetBkColor(srcHdc, transparentColor);
            OS.BitBlt(maskHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
            if (originalColors != null) {
                OS.SetDIBColorTable(srcHdc, 0, 1 << bm.bmBitsPixel, originalColors);
            }
            if (OS.GetDeviceCaps(this.handle, 2) == 2) {
                this.drawBitmapTransparentByClipping(srcHdc, maskHdc, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            } else {
                int tempHdc = OS.CreateCompatibleDC(this.handle);
                int tempBitmap = OS.CreateCompatibleBitmap(this.handle, destWidth, destHeight);
                int oldTempBitmap = OS.SelectObject(tempHdc, tempBitmap);
                OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
                if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(tempHdc, 3);
                    }
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, srcWidth, srcHeight, 8913094);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
                } else {
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0x660046);
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, 8913094);
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0x660046);
                }
                OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
                OS.SelectObject(tempHdc, oldTempBitmap);
                OS.DeleteDC(tempHdc);
                OS.DeleteObject(tempBitmap);
            }
            OS.SelectObject(maskHdc, oldMaskBitmap);
            OS.DeleteDC(maskHdc);
            OS.DeleteObject(maskBitmap);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        if (hBitmap != srcImage.handle) {
            OS.DeleteObject(hBitmap);
        }
        OS.DeleteDC(srcHdc);
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        int dwRop;
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
        int rop2 = 0;
        if (!OS.IsWinCE) {
            rop2 = OS.GetROP2(this.handle);
        } else {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        }
        int n = dwRop = rop2 == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = 0;
            if (!OS.IsWinCE) {
                mode = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, mode);
            }
        } else {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, dwRop);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            this.initGdip(true, false);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            }
            Gdip.Graphics_DrawLine(gdipGraphics, this.data.gdipPen, x1, y1, x2, y2);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            }
            return;
        }
        if (OS.IsWinCE) {
            int[] points = new int[]{x1, y1, x2, y2};
            OS.Polyline(this.handle, points, points.length / 2);
        } else {
            OS.MoveToEx(this.handle, x1, y1, 0);
            OS.LineTo(this.handle, x2, y2);
        }
        if (this.data.lineWidth <= 1) {
            OS.SetPixel(this.handle, x2, y2, OS.GetTextColor(this.handle));
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            this.initGdip(true, false);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            }
            Gdip.Graphics_DrawEllipse(gdipGraphics, this.data.gdipPen, x, y, width, height);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            }
            return;
        }
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, oldBrush);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initGdip(true, false);
        int gdipGraphics = this.data.gdipGraphics;
        if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
        }
        Gdip.Graphics_DrawPath(gdipGraphics, this.data.gdipPen, path.handle);
        if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
        }
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetPixel(this.handle, x, y, OS.GetTextColor(this.handle));
    }

    public void drawPolygon(int[] pointArray) {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            this.initGdip(true, false);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            }
            Gdip.Graphics_DrawPolygon(gdipGraphics, this.data.gdipPen, pointArray, pointArray.length / 2);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            }
            return;
        }
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        OS.SelectObject(this.handle, oldBrush);
    }

    public void drawPolyline(int[] pointArray) {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            this.initGdip(true, false);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            }
            Gdip.Graphics_DrawLines(gdipGraphics, this.data.gdipPen, pointArray, pointArray.length / 2);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            }
            return;
        }
        OS.Polyline(this.handle, pointArray, pointArray.length / 2);
        int length = pointArray.length;
        if (length >= 2 && this.data.lineWidth <= 1) {
            OS.SetPixel(this.handle, pointArray[length - 2], pointArray[length - 1], OS.GetTextColor(this.handle));
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            this.initGdip(true, false);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            }
            Gdip.Graphics_DrawRectangle(gdipGraphics, this.data.gdipPen, x, y, width, height);
            if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            }
            return;
        }
        int hOld = OS.SelectObject(this.handle, OS.GetStockObject(5));
        OS.Rectangle(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, hOld);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0) {
            this.initGdip(true, false);
            this.drawRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipPen, x, y, width, height, arcWidth, arcHeight);
            return;
        }
        if (OS.IsWinCE) {
            if (width == 0 || height == 0) {
                return;
            }
            if (arcWidth == 0 || arcHeight == 0) {
                this.drawRectangle(x, y, width, height);
                return;
            }
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            if (arcWidth < 0) {
                arcWidth = -arcWidth;
            }
            if (arcHeight < 0) {
                arcHeight = -arcHeight;
            }
            if (arcWidth > width) {
                arcWidth = width;
            }
            if (arcHeight > height) {
                arcHeight = height;
            }
            if (arcWidth < width) {
                this.drawLine(x + arcWidth / 2, y, x + width - arcWidth / 2, y);
                this.drawLine(x + arcWidth / 2, y + height, x + width - arcWidth / 2, y + height);
            }
            if (arcHeight < height) {
                this.drawLine(x, y + arcHeight / 2, x, y + height - arcHeight / 2);
                this.drawLine(x + width, y + arcHeight / 2, x + width, y + height - arcHeight / 2);
            }
            if (arcWidth != 0 && arcHeight != 0) {
                this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
                this.drawArc(x + width - arcWidth, y, arcWidth, arcHeight, 0, 90);
                this.drawArc(x + width - arcWidth, y + height - arcHeight, arcWidth, arcHeight, 0, -90);
                this.drawArc(x, y + height - arcHeight, arcWidth, arcHeight, 180, 90);
            }
        } else {
            int nullBrush = OS.GetStockObject(5);
            int oldBrush = OS.SelectObject(this.handle, nullBrush);
            OS.RoundRect(this.handle, x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
            OS.SelectObject(this.handle, oldBrush);
        }
    }

    void drawRoundRectangleGdip(int gdipGraphics, int brush, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
        }
        if (nw > naw) {
            if (nh > nah) {
                Gdip.Graphics_DrawArc(gdipGraphics, brush, nx, ny, naw, nah, -90.0f, -90.0f);
                Gdip.Graphics_DrawLine(gdipGraphics, brush, nx + naw2, ny, nx + nw - naw2, ny);
                Gdip.Graphics_DrawArc(gdipGraphics, brush, nx + nw - naw, ny, naw, nah, 0.0f, -90.0f);
                Gdip.Graphics_DrawLine(gdipGraphics, brush, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
                Gdip.Graphics_DrawArc(gdipGraphics, brush, nx + nw - naw, ny + nh - nah, naw, nah, -270.0f, -90.0f);
                Gdip.Graphics_DrawLine(gdipGraphics, brush, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
                Gdip.Graphics_DrawArc(gdipGraphics, brush, nx, ny + nh - nah, naw, nah, -180.0f, -90.0f);
                Gdip.Graphics_DrawLine(gdipGraphics, brush, nx, ny + nah2, nx, ny + nh - nah2);
            } else {
                Gdip.Graphics_DrawArc(gdipGraphics, brush, nx, ny, naw, nh, -90.0f, -180.0f);
                Gdip.Graphics_DrawLine(gdipGraphics, brush, nx + naw2, ny, nx + nw - naw2, ny);
                Gdip.Graphics_DrawArc(gdipGraphics, brush, nx + nw - naw, ny, naw, nh, -270.0f, -180.0f);
                Gdip.Graphics_DrawLine(gdipGraphics, brush, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
            }
        } else if (nh > nah) {
            Gdip.Graphics_DrawArc(gdipGraphics, brush, nx, ny, nw, nah, 0.0f, -180.0f);
            Gdip.Graphics_DrawLine(gdipGraphics, brush, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
            Gdip.Graphics_DrawArc(gdipGraphics, brush, nx, ny + nh - nah, nw, nah, -180.0f, -180.0f);
            Gdip.Graphics_DrawLine(gdipGraphics, brush, nx, ny + nah2, nx, ny + nh - nah2);
        } else {
            Gdip.Graphics_DrawArc(gdipGraphics, brush, nx, ny, nw, nh, 0.0f, 360.0f);
        }
        if (this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1) {
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((length = string.length()) == 0) {
            return;
        }
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        if (this.data.gdipGraphics != 0) {
            this.initGdip(true, !isTransparent);
            int font = this.createGdipFont();
            PointF pt = new PointF();
            pt.X = x;
            pt.Y = y;
            int brush = Gdip.Pen_GetBrush(this.data.gdipPen);
            int format = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
            Gdip.StringFormat_SetFormatFlags(format, Gdip.StringFormat_GetFormatFlags(format) | 0x800);
            if (!isTransparent) {
                RectF bounds = new RectF();
                Gdip.Graphics_MeasureString(this.data.gdipGraphics, buffer, length, font, pt, format, bounds);
                Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, (int)bounds.X, (int)bounds.Y, Math.round(bounds.Width), Math.round(bounds.Height));
            }
            Gdip.Graphics_DrawString(this.data.gdipGraphics, buffer, length, font, pt, format, brush);
            Gdip.StringFormat_delete(format);
            this.destroyGdipBrush(brush);
            Gdip.Font_delete(font);
            return;
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int oldBkMode = OS.SetBkMode(this.handle, isTransparent ? 1 : 2);
        if (rop2 != 7) {
            OS.ExtTextOutW(this.handle, x, y, 0, null, buffer, length, null);
        } else {
            int foreground = OS.GetTextColor(this.handle);
            if (isTransparent) {
                SIZE size = new SIZE();
                OS.GetTextExtentPoint32W(this.handle, buffer, length, size);
                int width = size.cx;
                int height = size.cy;
                int hBitmap = OS.CreateCompatibleBitmap(this.handle, width, height);
                if (hBitmap == 0) {
                    SWT.error(2);
                }
                int memDC = OS.CreateCompatibleDC(this.handle);
                int hOldBitmap = OS.SelectObject(memDC, hBitmap);
                OS.PatBlt(memDC, 0, 0, width, height, 66);
                OS.SetBkMode(memDC, 1);
                OS.SetTextColor(memDC, foreground);
                OS.SelectObject(memDC, OS.GetCurrentObject(this.handle, 6));
                OS.ExtTextOutW(memDC, 0, 0, 0, null, buffer, length, null);
                OS.BitBlt(this.handle, x, y, width, height, memDC, 0, 0, 0x660046);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
                OS.DeleteObject(hBitmap);
            } else {
                int background = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, foreground ^ background);
                OS.ExtTextOutW(this.handle, x, y, 0, null, buffer, length, null);
                OS.SetTextColor(this.handle, foreground);
            }
        }
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        if (this.data.gdipGraphics != 0) {
            float[] fArray;
            this.initGdip(true, (flags & 1) == 0);
            int length = string.length();
            char[] buffer = new char[length];
            string.getChars(0, length, buffer, 0);
            int font = this.createGdipFont();
            PointF pt = new PointF();
            pt.X = x;
            pt.Y = y;
            int brush = Gdip.Pen_GetBrush(this.data.gdipPen);
            int format = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
            Gdip.StringFormat_SetFormatFlags(format, Gdip.StringFormat_GetFormatFlags(format) | 0x800);
            if ((flags & 4) != 0) {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = this.measureSpace(font, format) * 8.0f;
            } else {
                fArray = new float[1];
            }
            float[] tabs = fArray;
            Gdip.StringFormat_SetTabStops(format, 0.0f, tabs.length, tabs);
            Gdip.StringFormat_SetHotkeyPrefix(format, (flags & 8) != 0 ? 1 : 0);
            if ((flags & 1) == 0) {
                RectF bounds = new RectF();
                Gdip.Graphics_MeasureString(this.data.gdipGraphics, buffer, length, font, pt, format, bounds);
                Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, (int)bounds.X, (int)bounds.Y, Math.round(bounds.Width), Math.round(bounds.Height));
            }
            Gdip.Graphics_DrawString(this.data.gdipGraphics, buffer, length, font, pt, format, brush);
            Gdip.StringFormat_delete(format);
            this.destroyGdipBrush(brush);
            Gdip.Font_delete(font);
            return;
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
        int length = buffer.length();
        if (length == 0) {
            return;
        }
        RECT rect = new RECT();
        int limit = OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF;
        OS.SetRect(rect, x, y, limit, limit);
        int uFormat = 0;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int oldBkMode = OS.SetBkMode(this.handle, (flags & 1) != 0 ? 1 : 2);
        if (rop2 != 7) {
            OS.DrawText(this.handle, buffer, length, rect, uFormat);
        } else {
            int foreground = OS.GetTextColor(this.handle);
            if ((flags & 1) != 0) {
                OS.DrawText(this.handle, buffer, buffer.length(), rect, uFormat | 0x400);
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                int hBitmap = OS.CreateCompatibleBitmap(this.handle, width, height);
                if (hBitmap == 0) {
                    SWT.error(2);
                }
                int memDC = OS.CreateCompatibleDC(this.handle);
                int hOldBitmap = OS.SelectObject(memDC, hBitmap);
                OS.PatBlt(memDC, 0, 0, width, height, 66);
                OS.SetBkMode(memDC, 1);
                OS.SetTextColor(memDC, foreground);
                OS.SelectObject(memDC, OS.GetCurrentObject(this.handle, 6));
                OS.SetRect(rect, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                OS.DrawText(memDC, buffer, length, rect, uFormat);
                OS.BitBlt(this.handle, x, y, width, height, memDC, 0, 0, 0x660046);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
                OS.DeleteObject(hBitmap);
            } else {
                int background = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, foreground ^ background);
                OS.DrawText(this.handle, buffer, length, rect, uFormat);
                OS.SetTextColor(this.handle, foreground);
            }
        }
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0) {
            this.initGdip(false, true);
            if (width == height) {
                Gdip.Graphics_FillPie(gdipGraphics, this.data.gdipBrush, x, y, width, height, -startAngle, -arcAngle);
            } else {
                int state = Gdip.Graphics_Save(gdipGraphics);
                Gdip.Graphics_TranslateTransform(gdipGraphics, x, y, 0);
                Gdip.Graphics_ScaleTransform(gdipGraphics, width, height, 0);
                Gdip.Graphics_FillPie(gdipGraphics, this.data.gdipBrush, 0, 0, 1, 1, -startAngle, -arcAngle);
                Gdip.Graphics_Restore(gdipGraphics, state);
            }
            return;
        }
        if (OS.IsWinCE) {
            if (arcAngle < 0) {
                startAngle += arcAngle;
                arcAngle = -arcAngle;
            }
            boolean drawSegments = true;
            if (arcAngle >= 360) {
                arcAngle = 360;
                drawSegments = false;
            }
            int[] points = new int[(arcAngle + 1) * 2 + (drawSegments ? 4 : 0)];
            int cteX = 2 * x + width;
            int cteY = 2 * y + height;
            int index = drawSegments ? 2 : 0;
            int i = 0;
            while (i <= arcAngle) {
                points[index++] = Compatibility.cos(startAngle + i, width) + cteX >> 1;
                points[index++] = cteY - Compatibility.sin(startAngle + i, height) >> 1;
                ++i;
            }
            if (drawSegments) {
                int n = cteX >> 1;
                points[points.length - 2] = n;
                points[0] = n;
                int n2 = cteY >> 1;
                points[points.length - 1] = n2;
                points[1] = n2;
            }
            int nullPen = OS.GetStockObject(8);
            int oldPen = OS.SelectObject(this.handle, nullPen);
            OS.Polygon(this.handle, points, points.length / 2);
            OS.SelectObject(this.handle, oldPen);
        } else {
            int y1;
            int y2;
            int x1;
            int x2;
            if (arcAngle >= 360 || arcAngle <= -360) {
                x1 = x2 = x + width;
                y1 = y2 = y + height / 2;
            } else {
                boolean isNegative = arcAngle < 0;
                arcAngle += startAngle;
                if (isNegative) {
                    int tmp = startAngle;
                    startAngle = arcAngle;
                    arcAngle = tmp;
                }
                x1 = Compatibility.cos(startAngle, width) + x + width / 2;
                y1 = -1 * Compatibility.sin(startAngle, height) + y + height / 2;
                x2 = Compatibility.cos(arcAngle, width) + x + width / 2;
                y2 = -1 * Compatibility.sin(arcAngle, height) + y + height / 2;
            }
            int nullPen = OS.GetStockObject(8);
            int oldPen = OS.SelectObject(this.handle, nullPen);
            OS.Pie(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
            OS.SelectObject(this.handle, oldPen);
        }
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int depth;
        int toColor;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int fromColor = OS.GetTextColor(this.handle);
        if (fromColor == -1) {
            fromColor = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        if ((toColor = OS.GetBkColor(this.handle)) == -1) {
            toColor = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int t = fromColor;
            fromColor = toColor;
            toColor = t;
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        RGB fromRGB = new RGB(fromColor & 0xFF, fromColor >>> 8 & 0xFF, fromColor >>> 16 & 0xFF);
        RGB toRGB = new RGB(toColor & 0xFF, toColor >>> 8 & 0xFF, toColor >>> 16 & 0xFF);
        if (fromRGB.red == toRGB.red && fromRGB.green == toRGB.green && fromRGB.blue == toRGB.blue) {
            if (this.data.gdipGraphics != 0) {
                this.initGdip(false, true);
                Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height);
            } else {
                int dwRop = rop2 == 7 ? 5898313 : 15728673;
                OS.PatBlt(this.handle, x, y, width, height, dwRop);
            }
            return;
        }
        if (this.data.gdipGraphics != 0) {
            int toGpColor;
            this.initGdip(false, true);
            PointF p1 = new PointF();
            PointF p2 = new PointF();
            p1.X = x;
            p1.Y = y;
            if (vertical) {
                p2.X = p1.X;
                p2.Y = p1.Y + (float)height;
            } else {
                p2.X = p1.X + (float)width;
                p2.Y = p1.Y;
            }
            int rgb = fromColor >> 16 & 0xFF | fromColor & 0xFF00 | (fromColor & 0xFF) << 16;
            int fromGpColor = Gdip.Color_new(this.data.alpha << 24 | rgb);
            if (fromGpColor == 0) {
                SWT.error(2);
            }
            if ((toGpColor = Gdip.Color_new(this.data.alpha << 24 | (rgb = toColor >> 16 & 0xFF | toColor & 0xFF00 | (toColor & 0xFF) << 16))) == 0) {
                SWT.error(2);
            }
            int brush = Gdip.LinearGradientBrush_new(p1, p2, fromGpColor, toGpColor);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, brush, x, y, width, height);
            Gdip.LinearGradientBrush_delete(brush);
            Gdip.Color_delete(fromGpColor);
            Gdip.Color_delete(toGpColor);
            return;
        }
        if (OS.IsWinNT && rop2 != 7 && OS.GetDeviceCaps(this.handle, 2) != 2) {
            int hHeap = OS.GetProcessHeap();
            int pMesh = OS.HeapAlloc(hHeap, 8, 40);
            int pVertex = pMesh + 8;
            GRADIENT_RECT gradientRect = new GRADIENT_RECT();
            gradientRect.UpperLeft = 0;
            gradientRect.LowerRight = 1;
            OS.MoveMemory(pMesh, gradientRect, 8);
            TRIVERTEX trivertex = new TRIVERTEX();
            trivertex.x = x;
            trivertex.y = y;
            trivertex.Red = (short)(fromRGB.red << 8 | fromRGB.red);
            trivertex.Green = (short)(fromRGB.green << 8 | fromRGB.green);
            trivertex.Blue = (short)(fromRGB.blue << 8 | fromRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex, trivertex, 16);
            trivertex.x = x + width;
            trivertex.y = y + height;
            trivertex.Red = (short)(toRGB.red << 8 | toRGB.red);
            trivertex.Green = (short)(toRGB.green << 8 | toRGB.green);
            trivertex.Blue = (short)(toRGB.blue << 8 | toRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex + 16, trivertex, 16);
            boolean success = OS.GradientFill(this.handle, pVertex, 2, pMesh, 1, vertical ? 1 : 0);
            OS.HeapFree(hHeap, 0, pMesh);
            if (success) {
                return;
            }
        }
        int bitResolution = (depth = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (depth >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, bitResolution, bitResolution, bitResolution);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0) {
            this.initGdip(false, true);
            Gdip.Graphics_FillEllipse(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height);
            return;
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, oldPen);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initGdip(false, true);
        int mode = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(path.handle, mode);
        Gdip.Graphics_FillPath(this.data.gdipGraphics, this.data.gdipBrush, path.handle);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.gdipGraphics != 0) {
            this.initGdip(false, true);
            int mode = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            Gdip.Graphics_FillPolygon(this.data.gdipGraphics, this.data.gdipBrush, pointArray, pointArray.length / 2, mode);
            return;
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        OS.SelectObject(this.handle, oldPen);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0) {
            this.initGdip(false, true);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height);
            return;
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int dwRop = rop2 == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, x, y, width, height, dwRop);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0) {
            this.initGdip(false, true);
            this.fillRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height, arcWidth, arcHeight);
            return;
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.RoundRect(this.handle, x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
        OS.SelectObject(this.handle, oldPen);
    }

    void fillRoundRectangleGdip(int gdipGraphics, int brush, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        if (nw > naw) {
            if (nh > nah) {
                Gdip.Graphics_FillPie(gdipGraphics, brush, nx, ny, naw, nah, -90.0f, -90.0f);
                Gdip.Graphics_FillRectangle(gdipGraphics, brush, nx + naw2, ny, nw - naw2 * 2, nah2);
                Gdip.Graphics_FillPie(gdipGraphics, brush, nx + nw - naw, ny, naw, nah, 0.0f, -90.0f);
                Gdip.Graphics_FillRectangle(gdipGraphics, brush, nx, ny + nah2, nw, nh - nah2 * 2);
                Gdip.Graphics_FillPie(gdipGraphics, brush, nx + nw - naw, ny + nh - nah, naw, nah, -270.0f, -90.0f);
                Gdip.Graphics_FillRectangle(gdipGraphics, brush, nx + naw2, ny + nh - nah2, nw - naw2 * 2, nah2);
                Gdip.Graphics_FillPie(gdipGraphics, brush, nx, ny + nh - nah, naw, nah, -180.0f, -90.0f);
            } else {
                Gdip.Graphics_FillPie(gdipGraphics, brush, nx, ny, naw, nh, -90.0f, -180.0f);
                Gdip.Graphics_FillRectangle(gdipGraphics, brush, nx + naw2, ny, nw - naw2 * 2, nh);
                Gdip.Graphics_FillPie(gdipGraphics, brush, nx + nw - naw, ny, naw, nh, -270.0f, -180.0f);
            }
        } else if (nh > nah) {
            Gdip.Graphics_FillPie(gdipGraphics, brush, nx, ny, nw, nah, 0.0f, -180.0f);
            Gdip.Graphics_FillRectangle(gdipGraphics, brush, nx, ny + nah2, nw, nh - nah2 * 2);
            Gdip.Graphics_FillPie(gdipGraphics, brush, nx, ny + nh - nah, nw, nah, -180.0f, -180.0f);
        } else {
            Gdip.Graphics_FillPie(gdipGraphics, brush, nx, ny, nw, nh, 0.0f, 360.0f);
        }
    }

    void flush() {
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_Flush(this.data.gdipGraphics, 0);
            int hdc = Gdip.Graphics_GetHDC(this.data.gdipGraphics);
            Gdip.Graphics_ReleaseHDC(this.data.gdipGraphics, hdc);
        }
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{ch}, 1, size);
            return size.cx;
        }
        int tch = ch;
        if (ch > 127) {
            TCHAR buffer = new TCHAR(this.getCodePage(), (char)ch, false);
            tch = buffer.tcharAt(0);
        }
        int[] width = new int[1];
        OS.GetCharWidth(this.handle, tch, tch, width);
        return width[0];
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.gdipGraphics != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int mode = Gdip.Graphics_GetSmoothingMode(this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        int color;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((color = OS.GetBkColor(this.handle)) == -1) {
            color = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return Color.win32_new(this.data.device, color);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!OS.IsWinCE) {
            int[] width;
            int tch = ch;
            if (ch > 127) {
                TCHAR buffer = new TCHAR(this.getCodePage(), (char)ch, false);
                tch = buffer.tcharAt(0);
            }
            if (OS.GetCharABCWidths(this.handle, tch, tch, width = new int[3])) {
                return width[1];
            }
        }
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, lptm);
        SIZE size = new SIZE();
        OS.GetTextExtentPoint32W(this.handle, new char[]{ch}, 1, size);
        return size.cx - lptm.tmOverhang;
    }

    public Rectangle getClipping() {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            Rect rect = new Rect();
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            Gdip.Graphics_GetVisibleClipBounds(gdipGraphics, rect);
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            return new Rectangle(rect.X, rect.Y, rect.Width, rect.Height);
        }
        RECT rect = new RECT();
        OS.GetClipBox(this.handle, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void getClipping(Region region) {
        int result;
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            int rgn = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, rgn);
            if (Gdip.Region_IsInfinite(rgn, gdipGraphics)) {
                Rect rect = new Rect();
                Gdip.Graphics_GetVisibleClipBounds(gdipGraphics, rect);
                OS.SetRectRgn(region.handle, rect.X, rect.Y, rect.Width, rect.Height);
            } else {
                int matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                int identity = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                Gdip.Graphics_GetTransform(gdipGraphics, matrix);
                Gdip.Graphics_SetTransform(gdipGraphics, identity);
                int hRgn = Gdip.Region_GetHRGN(rgn, this.data.gdipGraphics);
                Gdip.Graphics_SetTransform(gdipGraphics, matrix);
                Gdip.Matrix_delete(identity);
                Gdip.Matrix_delete(matrix);
                OS.CombineRgn(region.handle, hRgn, 0, 5);
                OS.DeleteObject(hRgn);
            }
            Gdip.Region_delete(rgn);
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            return;
        }
        POINT pt = new POINT();
        if (!OS.IsWinCE) {
            OS.GetWindowOrgEx(this.handle, pt);
        }
        if ((result = OS.GetClipRgn(this.handle, region.handle)) != 1) {
            RECT rect = new RECT();
            OS.GetClipBox(this.handle, rect);
            OS.SetRectRgn(region.handle, rect.left, rect.top, rect.right, rect.bottom);
        } else {
            OS.OffsetRgn(region.handle, pt.x, pt.y);
        }
        if (!OS.IsWinCE) {
            int metaRgn = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetMetaRgn(this.handle, metaRgn) != 0) {
                OS.OffsetRgn(metaRgn, pt.x, pt.y);
                OS.CombineRgn(region.handle, metaRgn, region.handle, 1);
            }
            OS.DeleteObject(metaRgn);
            int hwnd = this.data.hwnd;
            if (hwnd != 0 && this.data.ps != null) {
                int sysRgn = OS.CreateRectRgn(0, 0, 0, 0);
                if (OS.GetRandomRgn(this.handle, sysRgn, 4) == 1) {
                    if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (OS.GetLayout(this.handle) & 1) != 0) {
                        int nBytes = OS.GetRegionData(sysRgn, 0, null);
                        int[] lpRgnData = new int[nBytes / 4];
                        OS.GetRegionData(sysRgn, nBytes, lpRgnData);
                        int newSysRgn = OS.ExtCreateRegion(new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, nBytes, lpRgnData);
                        OS.DeleteObject(sysRgn);
                        sysRgn = newSysRgn;
                    }
                    if (OS.IsWinNT) {
                        OS.MapWindowPoints(0, hwnd, pt, 1);
                        OS.OffsetRgn(sysRgn, pt.x, pt.y);
                    }
                    OS.CombineRgn(region.handle, sysRgn, region.handle, 1);
                }
                OS.DeleteObject(sysRgn);
            }
        }
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int[] lpCs = new int[8];
        int cs = OS.GetTextCharset(this.handle);
        OS.TranslateCharsetInfo(cs, lpCs, 1);
        return lpCs[1];
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            return 1;
        }
        return OS.GetPolyFillMode(this.handle) == 2 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hFont = OS.GetCurrentObject(this.handle, 6);
        return Font.win32_new(this.data.device, hFont);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, lptm);
        return FontMetrics.win32_new(lptm);
    }

    public Color getForeground() {
        int color;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((color = OS.GetTextColor(this.handle)) == -1) {
            color = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return Color.win32_new(this.data.device, color);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int mode = Gdip.Graphics_GetInterpolationMode(this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 5: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return -1;
    }

    public int getLineCap() {
        int style;
        Object logPen;
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            style = ((LOGPEN)logPen).lopnStyle | 0x200;
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            style = ((EXTLOGPEN)logPen).elpPenStyle & 0xF00;
        }
        int cap = 2;
        switch (style) {
            case 0: {
                cap = 2;
                break;
            }
            case 512: {
                cap = 1;
                break;
            }
            case 256: {
                cap = 3;
            }
        }
        return cap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.dashes == null) {
            return null;
        }
        int[] dashes = new int[this.data.dashes.length];
        System.arraycopy(this.data.dashes, 0, dashes, 0, dashes.length);
        return dashes;
    }

    public int getLineJoin() {
        int style;
        Object logPen;
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            style = ((LOGPEN)logPen).lopnStyle | 0x2000;
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            style = ((EXTLOGPEN)logPen).elpPenStyle & 0xF000;
        }
        int join = 2;
        switch (style) {
            case 8192: {
                join = 1;
                break;
            }
            case 0: {
                join = 2;
                break;
            }
            case 4096: {
                join = 3;
            }
        }
        return join;
    }

    public int getLineStyle() {
        int style;
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            LOGPEN logPen = new LOGPEN();
            OS.GetObject(hPen, 16, logPen);
            style = logPen.lopnStyle;
        } else {
            EXTLOGPEN logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory(logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            style = logPen.elpPenStyle & 0xF;
        }
        switch (style) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 1;
    }

    public int getLineWidth() {
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            LOGPEN logPen = new LOGPEN();
            OS.GetObject(hPen, 16, logPen);
            return logPen.x;
        }
        EXTLOGPEN logPen = new EXTLOGPEN();
        if (size <= 28) {
            OS.GetObject(hPen, size, logPen);
        } else {
            int hHeap = OS.GetProcessHeap();
            int ptr = OS.HeapAlloc(hHeap, 8, size);
            OS.GetObject(hPen, size, ptr);
            OS.MoveMemory(logPen, ptr, 28);
            OS.HeapFree(hHeap, 0, ptr);
        }
        return logPen.elpWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int mode = Gdip.Graphics_GetTextRenderingHint(this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int gdipGraphics;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0) {
            Gdip.Graphics_GetTransform(gdipGraphics, transform.handle);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        return rop2 == 7;
    }

    void initGdip(boolean draw, boolean fill) {
        this.data.device.checkGDIP();
        int gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics == 0) {
            int hRgn = OS.CreateRectRgn(0, 0, 0, 0);
            int result = OS.GetClipRgn(this.handle, hRgn);
            if (!OS.IsWinCE) {
                POINT pt = new POINT();
                OS.GetWindowOrgEx(this.handle, pt);
                OS.OffsetRgn(hRgn, pt.x, pt.y);
            }
            OS.SelectClipRgn(this.handle, 0);
            gdipGraphics = this.data.gdipGraphics = Gdip.Graphics_new(this.handle);
            if (gdipGraphics == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            if (result == 1) {
                this.setClipping(hRgn);
            }
            OS.DeleteObject(hRgn);
        }
        if (draw && this.data.gdipPen == 0) {
            this.data.gdipPen = this.createGdipPen();
        }
        if (fill && this.data.gdipBrush == 0) {
            this.data.gdipBrush = this.createGdipBrush();
        }
    }

    void init(Drawable drawable, GCData data, int hDC) {
        int layout;
        Image image;
        int hPalette;
        int hFont;
        int background;
        int foreground = data.foreground;
        if (foreground != -1 && OS.GetTextColor(hDC) != foreground) {
            OS.SetTextColor(hDC, foreground);
            int newPen = OS.CreatePen(0, 0, foreground);
            OS.SelectObject(hDC, newPen);
            if (data.hPen != 0) {
                OS.DeleteObject(data.hPen);
            }
            data.hPen = newPen;
        }
        if ((background = data.background) != -1 && OS.GetBkColor(hDC) != background) {
            OS.SetBkColor(hDC, background);
            int newBrush = OS.CreateSolidBrush(background);
            OS.SelectObject(hDC, newBrush);
            if (data.hBrush != 0) {
                OS.DeleteObject(data.hBrush);
            }
            data.hBrush = newBrush;
        }
        if ((hFont = data.hFont) != 0) {
            OS.SelectObject(hDC, hFont);
        }
        if ((hPalette = data.device.hPalette) != 0) {
            OS.SelectPalette(hDC, hPalette, true);
            OS.RealizePalette(hDC);
        }
        if ((image = data.image) != null) {
            data.hNullBitmap = OS.SelectObject(hDC, image.handle);
            image.memGC = this;
        }
        if ((layout = data.layout) != -1 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            int flags = OS.GetLayout(hDC);
            if ((flags & 1) != (layout & 1)) {
                OS.SetLayout(hDC, (flags &= 0xFFFFFFFE) | layout);
            }
            if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = hDC;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int region = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, region);
        OS.DeleteObject(region);
        return result > 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    float measureSpace(int font, int format) {
        PointF pt = new PointF();
        RectF bounds = new RectF();
        Gdip.Graphics_MeasureString(this.data.gdipGraphics, new char[]{' '}, 1, font, pt, format, bounds);
        return bounds.Width;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (advanced && this.data.gdipGraphics != 0) {
            return;
        }
        if (advanced) {
            try {
                this.initGdip(false, false);
            }
            catch (SWTException sWTException) {}
        } else {
            int foreground = OS.GetTextColor(this.handle);
            int background = OS.GetBkColor(this.handle);
            if (this.data.gdipGraphics != 0) {
                Gdip.Graphics_delete(this.data.gdipGraphics);
            }
            if (this.data.gdipPen != 0) {
                Gdip.Pen_delete(this.data.gdipPen);
            }
            if (this.data.gdipBrush != 0) {
                this.destroyGdipBrush(this.data.gdipBrush);
            }
            this.data.gdipPen = 0;
            this.data.gdipBrush = 0;
            this.data.gdipGraphics = 0;
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.setClipping(0);
            OS.SetTextColor(this.handle, foreground);
            OS.SetBkColor(this.handle, background);
            if (this.data.hPen != 0) {
                OS.SelectObject(this.handle, this.data.hPen);
            }
            if (this.data.hBrush != 0) {
                OS.SelectObject(this.handle, this.data.hBrush);
            }
        }
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 3;
                break;
            }
            case 1: {
                mode = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip(false, false);
        Gdip.Graphics_SetSmoothingMode(this.data.gdipGraphics, mode);
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && (alpha & 0xFF) == 255) {
            return;
        }
        this.initGdip(false, false);
        this.data.alpha = alpha & 0xFF;
        if (this.data.gdipPen != 0) {
            Gdip.Pen_delete(this.data.gdipPen);
            this.data.gdipPen = 0;
        }
        if (this.data.gdipBrush != 0) {
            this.destroyGdipBrush(this.data.gdipBrush);
            this.data.gdipBrush = 0;
        }
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern != null) {
            if (this.data.gdipBrush != 0) {
                this.destroyGdipBrush(this.data.gdipBrush);
                this.data.gdipBrush = 0;
            }
            this.data.backgroundPattern = null;
        }
        if (OS.GetBkColor(this.handle) == color.handle) {
            return;
        }
        this.data.background = color.handle;
        OS.SetBkColor(this.handle, color.handle);
        int newBrush = OS.CreateSolidBrush(color.handle);
        OS.SelectObject(this.handle, newBrush);
        if (this.data.hBrush != 0) {
            OS.DeleteObject(this.data.hBrush);
        }
        this.data.hBrush = newBrush;
        if (this.data.gdipBrush != 0) {
            this.destroyGdipBrush(this.data.gdipBrush);
            this.data.gdipBrush = 0;
        }
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && pattern == null) {
            return;
        }
        this.initGdip(false, false);
        if (this.data.gdipBrush != 0) {
            this.destroyGdipBrush(this.data.gdipBrush);
        }
        this.data.gdipBrush = pattern != null ? Gdip.Brush_Clone(pattern.handle) : 0;
        this.data.backgroundPattern = pattern;
    }

    void setClipping(int clipRgn) {
        int hRgn = clipRgn;
        int gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0) {
            if (hRgn != 0) {
                int region = Gdip.Region_new(hRgn);
                Gdip.Graphics_SetClip(gdipGraphics, region, 0);
                Gdip.Region_delete(region);
            } else {
                Gdip.Graphics_ResetClip(gdipGraphics);
            }
        } else {
            POINT pt = null;
            if (hRgn != 0 && !OS.IsWinCE) {
                pt = new POINT();
                OS.GetWindowOrgEx(this.handle, pt);
                OS.OffsetRgn(hRgn, -pt.x, -pt.y);
            }
            OS.SelectClipRgn(this.handle, hRgn);
            if (hRgn != 0) {
                OS.OffsetRgn(hRgn, pt.x, pt.y);
            }
        }
        if (hRgn != 0 && hRgn != clipRgn) {
            OS.DeleteObject(hRgn);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hRgn = OS.CreateRectRgn(x, y, x + width, y + height);
        this.setClipping(hRgn);
        OS.DeleteObject(hRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            this.initGdip(false, false);
            int mode = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            Gdip.GraphicsPath_SetFillMode(path.handle, mode);
            Gdip.Graphics_SetClip(this.data.gdipGraphics, path.handle);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            return;
        }
        int mode = 1;
        switch (rule) {
            case 2: {
                mode = 2;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.SetPolyFillMode(this.handle, mode);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            OS.SelectObject(this.handle, this.data.device.systemFont);
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            OS.SelectObject(this.handle, font.handle);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern != null) {
            if (this.data.gdipPen != 0) {
                Gdip.Pen_delete(this.data.gdipPen);
                this.data.gdipPen = 0;
            }
            this.data.foregroundPattern = null;
        }
        if (OS.GetTextColor(this.handle) == color.handle) {
            return;
        }
        this.data.foreground = color.handle;
        OS.SetTextColor(this.handle, color.handle);
        this.setPen(color.handle, -1, -1, -1, -1, this.data.dashes);
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && pattern == null) {
            return;
        }
        this.initGdip(false, false);
        if (pattern != null) {
            if (this.data.gdipPen != 0) {
                Gdip.Pen_SetBrush(this.data.gdipPen, pattern.handle);
            }
        } else if (this.data.gdipPen != 0) {
            Gdip.Pen_delete(this.data.gdipPen);
            this.data.gdipPen = 0;
        }
        this.data.foregroundPattern = pattern;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && interpolation == -1) {
            return;
        }
        int mode = 0;
        switch (interpolation) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 5;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip(false, false);
        Gdip.Graphics_SetInterpolationMode(this.data.gdipGraphics, mode);
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int capStyle = 0;
        switch (cap) {
            case 2: {
                capStyle = 0;
                break;
            }
            case 1: {
                capStyle = 512;
                break;
            }
            case 3: {
                capStyle = 256;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.setPen(-1, -1, -1, capStyle, -1, this.data.dashes);
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (dashes != null && dashes.length > 0) {
            this.data.dashes = new int[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                this.data.dashes[i] = dash;
                ++i;
            }
        } else {
            this.data.dashes = null;
        }
        this.setPen(-1, -1, this.data.dashes == null ? 0 : 7, -1, -1, this.data.dashes);
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int joinStyle = 0;
        switch (join) {
            case 1: {
                joinStyle = 8192;
                break;
            }
            case 2: {
                joinStyle = 0;
                break;
            }
            case 3: {
                joinStyle = 4096;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.setPen(-1, -1, -1, -1, joinStyle, this.data.dashes);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int style = -1;
        switch (lineStyle) {
            case 1: {
                style = 0;
                break;
            }
            case 2: {
                style = 1;
                break;
            }
            case 3: {
                style = 2;
                break;
            }
            case 4: {
                style = 3;
                break;
            }
            case 5: {
                style = 4;
                break;
            }
            case 6: {
                style = this.data.dashes == null ? 0 : 7;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.SetBkMode(this.handle, style == 0 ? 2 : 1);
        this.setPen(-1, -1, style, -1, -1, this.data.dashes);
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.setPen(-1, lineWidth, -1, -1, -1, this.data.dashes);
    }

    void setPen(int newColor, int newWidth, int lineStyle, int capStyle, int joinStyle, int[] dashes) {
        int newPen;
        int style;
        int width;
        int color;
        Object logPen;
        boolean extPen = false;
        boolean changed = false;
        int hPen = OS.GetCurrentObject(this.handle, 1);
        int size = OS.GetObject(hPen, 0, null);
        if (size == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            color = ((LOGPEN)logPen).lopnColor;
            width = ((LOGPEN)logPen).x;
            style = ((LOGPEN)logPen).lopnStyle;
            if (width < 1 && (newWidth >= 1 || lineStyle == 7)) {
                if (capStyle == -1) {
                    capStyle = 512;
                }
                if (joinStyle == -1) {
                    joinStyle = 8192;
                }
            }
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            color = ((EXTLOGPEN)logPen).elpColor;
            width = ((EXTLOGPEN)logPen).elpWidth;
            style = ((EXTLOGPEN)logPen).elpPenStyle;
            extPen = true;
            if (newWidth == 0 && dashes == null && (style & 0xF00) == 512 && (style & 0xF000) == 8192) {
                style &= 0xFFF000FF;
                extPen = false;
            }
        }
        if (newColor != -1 && newColor != color) {
            color = newColor;
            changed = true;
        }
        if (newWidth != -1 && newWidth != width) {
            width = newWidth;
            changed = true;
        }
        if (lineStyle != -1 && ((style & 0xF) != lineStyle || (style & 0xF) == 7)) {
            style = style & 0xFFFFFFF0 | lineStyle;
            changed = true;
        }
        if (capStyle != -1 && (style & 0xF00) != capStyle) {
            style = style & 0xFFFFF0FF | capStyle;
            changed = true;
        }
        if (joinStyle != -1 && (style & 0xF000) != joinStyle) {
            style = style & 0xFFFF0FFF | joinStyle;
            changed = true;
        }
        if (!changed) {
            return;
        }
        if ((style & 0xF) != 7) {
            dashes = null;
        }
        if (!OS.IsWinCE && (extPen || width >= 1 || (style & 0xF) == 7)) {
            LOGBRUSH logBrush = new LOGBRUSH();
            logBrush.lbStyle = 0;
            logBrush.lbColor = color;
            newPen = OS.ExtCreatePen(style | 0x10000, Math.max(1, width), logBrush, dashes != null ? dashes.length : 0, dashes);
        } else {
            newPen = OS.CreatePen(style, width, color);
        }
        OS.SelectObject(this.handle, newPen);
        if (this.data.hPen != 0) {
            OS.DeleteObject(this.data.hPen);
        }
        this.data.hPen = newPen;
        this.data.lineWidth = width;
        if (this.data.gdipPen != 0) {
            Gdip.Pen_delete(this.data.gdipPen);
            this.data.gdipPen = 0;
        }
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetROP2(this.handle, xor ? 7 : 13);
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && antialias == -1) {
            return;
        }
        int textMode = 0;
        switch (antialias) {
            case -1: {
                textMode = 0;
                break;
            }
            case 0: {
                textMode = 1;
                break;
            }
            case 1: {
                int[] type = new int[1];
                OS.SystemParametersInfo(8202, 0, type, 0);
                if (type[0] == 2) {
                    textMode = 5;
                    break;
                }
                textMode = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip(false, false);
        Gdip.Graphics_SetTextRenderingHint(this.data.gdipGraphics, textMode);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && transform == null) {
            return;
        }
        this.initGdip(false, false);
        if (transform != null) {
            Gdip.Graphics_SetTransform(this.data.gdipGraphics, transform.handle);
        } else {
            int identity = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            Gdip.Graphics_SetTransform(this.data.gdipGraphics, identity);
            Gdip.Matrix_delete(identity);
        }
    }

    public Point stringExtent(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        int length = string.length();
        if (this.data.gdipGraphics != 0) {
            char[] buffer;
            int font = this.createGdipFont();
            PointF pt = new PointF();
            RectF bounds = new RectF();
            if (length != 0) {
                buffer = new char[length];
                string.getChars(0, length, buffer, 0);
            } else {
                buffer = new char[]{' '};
            }
            int format = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
            Gdip.StringFormat_SetFormatFlags(format, Gdip.StringFormat_GetFormatFlags(format) | 0x800);
            Gdip.Graphics_MeasureString(this.data.gdipGraphics, buffer, buffer.length, font, pt, format, bounds);
            Gdip.StringFormat_delete(format);
            Gdip.Font_delete(font);
            return new Point(length == 0 ? 0 : Math.round(bounds.Width), Math.round(bounds.Height));
        }
        SIZE size = new SIZE();
        if (length == 0) {
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        OS.GetTextExtentPoint32W(this.handle, buffer, length, size);
        return new Point(size.cx, size.cy);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (this.data.gdipGraphics != 0) {
            float[] fArray;
            char[] buffer;
            int font = this.createGdipFont();
            PointF pt = new PointF();
            RectF bounds = new RectF();
            int length = string.length();
            if (length != 0) {
                buffer = new char[length];
                string.getChars(0, length, buffer, 0);
            } else {
                buffer = new char[]{' '};
            }
            int format = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
            Gdip.StringFormat_SetFormatFlags(format, Gdip.StringFormat_GetFormatFlags(format) | 0x800);
            if ((flags & 4) != 0) {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = this.measureSpace(font, format) * 8.0f;
            } else {
                fArray = new float[1];
            }
            float[] tabs = fArray;
            Gdip.StringFormat_SetTabStops(format, 0.0f, tabs.length, tabs);
            Gdip.StringFormat_SetHotkeyPrefix(format, (flags & 8) != 0 ? 1 : 0);
            Gdip.Graphics_MeasureString(this.data.gdipGraphics, buffer, buffer.length, font, pt, format, bounds);
            Gdip.StringFormat_delete(format);
            Gdip.Font_delete(font);
            return new Point(length == 0 ? 0 : Math.round(bounds.Width), Math.round(bounds.Height));
        }
        if (string.length() == 0) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        RECT rect = new RECT();
        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
        int uFormat = 1024;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        OS.DrawText(this.handle, buffer, buffer.length(), rect, uFormat);
        return new Point(rect.right, rect.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int hDC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, hDC);
        return gc;
    }

    public static GC win32_new(int hDC, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        gc.init(null, data, hDC);
        return gc;
    }
}

