/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import com.ibm.uma.Activity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.util.ConvertActivityType;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertActivityDialog {
    public static Activity queryUserAndConvert(Activity oldActivity, Shell shell, DeleteMethodElementCommand command) {
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        ListDialog dlg = new ListDialog(shell);
        dlg.setHeightInChars(5);
        dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch ((Integer)element) {
                    case 52: {
                        return LibraryUIText.TEXT_ACTIVITY;
                    }
                    case 56: {
                        return LibraryUIText.TEXT_ITERATION;
                    }
                    case 57: {
                        return LibraryUIText.TEXT_PHASE;
                    }
                }
                return LibraryResources.getString((String)"Library.unknownGuidance.text");
            }
        });
        List newActivityTypeList = ConvertActivityDialog.getValidNewActivityTypes(oldActivity);
        if (newActivityTypeList == null) {
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryResources.getString((String)"Library.convertActivityError.title"), LibraryUIResources.getString("LibraryUI.unsupportedActivityTypeError.msg"), LibraryUIResources.formatString("LibraryUI.unsupportedActivityTypeError.reason", StrUtil.toLower((String)TngUtil.getTypeText((EObject)oldActivity))));
            return null;
        }
        dlg.setInput((Object)newActivityTypeList);
        dlg.setTitle(LibraryUIResources.getString("LibraryUI.convertActivityDialog.title"));
        dlg.setMessage(LibraryUIResources.getString("LibraryUI.convertActivityDialog.text"));
        if (dlg.open() == 1) {
            return null;
        }
        Object[] selectionResult = dlg.getResult();
        if (selectionResult == null) {
            return null;
        }
        int chosenActivity = (Integer)selectionResult[0];
        return ConvertActivityType.convertActivity((Activity)oldActivity, (int)chosenActivity, (DeleteMethodElementCommand)command);
    }

    public static List getValidNewActivityTypes(Activity oldActivity) {
        if (oldActivity == null) {
            return null;
        }
        Integer oldActivityClassID = new Integer(oldActivity.eClass().getClassifierID());
        if (!ConvertActivityType.compatibleActivitiesList.contains(oldActivityClassID)) {
            return null;
        }
        ArrayList<Integer> activityList = new ArrayList<Integer>();
        Iterator iter = ConvertActivityType.compatibleActivitiesList.iterator();
        while (iter.hasNext()) {
            Integer compatibleActivityTypeClassID = (Integer)iter.next();
            if (oldActivityClassID.equals(compatibleActivityTypeClassID) || compatibleActivityTypeClassID == 98 || compatibleActivityTypeClassID == 96) continue;
            activityList.add(compatibleActivityTypeClassID);
        }
        return activityList;
    }
}

