/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import com.ibm.uma.MethodConfiguration;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class SwitchConfigDialog {
    private MethodConfiguration recommendedConfig;
    private Shell shell;

    public SwitchConfigDialog(Shell shell, MethodConfiguration recommendedConfig) {
        this.shell = shell;
        this.recommendedConfig = recommendedConfig;
    }

    public void execute() {
        if (this.recommendedConfig == null) {
            return;
        }
        String switchConfigPref = LibraryUIPreferences.getSwitchConfig();
        if ("never".equals(switchConfigPref)) {
            LibraryProcessor.getInstance().setCurrentConfiguration(LibraryProcessor.getInstance().getCurrentConfiguration());
            return;
        }
        if (LibraryProcessor.getInstance().getCurrentMethodConfiguration() != this.recommendedConfig) {
            String configName = this.recommendedConfig.getName();
            if ("prompt".equals(switchConfigPref)) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.shell, (String)LibraryUIResources.getString("LibraryUI.switchConfigDialog.title"), (String)LibraryUIResources.formatString("LibraryUI.switchConfigDialog.text", configName), null, (boolean)false, (IPreferenceStore)LibraryUIPlugin.getDefault().getPreferenceStore(), (String)"switchConfigurationOnProcessActivate");
                if (dialog.getReturnCode() == 2) {
                    LibraryProcessor.getInstance().setCurrentConfiguration(configName);
                } else {
                    LibraryProcessor.getInstance().setCurrentConfiguration(LibraryProcessor.getInstance().getCurrentConfiguration());
                }
            } else if ("always".equals(switchConfigPref)) {
                LibraryProcessor.getInstance().setCurrentConfiguration(configName);
            }
        }
    }
}

