/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.jarprocessor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipException;
import org.eclipse.update.internal.jarprocessor.JarProcessor;
import org.eclipse.update.internal.jarprocessor.PackStep;
import org.eclipse.update.internal.jarprocessor.PackUnpackStep;
import org.eclipse.update.internal.jarprocessor.SignCommandStep;
import org.eclipse.update.internal.jarprocessor.UnpackStep;
import org.eclipse.update.internal.jarprocessor.Utils;
import org.eclipse.update.internal.jarprocessor.ZipProcessor;

public class Main {
    private static void printUsage() {
        System.out.println("[-option ...]... input");
        System.out.println("The following options are supported:");
        System.out.println("-repack         normalize jars ");
        System.out.println("-sign <command> sign jars using <command>");
        System.out.println("-pack           pack the jars.  pack and repack are redundant unless");
        System.out.println("                sign is also specified.");
        System.out.println("-unpack         unpack pack.gz files. Unpack is mutually exclusive");
        System.out.println("                with repack, sign and pack.");
        System.out.println();
        System.out.println("-outputDir <dir>  the output directory");
    }

    public static Options processArguments(String[] args) {
        if (args.length == 0) {
            Main.printUsage();
            return null;
        }
        Options options = new Options();
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equals("-pack")) {
                options.pack = true;
            } else if (args[i].equals("-unpack")) {
                options.unpack = true;
            } else if (args[i].equals("-sign") && i < args.length - 2) {
                if (args[i + 1].startsWith("-")) {
                    Main.printUsage();
                    return null;
                }
                options.signCommand = args[++i];
            } else if (args[i].equals("-repack")) {
                options.repack = true;
            } else if (args[i].equals("-outputDir") && i < args.length - 2) {
                if (args[i + 1].startsWith("-")) {
                    Main.printUsage();
                    return null;
                }
                options.outputDir = args[++i];
            }
            ++i;
        }
        options.input = new File(args[i]);
        String problemMessage = null;
        if (options.unpack) {
            if (!JarProcessor.canPerformUnpack()) {
                problemMessage = "The unpack200 command cannot be found.";
            } else if (options.input.isFile() && !args[i].endsWith(".zip") && !args[i].endsWith(".pack.gz")) {
                problemMessage = "Input file is not a pack.gz file.";
            } else if (options.pack || options.repack || options.signCommand != null) {
                problemMessage = "Pack, repack or sign cannot be specified with unpack.";
            }
        } else if (options.input.isFile() && !args[i].endsWith(".zip") && !args[i].endsWith(".jar")) {
            problemMessage = "Input file is not a jar file.";
        } else if ((options.pack || options.repack) && !JarProcessor.canPerformPack()) {
            problemMessage = "The pack200 command can not be found.";
        }
        if (problemMessage != null) {
            System.out.println(problemMessage);
            System.out.println();
            Main.printUsage();
            return null;
        }
        return options;
    }

    public static void main(String[] args) {
        Options options = Main.processArguments(args);
        if (options == null) {
            return;
        }
        if (options.input.getName().endsWith(".zip")) {
            ZipProcessor processor = new ZipProcessor();
            processor.setWorkingDirectory(options.outputDir);
            processor.setSignCommand(options.signCommand);
            processor.setPack(options.pack);
            processor.setRepack(options.repack || options.pack && options.signCommand != null);
            processor.setUnpack(options.unpack);
            try {
                processor.processZip(options.input);
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            JarProcessor processor = new JarProcessor();
            processor.setWorkingDirectory(options.outputDir);
            if (options.repack || options.pack && options.signCommand != null) {
                processor.addProcessStep(new PackUnpackStep(null));
            }
            if (options.signCommand != null) {
                processor.addProcessStep(new SignCommandStep(null, options.signCommand));
            }
            if (options.pack) {
                processor.addProcessStep(new PackStep(null));
            } else if (options.unpack) {
                processor.addProcessStep(new UnpackStep(null));
            }
            try {
                processor.process(options.input, options.unpack ? Utils.PACK_GZ_FILTER : Utils.JAR_FILTER);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Options {
        public String outputDir = ".";
        public String signCommand = null;
        public boolean pack = false;
        public boolean repack = false;
        public boolean unpack = false;
        public File input = null;
    }
}

