/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.jarprocessor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.eclipse.update.internal.jarprocessor.CommandStep;
import org.eclipse.update.internal.jarprocessor.Utils;

public class PackStep
extends CommandStep {
    protected static String packCommand = null;
    private static Boolean canPack = null;
    private Set exclusions = Collections.EMPTY_SET;

    public static boolean canPack() {
        if (canPack != null) {
            return canPack;
        }
        String[] locations = Utils.getPack200Commands("pack200");
        if (locations == null) {
            canPack = Boolean.FALSE;
            packCommand = null;
            return false;
        }
        int i = 0;
        while (i < locations.length) {
            if (locations[i] != null) {
                try {
                    int result = PackStep.execute(new String[]{locations[i], "-V"});
                    if (result == 0) {
                        packCommand = locations[i];
                        canPack = Boolean.TRUE;
                        return true;
                    }
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        canPack = Boolean.FALSE;
        return false;
    }

    public PackStep(Properties options) {
        super(options, null, null);
        this.exclusions = Utils.getPackExclusions(options);
    }

    public String recursionEffect(String entryName) {
        if (PackStep.canPack() && entryName.endsWith(".jar") && !this.exclusions.contains(entryName)) {
            return String.valueOf(entryName) + ".pack.gz";
        }
        return null;
    }

    public File preProcess(File input, File workingDirectory) {
        return null;
    }

    public File postProcess(File input, File workingDirectory) {
        if (PackStep.canPack() && packCommand != null) {
            File outputFile = new File(workingDirectory, String.valueOf(input.getName()) + ".pack.gz");
            try {
                String[] cmd = this.getCommand(input, outputFile);
                PackStep.execute(cmd);
            }
            catch (IOException iOException) {
                return null;
            }
            return outputFile;
        }
        return null;
    }

    protected String[] getCommand(File input, File outputFile) throws IOException {
        String[] cmd = null;
        String arguments = this.getOptions().getProperty(String.valueOf(input.getName()) + ".pack.args");
        if (arguments != null) {
            String[] args = arguments.split(",\\s*");
            cmd = new String[3 + args.length];
            cmd[0] = packCommand;
            System.arraycopy(args, 0, cmd, 1, args.length);
            cmd[cmd.length - 2] = outputFile.getCanonicalPath();
            cmd[cmd.length - 1] = input.getCanonicalPath();
        } else {
            cmd = new String[]{packCommand, outputFile.getCanonicalPath(), input.getCanonicalPath()};
        }
        return cmd;
    }
}

