/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.verifier;

import com.ibm.icu.text.DateFormat;
import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.core.Messages;

public class CertVerificationResult
implements IVerificationResult {
    private int resultCode;
    private int verificationCode;
    private Exception resultException;
    private CertificateChain[] chains;
    private CertificateChain foundChain;
    private String signerInfo;
    private String verifierInfo;
    private ContentReference contentReference;
    private IFeature feature;
    private boolean featureVerification;
    private boolean alreadySeen;

    public int getResultCode() {
        return this.resultCode;
    }

    public Exception getVerificationException() {
        return this.resultException;
    }

    public void setResultCode(int newResultCode) {
        this.resultCode = newResultCode;
    }

    public void setResultException(Exception newResultException) {
        this.resultException = newResultException;
    }

    public int getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(int verificationCode) {
        this.verificationCode = verificationCode;
    }

    void setChains(CertificateChain[] chains) {
        this.chains = chains;
    }

    public CertificateChain[] getchains() {
        return this.chains;
    }

    private CertificateChain getFoundChain() {
        return this.foundChain;
    }

    public void setFoundChain(CertificateChain foundChain) {
        this.foundChain = foundChain;
    }

    private void initializeCertificates() {
        CertificateChain trustedChain;
        X509Certificate certRoot = null;
        X509Certificate certIssuer = null;
        if (this.getFoundChain() == null) {
            CertificateChain[] certs = this.getchains();
            if (certs.length == 0) {
                return;
            }
            trustedChain = certs[0];
        } else {
            trustedChain = this.getFoundChain();
        }
        certRoot = (X509Certificate)trustedChain.getRoot();
        certIssuer = (X509Certificate)trustedChain.getSigner();
        StringBuffer strb = new StringBuffer();
        strb.append(this.issuerString(certIssuer.getSubjectDN()));
        strb.append("\r\n");
        strb.append(NLS.bind((String)Messages.JarVerificationResult_ValidBetween, (Object[])new String[]{this.dateString(certIssuer.getNotBefore()), this.dateString(certIssuer.getNotAfter())}));
        strb.append(this.checkValidity(certIssuer));
        this.signerInfo = strb.toString();
        if (certIssuer != null && !certIssuer.equals(certRoot)) {
            strb = new StringBuffer();
            strb.append(this.issuerString(certIssuer.getIssuerDN()));
            strb.append("\r\n");
            strb.append(NLS.bind((String)Messages.JarVerificationResult_ValidBetween, (Object[])new String[]{this.dateString(certRoot.getNotBefore()), this.dateString(certRoot.getNotAfter())}));
            strb.append(this.checkValidity(certRoot));
            this.verifierInfo = strb.toString();
        }
    }

    private String checkValidity(X509Certificate cert) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return "\r\n" + Messages.JarVerificationResult_ExpiredCertificate;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return "\r\n" + Messages.JarVerificationResult_CertificateNotYetValid;
        }
        return "\r\n" + Messages.JarVerificationResult_CertificateValid;
    }

    private String issuerString(Principal principal) {
        return principal.toString();
    }

    private String dateString(Date date) {
        return DateFormat.getDateInstance().format(date);
    }

    public String getSignerInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.signerInfo;
    }

    public String getVerifierInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.verifierInfo;
    }

    public ContentReference getContentReference() {
        return this.contentReference;
    }

    public void setContentReference(ContentReference ref) {
        this.contentReference = ref;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public String getText() {
        return null;
    }

    public boolean isFeatureVerification() {
        return this.featureVerification;
    }

    public void isFeatureVerification(boolean featureVerification) {
        this.featureVerification = featureVerification;
    }

    public boolean alreadySeen() {
        return this.alreadySeen;
    }

    public boolean alreadySeen(boolean seen) {
        this.alreadySeen = seen;
        return this.alreadySeen;
    }
}

