/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ILineTrackerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public abstract class AbstractLineTracker
implements ILineTracker,
ILineTrackerExtension {
    private static final boolean ASSERT = false;
    private static final String NO_DELIM = "";
    private Node fRoot = new Node(0, "");
    private int lineHint;
    private int offsetHint;
    private DocumentRewriteSession fActiveRewriteSession;
    private List fPendingRequests;

    protected AbstractLineTracker() {
    }

    private Node nodeByOffset(int offset) throws BadLocationException {
        int remaining = offset;
        Node node = this.fRoot;
        int line = 0;
        while (true) {
            if (node == null) {
                this.fail(offset);
            }
            if (remaining < node.offset) {
                node = node.left;
                continue;
            }
            line += node.line;
            if ((remaining -= node.offset) < node.length || remaining == node.length && node.right == null) {
                this.offsetHint = offset - remaining;
                this.lineHint = line;
                return node;
            }
            remaining -= node.length;
            ++line;
            node = node.right;
        }
    }

    private Node nodeByLine(int line) throws BadLocationException {
        int remaining = line;
        int offset = 0;
        Node node = this.fRoot;
        while (true) {
            if (node == null) {
                this.fail(line);
            }
            if (remaining == node.line) {
                this.offsetHint = offset + node.offset;
                return node;
            }
            if (remaining < node.line) {
                node = node.left;
                continue;
            }
            remaining -= node.line + 1;
            offset += node.offset + node.length;
            node = node.right;
        }
    }

    private void rotateLeft(Node node) {
        Node child = node.right;
        boolean leftChild = node.parent == null || node == node.parent.left;
        this.setChild(node.parent, child, leftChild);
        this.setChild(node, child.left, false);
        this.setChild(child, node, true);
        child.line += node.line + 1;
        child.offset += node.offset + node.length;
    }

    private void rotateRight(Node node) {
        Node child = node.left;
        boolean leftChild = node.parent == null || node == node.parent.left;
        this.setChild(node.parent, child, leftChild);
        this.setChild(node, child.right, true);
        this.setChild(child, node, false);
        node.line -= child.line + 1;
        node.offset -= child.offset + child.length;
    }

    private void setChild(Node parent, Node child, boolean isLeftChild) {
        if (parent == null) {
            this.fRoot = child == null ? new Node(0, NO_DELIM) : child;
        } else if (isLeftChild) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child != null) {
            child.parent = parent;
        }
    }

    private void singleLeftRotation(Node node, Node parent) {
        this.rotateLeft(parent);
        node.balance = 0;
        parent.balance = 0;
    }

    private void singleRightRotation(Node node, Node parent) {
        this.rotateRight(parent);
        node.balance = 0;
        parent.balance = 0;
    }

    private void rightLeftRotation(Node node, Node parent) {
        Node child = node.left;
        this.rotateRight(node);
        this.rotateLeft(parent);
        if (child.balance == 1) {
            node.balance = 0;
            parent.balance = (byte)-1;
            child.balance = 0;
        } else if (child.balance == 0) {
            node.balance = 0;
            parent.balance = 0;
        } else if (child.balance == -1) {
            node.balance = 1;
            parent.balance = 0;
            child.balance = 0;
        }
    }

    private void leftRightRotation(Node node, Node parent) {
        Node child = node.right;
        this.rotateLeft(node);
        this.rotateRight(parent);
        if (child.balance == -1) {
            node.balance = 0;
            parent.balance = 1;
            child.balance = 0;
        } else if (child.balance == 0) {
            node.balance = 0;
            parent.balance = 0;
        } else if (child.balance == 1) {
            node.balance = (byte)-1;
            parent.balance = 0;
            child.balance = 0;
        }
    }

    private Node insertAfter(Node node, int length, String delimiter) {
        Node added = new Node(length, delimiter);
        if (node.right == null) {
            this.setChild(node, added, false);
        } else {
            this.setChild(this.successorDown(node.right), added, true);
        }
        this.updateParentChain(added, length, 1);
        this.updateParentBalanceAfterInsertion(added);
        return added;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateParentBalanceAfterInsertion(Node node) {
        Node parent = node.parent;
        block5: while (parent != null) {
            parent.balance = node == parent.left ? (byte)(parent.balance - 1) : (byte)(parent.balance + 1);
            switch (parent.balance) {
                case -1: 
                case 1: {
                    node = parent;
                    parent = node.parent;
                    continue block5;
                }
                case -2: {
                    this.rebalanceAfterInsertionLeft(node);
                    break;
                }
                case 2: {
                    this.rebalanceAfterInsertionRight(node);
                }
            }
            return;
        }
    }

    private void rebalanceAfterInsertionRight(Node node) {
        Node parent = node.parent;
        if (node.balance == 1) {
            this.singleLeftRotation(node, parent);
        } else if (node.balance == -1) {
            this.rightLeftRotation(node, parent);
        }
    }

    private void rebalanceAfterInsertionLeft(Node node) {
        Node parent = node.parent;
        if (node.balance == -1) {
            this.singleRightRotation(node, parent);
        } else if (node.balance == 1) {
            this.leftRightRotation(node, parent);
        }
    }

    public void replace(int offset, int length, String text) throws BadLocationException {
        if (this.hasActiveRewriteSession()) {
            this.fPendingRequests.add(new Request(offset, length, text));
            return;
        }
        Node first = this.nodeByOffset(offset);
        int firstNodeOffset = this.offsetHint;
        Node last = offset + length < firstNodeOffset + first.length ? first : this.nodeByOffset(offset + length);
        int firstLineDelta = firstNodeOffset + first.length - offset;
        if (first == last) {
            this.replaceInternal(first, text, length, firstLineDelta);
        } else {
            this.replaceFromTo(first, last, text, length, firstLineDelta);
        }
    }

    private void replaceInternal(Node node, String text, int length, int firstLineDelta) {
        DelimiterInfo info;
        DelimiterInfo delimiterInfo = info = text == null ? null : this.nextDelimiterInfo(text, 0);
        if (info == null || info.delimiter == null) {
            int added = text == null ? 0 : text.length();
            this.updateLength(node, added - length);
        } else {
            int remainder = firstLineDelta - length;
            String remDelim = node.delimiter;
            int firstLength = info.delimiterIndex + info.delimiterLength;
            int delta = firstLength - firstLineDelta;
            this.updateLength(node, delta);
            node.delimiter = info.delimiter;
            int[] consumed = new int[1];
            node = this.addLines(node, text, firstLength, consumed);
            this.insertAfter(node, remainder + text.length() - consumed[0], remDelim);
        }
    }

    private void replaceFromTo(Node node, Node last, String text, int length, int firstLineDelta) {
        DelimiterInfo info;
        Node successor = this.successor(node);
        while (successor != last) {
            length -= successor.length;
            Node toDelete = successor;
            successor = this.successor(successor);
            this.updateLength(toDelete, -toDelete.length);
        }
        DelimiterInfo delimiterInfo = info = text == null ? null : this.nextDelimiterInfo(text, 0);
        if (info == null || info.delimiter == null) {
            int added = text == null ? 0 : text.length();
            this.join(node, last, added - length);
        } else {
            int firstLength = info.delimiterIndex + info.delimiterLength;
            this.updateLength(node, firstLength - firstLineDelta);
            node.delimiter = info.delimiter;
            int[] consumed = new int[1];
            this.addLines(node, text, firstLength, consumed);
            this.updateLength(last, text.length() - consumed[0] - (length -= firstLineDelta));
        }
    }

    private Node addLines(Node node, String text, int offset, int[] consumed) {
        DelimiterInfo info = this.nextDelimiterInfo(text, offset);
        while (info != null) {
            int length = info.delimiterIndex - offset + info.delimiterLength;
            node = this.insertAfter(node, length, info.delimiter);
            info = this.nextDelimiterInfo(text, offset += length);
        }
        consumed[0] = offset;
        return node;
    }

    private void join(Node one, Node two, int delta) {
        int oneLength = one.length;
        this.updateLength(one, -oneLength);
        this.updateLength(two, oneLength + delta);
    }

    private void updateLength(Node node, int delta) {
        node.length += delta;
        boolean delete = node.length == 0 && node.delimiter != NO_DELIM;
        int lineDelta = delete ? -1 : 0;
        if (delta != 0 || lineDelta != 0) {
            this.updateParentChain(node, delta, lineDelta);
        }
        if (delete) {
            this.delete(node);
        }
    }

    private void updateParentChain(Node node, int deltaLength, int deltaLines) {
        this.updateParentChain(node, null, deltaLength, deltaLines);
    }

    private void updateParentChain(Node from, Node to, int deltaLength, int deltaLines) {
        Node parent = from.parent;
        while (parent != to) {
            if (from == parent.left) {
                parent.offset += deltaLength;
                parent.line += deltaLines;
            }
            from = parent;
            parent = from.parent;
        }
    }

    private void delete(Node node) {
        boolean lostLeftChild;
        Node toUpdate;
        boolean isLeftChild;
        Node parent = node.parent;
        boolean bl = isLeftChild = parent == null || node == parent.left;
        if (node.left == null || node.right == null) {
            Node replacement = node.left == null ? node.right : node.left;
            this.setChild(parent, replacement, isLeftChild);
            toUpdate = parent;
            lostLeftChild = isLeftChild;
        } else if (node.right.left == null) {
            Node replacement = node.right;
            this.setChild(parent, replacement, isLeftChild);
            this.setChild(replacement, node.left, true);
            replacement.line = node.line;
            replacement.offset = node.offset;
            replacement.balance = node.balance;
            toUpdate = replacement;
            lostLeftChild = false;
        } else {
            Node successor = this.successor(node);
            toUpdate = successor.parent;
            lostLeftChild = true;
            this.updateParentChain(successor, node, -successor.length, -1);
            this.setChild(toUpdate, successor.right, true);
            this.setChild(successor, node.right, false);
            this.setChild(successor, node.left, true);
            this.setChild(parent, successor, isLeftChild);
            successor.line = node.line;
            successor.offset = node.offset;
            successor.balance = node.balance;
        }
        this.updateParentBalanceAfterDeletion(toUpdate, lostLeftChild);
    }

    private void updateParentBalanceAfterDeletion(Node node, boolean wasLeftChild) {
        while (node != null) {
            node.balance = wasLeftChild ? (byte)(node.balance + 1) : (byte)(node.balance - 1);
            Node parent = node.parent;
            if (parent != null) {
                wasLeftChild = node == parent.left;
            }
            switch (node.balance) {
                case -1: 
                case 1: {
                    return;
                }
                case -2: {
                    if (!this.rebalanceAfterDeletionRight(node.left)) break;
                    return;
                }
                case 2: {
                    if (!this.rebalanceAfterDeletionLeft(node.right)) break;
                    return;
                }
            }
            node = parent;
        }
    }

    private boolean rebalanceAfterDeletionLeft(Node node) {
        Node parent = node.parent;
        if (node.balance == 1) {
            this.singleLeftRotation(node, parent);
            return false;
        }
        if (node.balance == -1) {
            this.rightLeftRotation(node, parent);
            return false;
        }
        if (node.balance == 0) {
            this.rotateLeft(parent);
            node.balance = (byte)-1;
            parent.balance = 1;
            return true;
        }
        return true;
    }

    private boolean rebalanceAfterDeletionRight(Node node) {
        Node parent = node.parent;
        if (node.balance == -1) {
            this.singleRightRotation(node, parent);
            return false;
        }
        if (node.balance == 1) {
            this.leftRightRotation(node, parent);
            return false;
        }
        if (node.balance == 0) {
            this.rotateRight(parent);
            node.balance = 1;
            parent.balance = (byte)-1;
            return true;
        }
        return true;
    }

    private Node successor(Node node) {
        if (node.right != null) {
            return this.successorDown(node.right);
        }
        return this.successorUp(node);
    }

    private Node successorUp(Node node) {
        Node child = node;
        Node parent = child.parent;
        while (parent != null) {
            if (child == parent.left) {
                return parent;
            }
            child = parent;
            parent = child.parent;
        }
        return null;
    }

    private Node successorDown(Node node) {
        Node child = node.left;
        while (child != null) {
            node = child;
            child = node.left;
        }
        return node;
    }

    private void fail(int offset) throws BadLocationException {
        throw new BadLocationException();
    }

    protected abstract DelimiterInfo nextDelimiterInfo(String var1, int var2);

    public String getLineDelimiter(int line) throws BadLocationException {
        this.checkRewriteSession();
        Node node = this.nodeByLine(line);
        return node.delimiter == NO_DELIM ? null : node.delimiter;
    }

    public int computeNumberOfLines(String text) {
        int count = 0;
        int start = 0;
        DelimiterInfo delimiterInfo = this.nextDelimiterInfo(text, start);
        while (delimiterInfo != null && delimiterInfo.delimiterIndex > -1) {
            ++count;
            start = delimiterInfo.delimiterIndex + delimiterInfo.delimiterLength;
            delimiterInfo = this.nextDelimiterInfo(text, start);
        }
        return count;
    }

    public int getNumberOfLines() {
        try {
            this.checkRewriteSession();
        }
        catch (BadLocationException badLocationException) {}
        Node node = this.fRoot;
        int lines = 0;
        while (node != null) {
            lines += node.line + 1;
            node = node.right;
        }
        return lines;
    }

    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        this.checkRewriteSession();
        if (length == 0) {
            return 1;
        }
        this.nodeByOffset(offset);
        int startLine = this.lineHint;
        this.nodeByOffset(offset + length);
        int endLine = this.lineHint;
        return endLine - startLine + 1;
    }

    public int getLineOffset(int line) throws BadLocationException {
        this.checkRewriteSession();
        this.nodeByLine(line);
        return this.offsetHint;
    }

    public int getLineLength(int line) throws BadLocationException {
        this.checkRewriteSession();
        Node node = this.nodeByLine(line);
        return node.length;
    }

    public int getLineNumberOfOffset(int offset) throws BadLocationException {
        this.checkRewriteSession();
        this.nodeByOffset(offset);
        return this.lineHint;
    }

    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        this.checkRewriteSession();
        Node node = this.nodeByOffset(offset);
        return new Region(this.offsetHint, node.pureLength());
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        this.checkRewriteSession();
        try {
            Node node = this.nodeByLine(line);
            return new Region(this.offsetHint, node.pureLength());
        }
        catch (BadLocationException x) {
            if (line > 0 && line == this.getNumberOfLines()) {
                Node last = this.nodeByLine(line - 1);
                if (last.length > 0) {
                    return new Region(this.offsetHint + last.length, 0);
                }
            }
            throw x;
        }
    }

    public void set(String text) {
        if (this.hasActiveRewriteSession()) {
            this.fPendingRequests.clear();
            this.fPendingRequests.add(new Request(text));
            return;
        }
        this.fRoot = new Node(0, NO_DELIM);
        try {
            this.replace(0, 0, text);
        }
        catch (BadLocationException badLocationException) {
            throw new InternalError();
        }
    }

    public final void startRewriteSession(DocumentRewriteSession session) {
        if (this.fActiveRewriteSession != null) {
            throw new IllegalStateException();
        }
        this.fActiveRewriteSession = session;
        this.fPendingRequests = new ArrayList(20);
    }

    public final void stopRewriteSession(DocumentRewriteSession session, String text) {
        if (this.fActiveRewriteSession == session) {
            this.fActiveRewriteSession = null;
            this.fPendingRequests = null;
            this.set(text);
        }
    }

    protected final boolean hasActiveRewriteSession() {
        return this.fActiveRewriteSession != null;
    }

    protected final void flushRewriteSession() throws BadLocationException {
        Iterator e = this.fPendingRequests.iterator();
        this.fPendingRequests = null;
        this.fActiveRewriteSession = null;
        while (e.hasNext()) {
            Request request = (Request)e.next();
            if (request.isReplaceRequest()) {
                this.replace(request.offset, request.length, request.text);
                continue;
            }
            this.set(request.text);
        }
    }

    protected final void checkRewriteSession() throws BadLocationException {
        if (this.hasActiveRewriteSession()) {
            this.flushRewriteSession();
        }
    }

    public String toString() {
        int depth = this.computeDepth(this.fRoot);
        int WIDTH = 30;
        int leaves = (int)Math.pow(2.0, depth - 1);
        int width = WIDTH * leaves;
        String empty = ".";
        LinkedList<Node> roots = new LinkedList<Node>();
        roots.add(this.fRoot);
        StringBuffer buf = new StringBuffer((width + 1) * depth);
        int nodes = 1;
        int indents = leaves;
        char[] space = new char[leaves * WIDTH / 2];
        Arrays.fill(space, ' ');
        int d = 0;
        while (d < depth) {
            int spaces = Math.max(0, (indents /= 2) * WIDTH - WIDTH / 2);
            ListIterator<Node> it = roots.listIterator();
            while (it.hasNext()) {
                String box;
                buf.append(space, 0, spaces);
                Node node = (Node)it.next();
                if (node == null) {
                    it.add(null);
                    box = empty;
                } else {
                    it.set(node.left);
                    it.add(node.right);
                    box = node.toString();
                }
                int pad_left = (WIDTH - box.length() + 1) / 2;
                int pad_right = WIDTH - box.length() - pad_left;
                buf.append(space, 0, pad_left);
                buf.append(box);
                buf.append(space, 0, pad_right);
                buf.append(space, 0, spaces);
            }
            buf.append('\n');
            nodes *= 2;
            ++d;
        }
        return buf.toString();
    }

    private byte computeDepth(Node root) {
        if (root == null) {
            return 0;
        }
        return (byte)(Math.max(this.computeDepth(root.left), this.computeDepth(root.right)) + 1);
    }

    private void checkTree() {
        this.checkTreeStructure(this.fRoot);
        try {
            this.checkTreeOffsets(this.nodeByOffset(0), new int[2], null);
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError();
        }
    }

    private byte checkTreeStructure(Node node) {
        if (node == null) {
            return 0;
        }
        byte leftDepth = this.checkTreeStructure(node.left);
        byte rightDepth = this.checkTreeStructure(node.right);
        Assert.isTrue(node.balance == rightDepth - leftDepth);
        Assert.isTrue(node.left == null || node.left.parent == node);
        Assert.isTrue(node.right == null || node.right.parent == node);
        return (byte)(Math.max(rightDepth, leftDepth) + 1);
    }

    private int[] checkTreeOffsets(Node node, int[] offLen, Node last) {
        if (node == last) {
            return offLen;
        }
        Assert.isTrue(node.offset == offLen[0]);
        Assert.isTrue(node.line == offLen[1]);
        if (node.right != null) {
            int[] result = this.checkTreeOffsets(this.successorDown(node.right), new int[2], node);
            offLen[0] = offLen[0] + result[0];
            offLen[1] = offLen[1] + result[1];
        }
        offLen[0] = offLen[0] + node.length;
        offLen[1] = offLen[1] + 1;
        return this.checkTreeOffsets(node.parent, offLen, last);
    }

    protected static class DelimiterInfo {
        public int delimiterIndex;
        public int delimiterLength;
        public String delimiter;

        protected DelimiterInfo() {
        }
    }

    private static final class Node {
        int line;
        int offset;
        int length;
        String delimiter;
        Node parent;
        Node left;
        Node right;
        byte balance;

        Node(int length, String delimiter) {
            this.length = length;
            this.delimiter = delimiter;
        }

        public String toString() {
            String bal;
            switch (this.balance) {
                case 0: {
                    bal = "=";
                    break;
                }
                case 1: {
                    bal = "+";
                    break;
                }
                case 2: {
                    bal = "++";
                    break;
                }
                case -1: {
                    bal = "-";
                    break;
                }
                case -2: {
                    bal = "--";
                    break;
                }
                default: {
                    bal = Integer.toString(this.balance);
                }
            }
            return "[" + this.offset + "+" + this.pureLength() + "+" + this.delimiter.length() + "|" + this.line + "|" + bal + "]";
        }

        int pureLength() {
            return this.length - this.delimiter.length();
        }
    }

    protected static class Request {
        public final int offset;
        public final int length;
        public final String text;

        public Request(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public Request(String text) {
            this.offset = -1;
            this.length = -1;
            this.text = text;
        }

        public boolean isReplaceRequest() {
            return this.offset > -1 && this.length > -1;
        }
    }
}

