/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.Document;
import org.eclipse.epf.publishing.services.index.FontObject;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWord;
import org.eclipse.epf.publishing.services.index.KeyWordDef;
import org.eclipse.epf.publishing.services.index.KeyWordFile;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;

public class KeyWordHolder {
    private Vector keyWordFiles = new Vector();
    private Vector keyWords = null;

    public void add(KeyWordFile key) {
        this.keyWordFiles.addElement(key);
    }

    public void divide() {
        if (this.keyWordFiles != null) {
            int i = 0;
            while (i < this.keyWordFiles.size()) {
                String nextKeyWord = "";
                KeyWordFile tmp = (KeyWordFile)this.keyWordFiles.elementAt(i);
                while (nextKeyWord != null) {
                    nextKeyWord = null;
                    KeyWordDef def = tmp.getNextKeyWord();
                    if (def != null) {
                        nextKeyWord = def.toString();
                    }
                    if (nextKeyWord == null) continue;
                    int noOfDoc = 1;
                    Document tmpD = tmp.getDocument(nextKeyWord, noOfDoc);
                    while (tmpD != null) {
                        KeyWord tmpK;
                        int index = MiscStatic.getIndex(nextKeyWord, KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
                        if (index == -1) {
                            index = nextKeyWord.length();
                        }
                        if ((tmpK = this.createKeyWord(def)) != null && tmpD != null) {
                            tmpK.addKeyWord(def, nextKeyWord, tmpD);
                        }
                        tmpD = tmp.getDocument(nextKeyWord, ++noOfDoc);
                    }
                }
                ++i;
            }
        }
    }

    private KeyWord createKeyWord(KeyWordDef def) {
        if (this.keyWords == null) {
            this.keyWords = new Vector();
            KeyWord newKeyWord = new KeyWord(def);
            this.keyWords.addElement(newKeyWord);
            return newKeyWord;
        }
        int index = -1;
        int i = 0;
        KeyWord newKeyWord2 = new KeyWord(def);
        String str2 = newKeyWord2.getKeyWord();
        while (index == -1 && i < this.keyWords.size()) {
            KeyWord tmpK = (KeyWord)this.keyWords.elementAt(i);
            String str = tmpK.getKeyWord();
            int cmp = str2.toUpperCase().compareTo(str.toUpperCase());
            if (cmp < 0) {
                index = i;
            } else if (cmp == 0) {
                int cmp2 = str2.compareTo(str);
                if (cmp2 != 0) {
                    index = cmp2 > 0 ? i : i - 1;
                } else {
                    return tmpK;
                }
            }
            ++i;
        }
        if (index != -1) {
            this.keyWords.insertElementAt(newKeyWord2, index);
        } else {
            this.keyWords.insertElementAt(newKeyWord2, this.keyWords.size());
        }
        return newKeyWord2;
    }

    public void readSpecKeyWords(StringTokenizer parser) {
        while (parser.hasMoreTokens()) {
            String specKeyWordString = parser.nextToken().trim();
            String relatedKeyWord = parser.nextToken().trim();
            KeyWordDef specKeyDef = new KeyWordDef(specKeyWordString);
            new KeyWordDef(relatedKeyWord);
            specKeyWordString = specKeyDef.toString();
            relatedKeyWord = relatedKeyWord.toString();
            if (specKeyWordString == null || relatedKeyWord == null || !this.relatedKeyWordExists(specKeyWordString, relatedKeyWord)) continue;
            boolean found = false;
            int i = 0;
            String firstKeyWord = specKeyWordString;
            int pos = specKeyWordString.indexOf(KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
            if (pos != -1) {
                firstKeyWord = specKeyWordString.substring(0, pos);
            }
            IO.printDebug("firstKeyWord " + firstKeyWord);
            while (!found && i < this.keyWords.size()) {
                IO.printDebug("holder in first while " + i);
                KeyWord tmpK = (KeyWord)this.keyWords.elementAt(i);
                if (firstKeyWord.equals(tmpK.getKeyWord())) {
                    found = true;
                    if (pos != -1) {
                        tmpK.insertSpecKeyWord(specKeyWordString.substring(pos + 1), relatedKeyWord);
                    } else {
                        tmpK.setSpecKeyWord(relatedKeyWord, false);
                    }
                }
                ++i;
            }
            if (found) continue;
            IO.printDebug("!found");
            int index = -1;
            i = 0;
            KeyWord newKeyWord2 = new KeyWord(specKeyDef);
            if (pos == -1) {
                newKeyWord2.setSpecKeyWord(relatedKeyWord, true);
            } else {
                newKeyWord2.insertSpecKeyWord(specKeyWordString.substring(pos + 1), relatedKeyWord);
            }
            while (index == -1 && i < this.keyWords.size()) {
                IO.printDebug("holder in second while " + i);
                KeyWord tmpK = (KeyWord)this.keyWords.elementAt(i);
                if (newKeyWord2.getKeyWord().toUpperCase().compareTo(tmpK.getKeyWord().toUpperCase()) < 0) {
                    index = i;
                } else if (newKeyWord2.getKeyWord().toUpperCase().compareTo(tmpK.getKeyWord().toUpperCase()) == 0 && newKeyWord2.getKeyWord().compareTo(tmpK.getKeyWord()) != 0) {
                    index = newKeyWord2.getKeyWord().compareTo(tmpK.getKeyWord()) > 0 ? i : i - 1;
                }
                ++i;
            }
            if (index != -1) {
                this.keyWords.insertElementAt(newKeyWord2, index);
                continue;
            }
            this.keyWords.insertElementAt(newKeyWord2, this.keyWords.size());
        }
    }

    private boolean relatedKeyWordExists(String specKeyWordString, String relatedKeyWord) {
        if (this.keyWords != null) {
            int i = 0;
            while (i < this.keyWords.size()) {
                KeyWord tmpK = (KeyWord)this.keyWords.elementAt(i);
                if (tmpK.getKeyWord().equals(relatedKeyWord)) {
                    return true;
                }
                ++i;
            }
        }
        System.err.println(String.valueOf(relatedKeyWord) + HelpMessages.RELATED_KEYWORD_NOT_FOUND + specKeyWordString);
        return false;
    }

    public void print() {
        if (KeyWordIndexHelper.defObj.getIndexResultFile() != null) {
            this.printFrameset();
            this.printIndex();
        }
        this.printKeyWords();
    }

    private void printFrameset() {
        try {
            File file = new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getMainResultFile());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter outP = KeyWordIndexHelper.defObj.getCharacterSet() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), KeyWordIndexHelper.defObj.getCharacterSet()) : new OutputStreamWriter(new FileOutputStream(file));
            System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + KeyWordIndexHelper.defObj.getWwwRoot() + KeyWordIndexHelper.defObj.getMainResultFile());
            MiscStatic.print(outP, "<HTML>\n");
            MiscStatic.print(outP, "<head>\n");
            MiscStatic.print(outP, "<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
            MiscStatic.print(outP, "<title>" + KeyWordIndexHelper.defObj.getIndexTitle() + "</title>\n");
            MiscStatic.print(outP, "</head>\n");
            new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getKeywordResultFile());
            String keyWordPath = String.valueOf(KeyWordIndexHelper.defObj.getRelativePath()) + KeyWordIndexHelper.defObj.getKeywordResultFile();
            new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getIndexResultFile());
            String indexPath = String.valueOf(KeyWordIndexHelper.defObj.getRelativePath()) + KeyWordIndexHelper.defObj.getIndexResultFile();
            MiscStatic.print(outP, "<frameset rows=\"" + KeyWordIndexHelper.defObj.getIndexHeight() + ",*\">\n");
            MiscStatic.print(outP, "<frame name=\"" + KeyWordIndexHelper.defObj.getIndexTarget() + "\" title=\"Navigation bar\" src=\"" + indexPath + "\" marginheight=\"2\" marginwidth=\"2\" scrolling=\"auto\">\n");
            MiscStatic.print(outP, "<frame name=\"" + KeyWordIndexHelper.defObj.getKeyWordTarget() + "\" title=\"Contents\" src=\"" + keyWordPath + "\" marginheight=\"0\" marginwidth=\"2\" scrolling=\"auto\">\n");
            MiscStatic.print(outP, "</frameset>\n");
            MiscStatic.print(outP, "</HTML>");
            outP.close();
        }
        catch (Exception e) {
            System.err.println("KeyWordHolder:printFrameset\n" + HelpMessages.EXCEPTION + e.toString());
        }
    }

    private void printIndex() {
        try {
            File file = new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getIndexResultFile());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter outP = KeyWordIndexHelper.defObj.getCharacterSet() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), KeyWordIndexHelper.defObj.getCharacterSet()) : new OutputStreamWriter(new FileOutputStream(file));
            System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + KeyWordIndexHelper.defObj.getWwwRoot() + KeyWordIndexHelper.defObj.getIndexResultFile());
            MiscStatic.print(outP, "<HTML>\n");
            MiscStatic.print(outP, "<head>\n");
            MiscStatic.print(outP, "<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
            MiscStatic.print(outP, "</head><BODY>\n");
            String beginChar = "";
            if (this.keyWords != null) {
                new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getKeywordResultFile());
                String path = String.valueOf(KeyWordIndexHelper.defObj.getRelativePath()) + KeyWordIndexHelper.defObj.getKeywordResultFile();
                int i = 0;
                while (i < this.keyWords.size()) {
                    KeyWord tmp = (KeyWord)this.keyWords.elementAt(i);
                    String firstL = tmp.getKeyWord().substring(0, 1).toUpperCase();
                    if (firstL.compareTo(beginChar) != 0) {
                        beginChar = firstL;
                        MiscStatic.print(outP, "<A HREF=\"" + path + "#");
                        MiscStatic.print(outP, beginChar);
                        MiscStatic.print(outP, "\" TARGET=\"" + KeyWordIndexHelper.defObj.getKeyWordTarget() + "\">");
                        MiscStatic.print(outP, beginChar);
                        MiscStatic.print(outP, "</A>\n");
                    }
                    ++i;
                }
            }
            MiscStatic.print(outP, "</BODY></HTML>");
            outP.close();
        }
        catch (Exception e) {
            System.err.println("KeyWordHolder:printIndex\n" + HelpMessages.EXCEPTION + e.toString());
        }
    }

    private void printKeyWords() {
        try {
            String footerFile;
            File file = new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getKeywordResultFile());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter outP = KeyWordIndexHelper.defObj.getCharacterSet() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), KeyWordIndexHelper.defObj.getCharacterSet()) : new OutputStreamWriter(new FileOutputStream(file));
            System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + KeyWordIndexHelper.defObj.getWwwRoot() + KeyWordIndexHelper.defObj.getKeywordResultFile());
            String headerFile = MiscStatic.loadFile(KeyWordIndexHelper.defObj.getHeaderFile(), KeyWordIndexHelper.defObj.getCharacterSet());
            if (headerFile.equalsIgnoreCase(Def.None)) {
                System.err.println(String.valueOf(HelpMessages.INCORRECT_HEADERFILE) + KeyWordIndexHelper.defObj.getHeaderFile());
            }
            MiscStatic.print(outP, headerFile);
            String beginChar = "";
            if (this.keyWords != null) {
                int i = 0;
                while (i < this.keyWords.size()) {
                    KeyWord tmp = (KeyWord)this.keyWords.elementAt(i);
                    String firstL = tmp.getKeyWord().substring(0, 1).toUpperCase();
                    if (firstL.compareTo(beginChar) != 0) {
                        beginChar = firstL;
                        FontObject fs = KeyWordIndexHelper.defObj.getStyleSheet(Def.HeadLineStyle);
                        if (fs == null) {
                            fs = KeyWordIndexHelper.defObj.getStyleSheet(Def.DefaultStyle);
                        }
                        FontObject f = null;
                        FontObject fr = fs;
                        if (fs == null) {
                            f = KeyWordIndexHelper.defObj.getFont(Def.HeadLineFont);
                            if (f == null) {
                                f = KeyWordIndexHelper.defObj.getFont(Def.DefaultFont);
                            }
                            fr = f;
                        }
                        KeyWordIndexHelper.defObj.printStart(outP, fr);
                        if (fs == null) {
                            MiscStatic.print(outP, "<BR>");
                        }
                        MiscStatic.print(outP, "<A NAME=\"" + beginChar + "\">" + beginChar + "</A>");
                        if (fs == null) {
                            MiscStatic.print(outP, "<BR>");
                        }
                        KeyWordIndexHelper.defObj.printEnd(outP, fr);
                    }
                    tmp.print(outP, 0);
                    ++i;
                }
            }
            if ((footerFile = MiscStatic.loadFile(KeyWordIndexHelper.defObj.getFooterFile(), KeyWordIndexHelper.defObj.getCharacterSet())).equalsIgnoreCase(Def.None)) {
                System.err.println(String.valueOf(HelpMessages.INCORRECT_FOOTERFILE) + KeyWordIndexHelper.defObj.getFooterFile());
            }
            MiscStatic.print(outP, footerFile);
            outP.close();
        }
        catch (Exception e) {
            System.err.println("KeyWordHolder:printKeyWords\n" + HelpMessages.EXCEPTION + e.toString());
            e.printStackTrace();
        }
    }
}

