/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.DefinitionObject;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWordFile;
import org.eclipse.epf.publishing.services.index.KeyWordHolder;
import org.eclipse.epf.publishing.services.index.KeyWordIndexException;
import org.eclipse.epf.publishing.services.index.KeyWordStatic;
import org.eclipse.epf.publishing.services.index.MiscStatic;
import org.eclipse.epf.publishing.services.index.StringDefinitions;

public class KeyWordIndexHelper {
    public KeyWordHolder holder = new KeyWordHolder();
    public static DefinitionObject defObj = null;
    private static String deffile = null;
    private static String charSet = null;
    private static String helpFile = null;

    public KeyWordIndexHelper() {
        deffile = null;
    }

    public KeyWordIndexHelper(String pDeffile, String pCharSet, String pHelpFile) {
        deffile = pDeffile;
        charSet = pCharSet;
        helpFile = pHelpFile;
    }

    public void setDeffile(String pFile) {
        deffile = pFile;
    }

    public void setCharSet(String pCharSet) {
        charSet = pCharSet;
    }

    public void setHelpFile(String pHelpFile) {
        helpFile = pHelpFile;
    }

    public DefinitionObject loadDefinition(String pubDir) throws Exception {
        if (deffile == null) {
            throw new KeyWordIndexException("KeyWordIndexHelper:execute()", StringDefinitions.ERROR_DEFINITION_FILE_NOT_FOUND);
        }
        if (helpFile != null) {
            HelpMessages.loadHelpMessages(helpFile, charSet);
        }
        defObj = new DefinitionObject(pubDir, deffile, charSet);
        return defObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(IProgressMonitor monitor) throws KeyWordIndexException {
        if (monitor.isCanceled()) {
            return;
        }
        if (!defObj.enoughInput()) throw new KeyWordIndexException("KeyWordIndexHelper:execute()", HelpMessages.NOT_ENOUGH_INPUT);
        File topDir = new File(defObj.getWwwRoot());
        if (!topDir.isDirectory()) {
            throw new KeyWordIndexException("KeyWordIndexHelper:execute()", String.valueOf(Def.StartDir) + ": " + defObj.getWwwRoot() + HelpMessages.NO_DIRECTORY);
        }
        System.out.println(String.valueOf(HelpMessages.PARSE_DIRECTORY) + defObj.getWwwRoot());
        System.out.println(HelpMessages.TAKE_A_WHILE);
        this.readDir(topDir, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        this.holder.divide();
        String specKeyWordsFile = defObj.getKeyWordFile();
        if (specKeyWordsFile != null) {
            String specKeyWords = MiscStatic.loadFile(specKeyWordsFile, defObj.getCharacterSet());
            if (specKeyWords.equals(Def.None)) throw new KeyWordIndexException("KeyWordIndexHelper:execute()", String.valueOf(specKeyWordsFile) + HelpMessages.KEYWORD_FILE_SYNTAX_ERROR);
            StringTokenizer parser = new StringTokenizer(specKeyWords, "\t\n");
            this.holder.readSpecKeyWords(parser);
        }
        this.holder.print();
    }

    private void readDir(File file, IProgressMonitor monitor) {
        String[] files = file.list();
        int i = 0;
        while (i < files.length) {
            if (monitor.isCanceled()) {
                return;
            }
            String filePath = file.getAbsolutePath();
            try {
                filePath = file.getCanonicalPath();
            }
            catch (Exception e) {
                System.out.println("KeyWordIndexHelper:readDir\n" + HelpMessages.EXCEPTION + e.toString());
            }
            filePath = filePath.replace('\\', '/');
            File tmp = new File(String.valueOf(filePath) + "/" + files[i]);
            if (tmp.isDirectory()) {
                String tmpPath = tmp.getAbsolutePath();
                try {
                    tmpPath = tmp.getCanonicalPath();
                }
                catch (Exception e) {
                    System.out.println("KeyWordIndexHelper:readDir\n" + HelpMessages.EXCEPTION + e.toString());
                }
                tmpPath = tmpPath.replace('\\', '/');
                if (!defObj.isInStopdir(tmpPath)) {
                    this.readDir(tmp, monitor);
                    if (monitor.isCanceled()) {
                        return;
                    }
                } else {
                    try {
                        System.out.println(String.valueOf(HelpMessages.DIRECTORY_NOT_PARSED) + tmp.getCanonicalPath());
                    }
                    catch (Exception e) {
                        System.out.println("KeyWordIndexHelper:readDir\n" + HelpMessages.EXCEPTION + e.toString());
                    }
                }
            } else if (files[i].endsWith(".htm") || files[i].endsWith(".html") || files[i].endsWith(".shtml") || files[i].endsWith(".shtm")) {
                this.loadFile(String.valueOf(file.getAbsolutePath()) + "/" + files[i]);
            }
            ++i;
        }
    }

    private void loadFile(String fileName) {
        List keyWord;
        String htmlFile = MiscStatic.loadFile(fileName, defObj.getCharacterSet());
        if (htmlFile != null && htmlFile.length() > 0 && (keyWord = KeyWordStatic.getKeyWords(htmlFile)) != null && keyWord.size() > 0) {
            IO.printDebug("keyword " + keyWord);
            String title = MiscStatic.getTitle(htmlFile);
            this.holder.add(new KeyWordFile(title, String.valueOf(defObj.getRelativePath()) + fileName.substring(defObj.getWwwRootLength()), keyWord));
        }
    }
}

