/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PublishConfigSelectProcessPage
extends BaseWizardPage
implements Listener {
    private Button radio_entireConfig;
    private Button radio_processes;
    private Composite processContainer;
    Map checkBoxTpProcMap = new HashMap();
    CheckboxTreeViewer procViewer;
    private PublishOptions dataModel = null;

    public PublishConfigSelectProcessPage(String pageName, PublishOptions dataModel) {
        super(pageName);
        this.setTitle(PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.title"));
        this.setDescription(PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.text"));
        this.dataModel = dataModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(composite, PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.label_selectType"));
        this.radio_entireConfig = this.createRadioButton(composite, PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.label_type_config"), 1, true);
        this.radio_processes = this.createRadioButton(composite, PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.label_type_processes"), 1, false);
        this.processContainer = new Composite(composite, 0);
        this.processContainer.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginLeft = 13;
        this.processContainer.setLayout((Layout)layout);
        LibraryProcessor lp = LibraryProcessor.getInstance();
        String selecedConfigName = this.dataModel.getSelectedConfig();
        lp.getConfiguration(selecedConfigName);
        this.createTreeViewer(this.processContainer);
        this.radio_entireConfig.addListener(13, (Listener)this);
        this.radio_processes.addListener(13, (Listener)this);
        this.processContainer.setVisible(this.radio_processes.getSelection());
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private void createTreeViewer(Composite parent) {
        this.procViewer = new CheckboxTreeViewer(parent);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.procViewer.getTree().setLayoutData((Object)gridData);
        this.procViewer.setContentProvider((IContentProvider)new ProcessContentProvider());
        this.procViewer.setLabelProvider((IBaseLabelProvider)new ProcessLabelProvider());
        this.procViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                PublishConfigSelectProcessPage.this.updateCheckStates(event.getElement(), checked);
                PublishConfigSelectProcessPage.this.setPageComplete(PublishConfigSelectProcessPage.this.isPageComplete());
                PublishConfigSelectProcessPage.this.getWizard().getContainer().updateButtons();
            }
        });
        LibraryProcessor lp = LibraryProcessor.getInstance();
        String selecedConfigName = this.dataModel.getSelectedConfig();
        MethodConfiguration config = lp.getConfiguration(selecedConfigName);
        this.procViewer.setInput((Object)config);
        this.procViewer.expandAll();
    }

    private void updateCheckStates(Object element, boolean checked) {
        if (checked) {
            ITreeContentProvider cp = (ITreeContentProvider)this.procViewer.getContentProvider();
            this.checkParent(cp, element);
        } else {
            this.procViewer.setChecked(element, false);
        }
        this.selectionChildren(element, checked);
    }

    private void checkParent(ITreeContentProvider cp, Object element) {
    }

    public void selectionChildren(Object element, boolean checked) {
        ITreeContentProvider cp = (ITreeContentProvider)this.procViewer.getContentProvider();
        Object[] childs = cp.getChildren(element);
        int i = 0;
        while (i < childs.length) {
            this.procViewer.setChecked(childs[i], checked);
            this.selectionChildren(childs[i], checked);
            ++i;
        }
    }

    public void handleEvent(Event event) {
        this.processContainer.setVisible(this.radio_processes.getSelection());
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        this.dataModel.publishProcess = false;
        if (this.radio_entireConfig.getSelection()) {
            this.dataModel.publishConfiguration = true;
            return true;
        }
        ArrayList<Object> procs = new ArrayList<Object>();
        Object[] selected = this.procViewer.getCheckedElements();
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (selected[i] instanceof Process) {
                    procs.add(selected[i]);
                }
                ++i;
            }
        }
        if (procs.size() > 0) {
            this.dataModel.publishProcess = true;
            this.dataModel.publishConfiguration = false;
            this.dataModel.setDeliverProcessList(procs);
            return true;
        }
        return false;
    }

    public class ProcessContentProvider
    implements ITreeContentProvider {
        MethodConfiguration input = null;
        String NODE_CP = PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.label_capability_pattern");
        String NODE_DP = PublishingUIResources.getString("PublishingUI.PublishConfigSelectProcessPage.label_delivery_process");
        String[] DPCP_NODES = new String[]{this.NODE_CP, this.NODE_DP};
        Map pluginNodeMap = new HashMap();

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MethodConfiguration) {
                return this.DPCP_NODES;
            }
            if (this.NODE_CP.equals(parentElement.toString()) || this.NODE_DP.equals(parentElement.toString())) {
                return this.getPlugins(parentElement).toArray();
            }
            if (parentElement instanceof PluginNode) {
                Object parent = ((PluginNode)parentElement).parent;
                if (this.NODE_CP.equals(parent.toString())) {
                    return ConfigurationHelper.getAllCapabilityPatterns((MethodPlugin)((PluginNode)parentElement).plugin, (MethodConfiguration)this.input).toArray();
                }
                if (this.NODE_DP.equals(parent.toString())) {
                    return ConfigurationHelper.getAllDeliveryProcesses((MethodPlugin)((PluginNode)parentElement).plugin, (MethodConfiguration)this.input).toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            if (element instanceof PluginNode) {
                return ((PluginNode)element).parent;
            }
            if (element instanceof Process) {
                EObject o = (EObject)element;
                while (o != null && !(o instanceof MethodPlugin)) {
                    o = o.eContainer();
                }
                return o;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PluginNode || element instanceof String;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.pluginNodeMap.clear();
            this.input = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput instanceof MethodConfiguration ? (MethodConfiguration)newInput : null;
            this.pluginNodeMap.clear();
        }

        private List getPlugins(Object parent) {
            ArrayList<PluginNode> validItems = new ArrayList<PluginNode>();
            if (this.input != null) {
                List plugins = this.input.getMethodPluginSelection();
                Iterator it = plugins.iterator();
                while (it.hasNext()) {
                    MethodPlugin plugin = (MethodPlugin)it.next();
                    List procs = null;
                    if (this.NODE_CP.equals(parent.toString())) {
                        procs = ConfigurationHelper.getAllCapabilityPatterns((MethodPlugin)plugin, (MethodConfiguration)this.input);
                    } else if (this.NODE_DP.equals(parent.toString())) {
                        procs = ConfigurationHelper.getAllDeliveryProcesses((MethodPlugin)plugin, (MethodConfiguration)this.input);
                    }
                    if (procs == null || procs.size() <= 0) continue;
                    validItems.add(this.getPluginNode(parent, plugin));
                }
            }
            return validItems;
        }

        private PluginNode getPluginNode(Object parent, MethodPlugin plugin) {
            String key = String.valueOf(parent.toString()) + ":" + plugin.getName();
            PluginNode node = (PluginNode)this.pluginNodeMap.get(key);
            if (node == null) {
                node = new PluginNode(parent, plugin);
                this.pluginNodeMap.put(key, node);
            }
            return node;
        }

        class PluginNode {
            Object parent;
            MethodPlugin plugin;

            public PluginNode(Object parent, MethodPlugin plugin) {
                this.parent = parent;
                this.plugin = plugin;
            }

            public String toString() {
                return this.plugin.getName();
            }
        }
    }

    public class ProcessLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Process) {
                Process proc = (Process)element;
                return TngUtil.getPresentationName((Object)proc);
            }
            return element == null ? "" : element.toString();
        }
    }
}

