/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.File;
import java.util.TreeSet;
import org.eclipse.core.internal.preferences.OSGiPreferencesServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OSGiPreferencesServiceManager
implements ServiceFactory,
BundleListener {
    private static final String OSGI_PREFS_DIR = "OSGiPreferences";
    private File prefsDir;

    public OSGiPreferencesServiceManager(BundleContext context) {
        this.prefsDir = context.getDataFile(OSGI_PREFS_DIR);
        context.addBundleListener((BundleListener)this);
        Bundle[] allBundles = context.getBundles();
        TreeSet<String> bundleDirNames = new TreeSet<String>();
        int i = 0;
        while (i < allBundles.length) {
            bundleDirNames.add(this.getBundleDirName(allBundles[i]));
            ++i;
        }
        File[] prefsNodeDirs = this.prefsDir.listFiles();
        prefsNodeDirs = prefsNodeDirs == null ? new File[]{} : prefsNodeDirs;
        int i2 = 0;
        while (i2 < prefsNodeDirs.length) {
            if (!bundleDirNames.contains(prefsNodeDirs[i2].getName())) {
                this.rmdir(prefsNodeDirs[i2]);
            }
            ++i2;
        }
    }

    private void rmdir(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.rmdir(children[i]);
                ++i;
            }
        }
        file.delete();
    }

    private String getBundleDirName(Bundle bundle) {
        String bundleDirName = bundle.getSymbolicName();
        if (bundleDirName == null) {
            bundleDirName = "org.eclipse.core.internal.preferences.OSGiPreferences.bundleid." + bundle.getBundleId();
        }
        return bundleDirName;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new OSGiPreferencesServiceImpl(new File(this.prefsDir, this.getBundleDirName(bundle)));
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        ((OSGiPreferencesServiceImpl)service).destroy();
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            File bundlePrefs = new File(this.prefsDir, this.getBundleDirName(event.getBundle()));
            this.rmdir(bundlePrefs);
        }
    }
}

