/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.osgi.util.NLS;

class ResourceTree
implements IResourceTree {
    private boolean isValid = true;
    private final FileSystemResourceManager localManager;
    private ILock lock;
    private MultiStatus multistatus;
    private int updateFlags;

    public ResourceTree(FileSystemResourceManager localManager, ILock lock, MultiStatus status, int updateFlags) {
        this.localManager = localManager;
        this.lock = lock;
        this.multistatus = status;
        this.updateFlags = updateFlags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addToLocalHistory(IFile file) {
        Assert.isLegal((boolean)this.isValid);
        try {
            IFileInfo fileInfo;
            IFileStore store;
            block7: {
                block6: {
                    block5: {
                        this.lock.acquire();
                        if (file.exists()) break block5;
                        break block6;
                    }
                    store = this.localManager.getStore(file);
                    fileInfo = store.fetchInfo();
                    if (fileInfo.exists()) break block7;
                }
                Object var4_2 = null;
                this.lock.release();
                return;
            }
            this.localManager.getHistoryStore().addState(file.getFullPath(), store, fileInfo, false);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
    }

    public long computeTimestamp(IFile file) {
        block3: {
            Assert.isLegal((boolean)this.isValid);
            try {
                this.lock.acquire();
                if (file.getProject().exists()) break block3;
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.lock.release();
                throw throwable;
            }
            this.lock.release();
            return 0L;
        }
        long l = this.internalComputeTimestamp(file);
        Object var2_3 = null;
        this.lock.release();
        return l;
    }

    private long internalComputeTimestamp(IFile file) {
        IFileInfo fileInfo = this.localManager.getStore(file).fetchInfo();
        return fileInfo.exists() ? fileInfo.getLastModified() : 0L;
    }

    private void copyLocalHistory(IResource source, IResource destination) {
        this.localManager.getHistoryStore().copyHistory(source, destination, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletedFile(IFile file) {
        block7: {
            block6: {
                Assert.isLegal((boolean)this.isValid);
                try {
                    this.lock.acquire();
                    if (!file.exists()) {
                        Object var5_2 = null;
                        break block6;
                    }
                    try {
                        ((Resource)((Object)file)).deleteResource(true, null);
                    }
                    catch (CoreException e) {
                        String message = NLS.bind((String)Messages.resources_errorDeleting, (Object)file.getFullPath());
                        ResourceStatus status = new ResourceStatus(4, file.getFullPath(), message, e);
                        this.failed(status);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    this.lock.release();
                    throw throwable;
                }
            }
            this.lock.release();
            return;
        }
        Object var5_4 = null;
        this.lock.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletedFolder(IFolder folder) {
        block7: {
            block6: {
                Assert.isLegal((boolean)this.isValid);
                try {
                    this.lock.acquire();
                    if (!folder.exists()) {
                        Object var5_2 = null;
                        break block6;
                    }
                    try {
                        ((Resource)((Object)folder)).deleteResource(true, null);
                    }
                    catch (CoreException e) {
                        String message = NLS.bind((String)Messages.resources_errorDeleting, (Object)folder.getFullPath());
                        ResourceStatus status = new ResourceStatus(4, folder.getFullPath(), message, e);
                        this.failed(status);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    this.lock.release();
                    throw throwable;
                }
            }
            this.lock.release();
            return;
        }
        Object var5_4 = null;
        this.lock.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletedProject(IProject target) {
        block9: {
            block8: {
                Assert.isLegal((boolean)this.isValid);
                try {
                    ResourceStatus status;
                    String message;
                    this.lock.acquire();
                    if (!target.exists()) {
                        Object var7_2 = null;
                        break block8;
                    }
                    Project project = (Project)target;
                    Workspace workspace = (Workspace)project.getWorkspace();
                    try {
                        project.deleteResource(false, null);
                    }
                    catch (CoreException e) {
                        message = NLS.bind((String)Messages.resources_errorDeleting, (Object)project.getFullPath());
                        status = new ResourceStatus(4, project.getFullPath(), message, e);
                        this.failed(status);
                    }
                    try {
                        workspace.getMetaArea().delete(project);
                    }
                    catch (CoreException e) {
                        message = NLS.bind((String)Messages.resources_deleteMeta, (Object)project.getFullPath());
                        status = new ResourceStatus(569, project.getFullPath(), message, e);
                        this.failed(status);
                    }
                    project.clearHistory(null);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var7_3 = null;
                    this.lock.release();
                    throw throwable;
                }
            }
            this.lock.release();
            return;
        }
        Object var7_4 = null;
        this.lock.release();
    }

    public void failed(IStatus reason) {
        Assert.isLegal((boolean)this.isValid);
        this.multistatus.add(reason);
    }

    protected IStatus getStatus() {
        return this.multistatus;
    }

    public long getTimestamp(IFile file) {
        block3: {
            Assert.isLegal((boolean)this.isValid);
            try {
                this.lock.acquire();
                if (file.exists()) break block3;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.lock.release();
                throw throwable;
            }
            this.lock.release();
            return 0L;
        }
        ResourceInfo info = ((File)file).getResourceInfo(false, false);
        long l = info == null ? 0L : info.getLocalSyncInfo();
        Object var3_3 = null;
        this.lock.release();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalDeleteFile(IFile file, int flags, IProgressMonitor monitor) {
        block13: {
            try {
                String message = NLS.bind((String)Messages.resources_deleting, (Object)file.getFullPath());
                monitor.beginTask(message, 100);
                Policy.checkCanceled(monitor);
                if (!file.exists()) {
                } else if (file.isLinked()) {
                    this.deletedFile(file);
                } else {
                    IFileStore fileStore = this.localManager.getStore(file);
                    boolean localExists = fileStore.fetchInfo().exists();
                    if (!localExists) {
                        this.deletedFile(file);
                    } else {
                        boolean inSync;
                        boolean force;
                        boolean keepHistory = (flags & 2) != 0;
                        boolean bl = force = (flags & 1) != 0;
                        if (keepHistory) {
                            this.addToLocalHistory(file);
                        }
                        monitor.worked(25);
                        if (!force && !(inSync = this.isSynchronized(file, 0)) && localExists) {
                            message = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)file.getFullPath());
                            ResourceStatus status = new ResourceStatus(274, file.getFullPath(), message);
                            this.failed(status);
                            break block13;
                        }
                        monitor.worked(25);
                        try {
                            fileStore.delete(0, Policy.subMonitorFor(monitor, 25));
                            this.deletedFile(file);
                        }
                        catch (CoreException e) {
                            message = NLS.bind((String)Messages.resources_couldnotDelete, (Object)fileStore.toString());
                            ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message, e);
                            this.failed(status);
                            break block13;
                        }
                    }
                }
                Object var11_5 = null;
            }
            catch (Throwable throwable) {
                Object var11_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return true;
        }
        Object var11_6 = null;
        monitor.done();
        return false;
    }

    private boolean internalDeleteFolder(IFolder folder, int flags, IProgressMonitor monitor) {
        String message = NLS.bind((String)Messages.resources_deleting, (Object)folder.getFullPath());
        monitor.beginTask("", 100);
        monitor.subTask(message);
        Policy.checkCanceled(monitor);
        if (!folder.exists()) {
            return true;
        }
        if (folder.isLinked()) {
            this.deletedFolder(folder);
            return true;
        }
        IFileStore fileStore = this.localManager.getStore(folder);
        if (!fileStore.fetchInfo().exists()) {
            this.deletedFolder(folder);
            return true;
        }
        try {
            this.localManager.delete(folder, flags, Policy.subMonitorFor(monitor, 100));
        }
        catch (CoreException ce) {
            message = NLS.bind((String)Messages.localstore_couldnotDelete, (Object)folder.getFullPath());
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, message, (Throwable)ce);
            if (ce.getStatus() != null) {
                status.merge(ce.getStatus());
            }
            this.failed((IStatus)status);
            return false;
        }
        return true;
    }

    private boolean internalDeleteProject(IProject project, int flags, IProgressMonitor monitor) {
        String[] children;
        IResource[] members = null;
        try {
            members = project.members(2);
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.resources_errorMembers, (Object)project.getFullPath());
            ResourceStatus status = new ResourceStatus(4, project.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
        boolean deletedChildren = true;
        int i = 0;
        while (i < members.length) {
            IResource child = members[i];
            switch (child.getType()) {
                case 1: {
                    if (child.getName().equals(".project")) break;
                    deletedChildren &= this.internalDeleteFile((IFile)child, flags, Policy.subMonitorFor(monitor, 100 / members.length));
                    break;
                }
                case 2: {
                    deletedChildren &= this.internalDeleteFolder((IFolder)child, flags, Policy.subMonitorFor(monitor, 100 / members.length));
                }
            }
            ++i;
        }
        IFileStore projectStore = this.localManager.getStore(project);
        if (!deletedChildren) {
            return false;
        }
        try {
            children = projectStore.childNames(0, null);
        }
        catch (CoreException coreException) {
            children = new String[]{};
        }
        if (children.length != 1 || !".project".equals(children[0])) {
            String message = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)project.getName());
            this.failed(new ResourceStatus(274, project.getFullPath(), message));
            return false;
        }
        IResource file = project.findMember(".project");
        if (file == null) {
            IFileStore dotProject = projectStore.getChild(".project");
            try {
                dotProject.delete(0, null);
            }
            catch (CoreException e) {
                this.failed(e.getStatus());
            }
        } else {
            boolean deletedProjectFile = this.internalDeleteFile((IFile)file, flags, Policy.monitorFor(null));
            if (!deletedProjectFile) {
                String message = NLS.bind((String)Messages.resources_couldnotDelete, (Object)file.getFullPath());
                ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
                this.failed(status);
                return false;
            }
        }
        try {
            projectStore.delete(0, null);
            this.deletedProject(project);
            return true;
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.resources_couldnotDelete, (Object)projectStore.toString());
            ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
    }

    private boolean isContentChange(IProject project, IProjectDescription destDescription) {
        ProjectDescription srcDescription = ((Project)project).internalGetDescription();
        URI srcLocation = srcDescription.getLocationURI();
        URI destLocation = destDescription.getLocationURI();
        if (srcLocation == null || destLocation == null) {
            return true;
        }
        return !srcLocation.equals(destLocation);
    }

    private boolean isNameChange(IProject project, IProjectDescription description) {
        return !project.getName().equals(description.getName());
    }

    public boolean isSynchronized(IResource resource, int depth) {
        boolean bl;
        try {
            this.lock.acquire();
            bl = this.localManager.isSynchronized(resource, depth);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
        return bl;
    }

    void makeInvalid() {
        this.isValid = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void movedFile(IFile source, IFile destination) {
        block12: {
            block11: {
                Assert.isLegal((boolean)this.isValid);
                try {
                    ResourceStatus status;
                    String message;
                    this.lock.acquire();
                    if (!source.exists()) {
                        Object var8_3 = null;
                        break block11;
                    }
                    if (destination.exists()) {
                        String message2 = NLS.bind((String)Messages.resources_mustNotExist, (Object)destination.getFullPath());
                        ResourceStatus status2 = new ResourceStatus(4, destination.getFullPath(), message2);
                        this.failed(status2);
                    }
                    IPropertyManager propertyManager = ((Resource)((Object)source)).getPropertyManager();
                    try {
                        propertyManager.copy(source, destination, 0);
                        propertyManager.deleteProperties(source, 0);
                    }
                    catch (CoreException e) {
                        String message3 = NLS.bind((String)Messages.resources_errorPropertiesMove, (Object)source.getFullPath(), (Object)destination.getFullPath());
                        ResourceStatus status3 = new ResourceStatus(4, source.getFullPath(), message3, e);
                        this.failed(status3);
                    }
                    Workspace workspace = (Workspace)source.getWorkspace();
                    try {
                        workspace.move((Resource)((Object)source), destination.getFullPath(), 0, this.updateFlags, false);
                    }
                    catch (CoreException e) {
                        message = NLS.bind((String)Messages.resources_errorMoving, (Object)source.getFullPath(), (Object)destination.getFullPath());
                        status = new ResourceStatus(4, source.getFullPath(), message, e);
                        this.failed(status);
                    }
                    try {
                        workspace.getMarkerManager().moved(source, destination, 0);
                    }
                    catch (CoreException e) {
                        message = NLS.bind((String)Messages.resources_errorMarkersDelete, (Object)source.getFullPath());
                        status = new ResourceStatus(4, source.getFullPath(), message, e);
                        this.failed(status);
                    }
                    this.copyLocalHistory(source, destination);
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var8_4 = null;
                    this.lock.release();
                    throw throwable;
                }
            }
            this.lock.release();
            return;
        }
        Object var8_5 = null;
        this.lock.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void movedFolderSubtree(IFolder source, IFolder destination) {
        Assert.isLegal((boolean)this.isValid);
        try {
            ResourceStatus status;
            String message;
            block13: {
                block12: {
                    block11: {
                        this.lock.acquire();
                        if (source.exists()) break block11;
                        break block12;
                    }
                    if (!destination.exists()) break block13;
                    String message2 = NLS.bind((String)Messages.resources_mustNotExist, (Object)destination.getFullPath());
                    ResourceStatus status2 = new ResourceStatus(4, destination.getFullPath(), message2);
                    this.failed(status2);
                }
                Object var9_3 = null;
                this.lock.release();
                return;
            }
            int depth = 2;
            IPropertyManager propertyManager = ((Resource)((Object)source)).getPropertyManager();
            try {
                propertyManager.copy(source, destination, depth);
                propertyManager.deleteProperties(source, depth);
            }
            catch (CoreException e) {
                String message3 = NLS.bind((String)Messages.resources_errorPropertiesMove, (Object)source.getFullPath(), (Object)destination.getFullPath());
                ResourceStatus status3 = new ResourceStatus(4, source.getFullPath(), message3, e);
                this.failed(status3);
            }
            Workspace workspace = (Workspace)source.getWorkspace();
            try {
                workspace.move((Resource)((Object)source), destination.getFullPath(), depth, this.updateFlags, false);
            }
            catch (CoreException e) {
                message = NLS.bind((String)Messages.resources_errorMoving, (Object)source.getFullPath(), (Object)destination.getFullPath());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                workspace.getMarkerManager().moved(source, destination, depth);
            }
            catch (CoreException e) {
                message = NLS.bind((String)Messages.resources_errorMarkersDelete, (Object)source.getFullPath());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            this.copyLocalHistory(source, destination);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean movedProjectSubtree(IProject project, IProjectDescription destDescription) {
        block21: {
            Assert.isLegal((boolean)this.isValid);
            try {
                this.lock.acquire();
                if (!project.exists()) {
                } else {
                    ResourceStatus status;
                    String message;
                    Project source = (Project)project;
                    Project destination = (Project)source.getWorkspace().getRoot().getProject(destDescription.getName());
                    Workspace workspace = (Workspace)source.getWorkspace();
                    int depth = 2;
                    if (this.isNameChange(source, destDescription)) {
                        ResourceStatus status2;
                        String message2;
                        if (destination.exists()) {
                            String message3 = NLS.bind((String)Messages.resources_mustNotExist, (Object)destination.getFullPath());
                            ResourceStatus status3 = new ResourceStatus(4, destination.getFullPath(), message3);
                            this.failed(status3);
                            break block21;
                        }
                        try {
                            source.getPropertyManager().closePropertyStore(source);
                            this.localManager.getHistoryStore().closeHistoryStore(source);
                        }
                        catch (CoreException e) {
                            message = NLS.bind((String)Messages.properties_couldNotClose, (Object)source.getFullPath());
                            status = new ResourceStatus(4, source.getFullPath(), message, e);
                            this.failed(status);
                        }
                        IFileSystem fileSystem = EFS.getLocalFileSystem();
                        IFileStore oldMetaArea = fileSystem.getStore(workspace.getMetaArea().locationFor(source));
                        IFileStore newMetaArea = fileSystem.getStore(workspace.getMetaArea().locationFor(destination));
                        try {
                            oldMetaArea.move(newMetaArea, 0, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            message2 = NLS.bind((String)Messages.resources_moveMeta, (Object)oldMetaArea, (Object)newMetaArea);
                            status2 = new ResourceStatus(568, destination.getFullPath(), message2, e);
                            this.failed(status2);
                        }
                        try {
                            workspace.move(source, destination.getFullPath(), depth, this.updateFlags, true);
                        }
                        catch (CoreException e) {
                            message2 = NLS.bind((String)Messages.resources_errorMoving, (Object)source.getFullPath(), (Object)destination.getFullPath());
                            status2 = new ResourceStatus(4, source.getFullPath(), message2, e);
                            this.failed(status2);
                        }
                        ((ProjectInfo)destination.getResourceInfo(false, true)).fixupAfterMove();
                        try {
                            workspace.getMarkerManager().moved(source, destination, depth);
                        }
                        catch (CoreException e) {
                            message2 = NLS.bind((String)Messages.resources_errorMarkersMove, (Object)source.getFullPath(), (Object)destination.getFullPath());
                            status2 = new ResourceStatus(4, source.getFullPath(), message2, e);
                            this.failed(status2);
                        }
                        this.copyLocalHistory(source, destination);
                    }
                    try {
                        ((ProjectDescription)destDescription).setLinkDescriptions(destination.internalGetDescription().getLinks());
                        destination.internalSetDescription(destDescription, true);
                        destination.writeDescription(1);
                    }
                    catch (CoreException e) {
                        message = Messages.resources_projectDesc;
                        status = new ResourceStatus(4, destination.getFullPath(), message, e);
                        this.failed(status);
                    }
                    try {
                        workspace.getMetaArea().writePrivateDescription(destination);
                    }
                    catch (CoreException e) {
                        this.failed(e.getStatus());
                    }
                    try {
                        destination.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        message = NLS.bind((String)Messages.resources_errorRefresh, (Object)destination.getFullPath());
                        status = new ResourceStatus(4, destination.getFullPath(), message, e);
                        this.failed(status);
                        break block21;
                    }
                }
                Object var13_3 = null;
            }
            catch (Throwable throwable) {
                Object var13_5 = null;
                this.lock.release();
                throw throwable;
            }
            this.lock.release();
            return true;
        }
        Object var13_4 = null;
        this.lock.release();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveProjectContent(IProject source, IProjectDescription destDescription, int flags, IProgressMonitor monitor) throws CoreException {
        try {
            IFileStore destStore;
            String message;
            block15: {
                block14: {
                    boolean replace;
                    URI destLocation;
                    block13: {
                        message = NLS.bind((String)Messages.resources_moving, (Object)source.getFullPath());
                        monitor.beginTask(message, 10);
                        IProjectDescription srcDescription = source.getDescription();
                        URI srcLocation = srcDescription.getLocationURI();
                        destLocation = destDescription.getLocationURI();
                        if (srcLocation == null || !srcLocation.equals(destLocation)) break block13;
                        break block14;
                    }
                    if (destLocation == null) {
                        IPath rootLocation = source.getWorkspace().getRoot().getLocation();
                        destLocation = rootLocation.append(destDescription.getName()).toFile().toURI();
                    }
                    destStore = EFS.getStore((URI)destLocation);
                    boolean bl = replace = (flags & 0x100) != 0;
                    if (!replace) break block15;
                    destStore.mkdir(0, Policy.subMonitorFor(monitor, 10));
                }
                Object var15_9 = null;
                monitor.done();
                return;
            }
            this.localManager.move((IResource)source, destStore, flags, Policy.subMonitorFor(monitor, 9));
            if ((flags & 0x20) == 0) {
                IResource[] children = source.members();
                int i = 0;
                while (i < children.length) {
                    if (children[i].isLinked()) {
                        message = NLS.bind((String)Messages.resources_moving, (Object)children[i].getFullPath());
                        monitor.subTask(message);
                        IFileStore linkDestination = destStore.getChild(children[i].getName());
                        try {
                            this.localManager.move(children[i], linkDestination, flags, Policy.monitorFor(null));
                        }
                        catch (CoreException ce) {
                            this.failed(ce.getStatus());
                        }
                    }
                    ++i;
                }
            }
            monitor.worked(1);
            Object var15_11 = null;
        }
        catch (Throwable throwable) {
            Object var15_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardDeleteFile(IFile file, int flags, IProgressMonitor monitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            this.internalDeleteFile(file, flags, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.lock.release();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.lock.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardDeleteFolder(IFolder folder, int flags, IProgressMonitor monitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            this.internalDeleteFolder(folder, flags, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.lock.release();
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.lock.release();
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardDeleteProject(IProject project, int flags, IProgressMonitor monitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            boolean success;
            String message;
            block18: {
                block17: {
                    boolean alwaysDeleteContent;
                    block19: {
                        this.lock.acquire();
                        message = NLS.bind((String)Messages.resources_deleting, (Object)project.getFullPath());
                        monitor.beginTask(message, 100);
                        if (project.exists()) break block19;
                        break block17;
                    }
                    boolean bl = alwaysDeleteContent = (flags & 4) != 0;
                    if (alwaysDeleteContent) {
                        flags |= 1;
                    }
                    boolean force = (flags & 1) != 0;
                    boolean neverDeleteContent = (flags & 8) != 0;
                    success = true;
                    if (!alwaysDeleteContent && (!project.isOpen() || neverDeleteContent)) break block18;
                    if (!force && !this.isSynchronized(project, 2)) {
                        success = this.internalDeleteProject(project, flags, monitor);
                        if (success) {
                            this.deletedProject(project);
                        } else {
                            IFileStore store = this.localManager.getStore(project);
                            message = NLS.bind((String)Messages.resources_couldnotDelete, (Object)store.toString());
                            ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message);
                            this.failed(status);
                        }
                    } else {
                        try {
                            IFileStore projectStore = this.localManager.getStore(project);
                            if (project.isOpen()) {
                                this.localManager.delete(project, flags & 1, Policy.subMonitorFor(monitor, 75));
                                projectStore.delete(0, null);
                                break block18;
                            } else {
                                projectStore.delete(0, Policy.subMonitorFor(monitor, 75));
                            }
                            break block18;
                        }
                        catch (CoreException ce) {
                            message = NLS.bind((String)Messages.localstore_couldnotDelete, (Object)project.getFullPath());
                            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, message, (Throwable)ce);
                            if (ce.getStatus() != null) {
                                status.merge(ce.getStatus());
                            }
                            this.failed((IStatus)status);
                        }
                    }
                }
                Object var11_5 = null;
                this.lock.release();
                monitor.done();
                return;
            }
            if (success) {
                this.deletedProject(project);
            } else {
                message = NLS.bind((String)Messages.localstore_couldnotDelete, (Object)project.getFullPath());
                ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message);
                this.failed(status);
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            this.lock.release();
            monitor.done();
            throw throwable;
        }
        this.lock.release();
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardMoveFile(IFile source, IFile destination, int flags, IProgressMonitor monitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            block13: {
                boolean isDeep;
                this.lock.acquire();
                String message = NLS.bind((String)Messages.resources_moving, (Object)source.getFullPath());
                monitor.subTask(message);
                if (!source.exists()) throw new IllegalArgumentException();
                if (destination.exists()) throw new IllegalArgumentException();
                if (!destination.getParent().isAccessible()) {
                    throw new IllegalArgumentException();
                }
                boolean force = (flags & 1) != 0;
                boolean keepHistory = (flags & 2) != 0;
                boolean bl = isDeep = (flags & 0x20) == 0;
                if (!force && !this.isSynchronized(source, 2)) {
                    message = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)source.getFullPath());
                    ResourceStatus status = new ResourceStatus(274, source.getFullPath(), message);
                    this.failed(status);
                } else {
                    monitor.worked(25);
                    if (keepHistory) {
                        this.addToLocalHistory(source);
                    }
                    monitor.worked(25);
                    if (!isDeep && source.isLinked()) {
                        this.movedFile(source, destination);
                    } else {
                        IFileStore destStore = null;
                        boolean failedDeletingSource = false;
                        try {
                            destStore = this.localManager.getStore(destination);
                            destStore.getParent().mkdir(0, Policy.subMonitorFor(monitor, 0));
                            this.localManager.move((IResource)source, destStore, flags, monitor);
                        }
                        catch (CoreException e) {
                            this.failed(e.getStatus());
                            boolean bl2 = failedDeletingSource = destStore != null && destStore.fetchInfo().exists();
                            if (!failedDeletingSource) break block13;
                        }
                        this.movedFile(source, destination);
                        this.updateMovedFileTimestamp(destination, this.internalComputeTimestamp(destination));
                        if (failedDeletingSource) {
                            try {
                                source.refreshLocal(2, null);
                            }
                            catch (CoreException coreException) {}
                        }
                        monitor.worked(25);
                    }
                }
            }
            Object var12_11 = null;
            this.lock.release();
            monitor.done();
            return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.lock.release();
            monitor.done();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardMoveFolder(IFolder source, IFolder destination, int flags, IProgressMonitor monitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            boolean failedDeletingSource;
            boolean isDeep;
            block13: {
                boolean force;
                this.lock.acquire();
                String message = NLS.bind((String)Messages.resources_moving, (Object)source.getFullPath());
                monitor.beginTask(message, 100);
                if (!source.exists()) throw new IllegalArgumentException();
                if (destination.exists()) throw new IllegalArgumentException();
                if (!destination.getParent().isAccessible()) {
                    throw new IllegalArgumentException();
                }
                boolean bl = force = (flags & 1) != 0;
                if (!force && !this.isSynchronized(source, 2)) {
                    message = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)source.getFullPath());
                    ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message);
                    this.failed(status);
                } else {
                    monitor.worked(20);
                    boolean bl2 = isDeep = (flags & 0x20) == 0;
                    if (!isDeep && source.isLinked()) {
                        this.movedFolderSubtree(source, destination);
                    } else {
                        IFileStore destStore = null;
                        failedDeletingSource = false;
                        try {
                            destStore = this.localManager.getStore(destination);
                            this.localManager.move((IResource)source, destStore, flags, Policy.subMonitorFor(monitor, 60));
                            break block13;
                        }
                        catch (CoreException e) {
                            this.failed(e.getStatus());
                            boolean bl3 = failedDeletingSource = destStore != null && destStore.fetchInfo().exists();
                            if (failedDeletingSource) break block13;
                        }
                    }
                }
                Object var11_9 = null;
                this.lock.release();
                monitor.done();
                return;
            }
            this.movedFolderSubtree(source, destination);
            monitor.worked(20);
            this.updateTimestamps(destination, isDeep);
            if (failedDeletingSource) {
                try {
                    source.refreshLocal(2, null);
                    destination.refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.lock.release();
            monitor.done();
            throw throwable;
        }
        this.lock.release();
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardMoveProject(IProject source, IProjectDescription description, int flags, IProgressMonitor monitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            String message;
            block13: {
                block12: {
                    boolean force;
                    block11: {
                        this.lock.acquire();
                        message = NLS.bind((String)Messages.resources_moving, (Object)source.getFullPath());
                        monitor.beginTask(message, 100);
                        if (!source.isAccessible()) {
                            throw new IllegalArgumentException();
                        }
                        if (this.isContentChange(source, description)) break block11;
                        this.movedProjectSubtree(source, description);
                        break block12;
                    }
                    boolean bl = force = (flags & 1) != 0;
                    if (force || this.isSynchronized(source, 2)) break block13;
                    message = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)source.getFullPath());
                    ResourceStatus status = new ResourceStatus(274, source.getFullPath(), message);
                    this.failed(status);
                }
                Object var9_6 = null;
                this.lock.release();
                monitor.done();
                return;
            }
            try {
                this.moveProjectContent(source, description, flags, Policy.subMonitorFor(monitor, 75));
            }
            catch (CoreException e) {
                message = NLS.bind((String)Messages.localstore_couldNotMove, (Object)source.getFullPath());
                ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
                try {
                    source.refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
            }
            this.movedProjectSubtree(source, description);
            monitor.worked(12);
            boolean isDeep = (flags & 0x20) == 0;
            this.updateTimestamps(source.getWorkspace().getRoot().getProject(description.getName()), isDeep);
            monitor.worked(12);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.lock.release();
            monitor.done();
            throw throwable;
        }
        this.lock.release();
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMovedFileTimestamp(IFile file, long timestamp) {
        block5: {
            block4: {
                Assert.isLegal((boolean)this.isValid);
                try {
                    this.lock.acquire();
                    if (!file.exists()) {
                        Object var5_3 = null;
                        break block4;
                    }
                    ResourceInfo info = ((Resource)((Object)file)).getResourceInfo(false, true);
                    this.localManager.updateLocalSync(info, timestamp);
                    info.clear(65536);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.lock.release();
                    throw throwable;
                }
            }
            this.lock.release();
            return;
        }
        Object var5_5 = null;
        this.lock.release();
    }

    private void updateTimestamps(IResource root, final boolean isDeep) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (resource.isLinked()) {
                    if (isDeep) {
                        ResourceInfo info = ((Resource)resource).getResourceInfo(false, true);
                        info.clear(65536);
                    }
                    return true;
                }
                return true;
            }
        };
        try {
            root.accept(visitor, 2, 2);
        }
        catch (CoreException coreException) {}
    }
}

