/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.TeamPlugin;

public class RemoteAnnotationStorage
extends PlatformObject
implements IEncodedStorage {
    private InputStream contents;
    private ICVSRemoteFile file;

    public RemoteAnnotationStorage(ICVSRemoteFile file, InputStream contents) {
        this.file = file;
        this.contents = contents;
    }

    public InputStream getContents() throws CoreException {
        try {
            this.contents.reset();
        }
        catch (IOException e) {
            CVSUIPlugin.log((CoreException)((Object)CVSException.wrapException((Exception)e)));
        }
        return this.contents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCharset() throws CoreException {
        String string;
        InputStream contents = this.getContents();
        try {
            try {
                String charSet;
                string = charSet = TeamPlugin.getCharset((String)this.getName(), (InputStream)contents);
                Object var3_5 = null;
            }
            catch (IOException e) {
                throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", 381, NLS.bind((String)CVSUIMessages.RemoteAnnotationStorage_1, (Object[])new String[]{this.getFullPath().toString()}), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        contents.close();
        return string;
    }

    public IPath getFullPath() {
        ICVSRepositoryLocation location = this.file.getRepository();
        Path path = new Path(null, location.getRootDirectory());
        path = path.setDevice(String.valueOf(location.getHost()) + ':');
        path = path.append(this.file.getRepositoryRelativePath());
        return path;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return true;
    }
}

