/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.IgnoreResourcesDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public class IgnoreAction
extends WorkspaceTraversalAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IResource[] resources = IgnoreAction.this.getSelectedResources();
                IgnoreResourcesDialog dialog = new IgnoreResourcesDialog(IgnoreAction.this.getShell(), resources);
                if (dialog.open() != 0) {
                    return;
                }
                new IgnoreOperation(IgnoreAction.this.getTargetPart(), resources, dialog).run();
            }
        }, false, 2);
    }

    protected String getErrorTitle() {
        return CVSUIMessages.IgnoreAction_ignore;
    }

    protected boolean isEnabledForManagedResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        if (super.isEnabledForCVSResource(cvsResource)) {
            CVSWorkspaceSubscriber subscriber = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
            IResource resource = cvsResource.getIResource();
            if (resource == null) {
                return false;
            }
            try {
                SyncInfo info = subscriber.getSyncInfo(resource);
                return (info.getKind() & 0xC) == 4;
            }
            catch (TeamException teamException) {
                return true;
            }
        }
        return false;
    }

    public String getId() {
        return "org.eclipse.team.cvs.ui.ignore";
    }

    class IgnoreOperation
    extends RepositoryProviderOperation {
        private final IgnoreResourcesDialog dialog;

        public IgnoreOperation(IWorkbenchPart part, IResource[] resources, IgnoreResourcesDialog dialog) {
            super(part, resources);
            this.dialog = dialog;
        }

        protected String getTaskName(CVSTeamProvider provider) {
            return NLS.bind((String)CVSUIMessages.IgnoreAction_0, (Object[])new String[]{provider.getProject().getName()});
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
            try {
                try {
                    monitor.beginTask(null, resources.length);
                    int i = 0;
                    while (i < resources.length) {
                        IResource resource = resources[i];
                        String pattern = this.dialog.getIgnorePatternFor(resource);
                        ICVSResource cvsResource = IgnoreAction.this.getCVSResourceFor(resource);
                        cvsResource.setIgnoredAs(pattern);
                        monitor.worked(1);
                        ++i;
                    }
                }
                catch (TeamException e) {
                    this.collectStatus(e.getStatus());
                    Object var9_10 = null;
                    monitor.done();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var9_12 = null;
            }
            monitor.done();
            this.collectStatus(Status.OK_STATUS);
        }

        protected String getTaskName() {
            return CVSUIMessages.IgnoreAction_1;
        }

        public boolean consultModelsForMappings() {
            return false;
        }
    }
}

