/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPagePane;

public class OutgoingChangesDialog
extends DetailsDialog {
    private final String message;
    private ParticipantPagePane pane;
    private ModelSynchronizeParticipant participant;
    private final String title;
    private final String detailsMessage;
    private final ISynchronizationScopeManager manager;

    public OutgoingChangesDialog(Shell parentShell, ISynchronizationScopeManager manager, String title, String message, String detailsMessage) {
        super(parentShell, title);
        this.manager = manager;
        this.title = title;
        this.message = message;
        this.detailsMessage = detailsMessage;
    }

    protected void createMainDialogArea(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite((Composite)parent, (int)0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createWrappingLabel(composite, this.message);
        Dialog.applyDialogFont((Control)parent);
    }

    protected Label createWrappingLabel(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        return label;
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite((Composite)parent, (int)1);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 200;
        composite.setLayoutData((Object)data);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (OutgoingChangesDialog.this.pane != null) {
                    OutgoingChangesDialog.this.pane.dispose();
                }
                if (OutgoingChangesDialog.this.participant != null) {
                    OutgoingChangesDialog.this.participant.dispose();
                }
            }
        });
        this.createWrappingLabel(composite, this.detailsMessage);
        try {
            this.participant = this.createParticipant();
            ISynchronizePageConfiguration configuration = this.participant.createPageConfiguration();
            configuration.setSupportedModes(2);
            configuration.setMode(2);
            configuration.setMenuGroups("org.eclipse.team.ui.P_TOOLBAR_MENU", new String[]{"navigate", "layout"});
            this.pane = new ParticipantPagePane(this.getShell(), true, configuration, (ISynchronizeParticipant)this.participant);
            Control control = this.pane.createPartControl(composite);
            control.setLayoutData((Object)SWTUtils.createHVFillGridData());
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
            SWTUtils.createLabel((Composite)parent, (String)CVSUIMessages.OutgoingChangesDialog_0);
        }
        catch (InterruptedException interruptedException) {
            SWTUtils.createLabel((Composite)parent, (String)CVSUIMessages.OutgoingChangesDialog_1);
        }
        return composite;
    }

    private ModelSynchronizeParticipant createParticipant() throws InvocationTargetException, InterruptedException {
        SynchronizationContext context = this.createSynchronizationContext(this.manager);
        ModelSynchronizeParticipant participant = ModelSynchronizeParticipant.createParticipant((SynchronizationContext)context, (String)this.title);
        participant.setMergingEnabled(false);
        return participant;
    }

    private SynchronizationContext createSynchronizationContext(ISynchronizationScopeManager manager) throws InvocationTargetException, InterruptedException {
        SynchronizationContext[] context = new SynchronizationContext[]{WorkspaceSubscriberContext.createContext(manager, 3)};
        return context[0];
    }

    protected boolean isMainGrabVertical() {
        return false;
    }

    protected void updateEnablements() {
        this.setPageComplete(true);
    }

    protected boolean includeErrorMessage() {
        return false;
    }
}

