/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.CompareWithRevisionAction;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.TypedBufferedContent;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.team.ui.SaveablePartDialog;
import org.eclipse.team.ui.history.HistoryPageSaveablePart;
import org.eclipse.team.ui.history.HistoryPageSource;
import org.eclipse.team.ui.history.IHistoryPageSource;

public class ReplaceWithRevisionAction
extends CompareWithRevisionAction {
    protected static final int REPLACE_ID = 10;

    protected void showCompareInDialog(Shell shell, Object object) {
        IHistoryPageSource pageSource = HistoryPageSource.getHistoryPageSource((Object)object);
        if (pageSource != null && pageSource.canShowHistoryFor(object)) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            ReplaceSaveablePart input = new ReplaceSaveablePart(shell, cc, pageSource, object);
            ReplaceCompareDialog cd = new ReplaceCompareDialog(shell, input);
            cd.setBlockOnOpen(true);
            cd.open();
        }
    }

    protected String getActionTitle() {
        return CVSUIMessages.ReplaceWithRevisionAction_1;
    }

    protected class ReplaceCompareDialog
    extends SaveablePartDialog {
        private Button replaceButton;

        public ReplaceCompareDialog(Shell shell, ReplaceSaveablePart input) {
            super(shell, (ISaveableWorkbenchPart)input);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.replaceButton = this.createButton(parent, 10, CVSUIMessages.ReplaceWithRevisionAction_0, true);
            this.replaceButton.setEnabled(false);
            ((ReplaceSaveablePart)this.getInput()).getReplaceSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ ReplaceCompareDialog this$1;
                {
                    this.this$1 = replaceCompareDialog;
                }

                public void selectionChanged(SelectionChangedEvent e) {
                    StructuredSelection s = (StructuredSelection)e.getSelection();
                    ReplaceCompareDialog.access$0(this.this$1).setEnabled(s != null && !s.isEmpty() && s.size() == 1);
                }
            });
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 10) {
                try {
                    ((ReplaceSaveablePart)this.getInput()).replaceLocalWithCurrentlySelectedRevision();
                }
                catch (CoreException e) {
                    Utils.handle((Throwable)e);
                }
                buttonId = 0;
            }
            super.buttonPressed(buttonId);
        }

        static /* synthetic */ Button access$0(ReplaceCompareDialog replaceCompareDialog) {
            return replaceCompareDialog.replaceButton;
        }
    }

    protected class ReplaceSaveablePart
    extends HistoryPageSaveablePart {
        ICompareInput compareInput;

        public ReplaceSaveablePart(Shell shell, CompareConfiguration configuration, IHistoryPageSource pageSource, Object object) {
            super(shell, configuration, pageSource, object);
        }

        protected void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) throws InvocationTargetException {
            super.prepareInput(input, configuration, monitor);
            this.compareInput = input;
            configuration.setLeftEditable(false);
        }

        public void replaceLocalWithCurrentlySelectedRevision() throws CoreException {
            FileRevisionTypedElement right = (FileRevisionTypedElement)this.compareInput.getRight();
            TypedBufferedContent left = (TypedBufferedContent)this.compareInput.getLeft();
            left.setContent(Utils.readBytes((InputStream)right.getContents()));
        }

        public ISelectionProvider getReplaceSelectionProvider() {
            return this.getSelectionProvider();
        }
    }
}

