/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelCompareParticipant;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.core.subscribers.SubscriberResourceCollector;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class LogEntryCacheUpdateHandler
extends BackgroundEventHandler {
    private static final int REMOVAL = 1;
    private static final int CHANGE = 2;
    private static final int FETCH_REQUEST = 3;
    private static final int PAUSE = 4;
    private final Object queueLock = new Object();
    private static final OperationCanceledException PAUSE_EXCEPTION = new OperationCanceledException();
    private static final int WAIT_INCREMENT = 10;
    private static final int MAX_WAIT = 1000;
    private final SyncInfoTree collectedInfos = new SyncInfoTree();
    private SoftReference cacheReference;
    private final LogEntryResourceCollector collector;
    private final Subscriber subscriber;
    private final List updates = new ArrayList();
    private final List fetches = new ArrayList();
    private final ISynchronizePageConfiguration configuration;
    private ILogsFetchedListener listener;

    public LogEntryCacheUpdateHandler(ISynchronizePageConfiguration configuration) {
        super(CVSUIMessages.LogEntryCacheUpdateHandler_1, CVSUIMessages.LogEntryCacheUpdateHandler_0);
        this.configuration = configuration;
        this.subscriber = this.getSubscriber(configuration);
        this.cacheReference = new SoftReference<RemoteLogOperation.LogEntryCache>(new RemoteLogOperation.LogEntryCache());
        this.collector = new LogEntryResourceCollector(this.subscriber);
    }

    private Subscriber getSubscriber(ISynchronizePageConfiguration configuration) {
        ISynchronizeParticipant participant = configuration.getParticipant();
        if (participant instanceof SubscriberParticipant) {
            SubscriberParticipant sp = (SubscriberParticipant)participant;
            return sp.getSubscriber();
        }
        if (participant instanceof ModelCompareParticipant) {
            ModelCompareParticipant mcp = (ModelCompareParticipant)participant;
            return mcp.getSubscriber();
        }
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public void setListener(ILogsFetchedListener listener) {
        this.listener = listener;
    }

    protected Object getJobFamiliy() {
        return ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION;
    }

    protected void createEventHandlingJob() {
        super.createEventHandlingJob();
        Job job = this.getEventHandlerJob();
        job.setSystem(false);
        job.setUser(false);
    }

    protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
        Policy.checkCanceled(monitor);
        switch (event.getType()) {
            case 1: 
            case 2: {
                this.updates.add(event);
                break;
            }
            case 3: {
                this.fetches.add(event);
                break;
            }
            case 4: {
                throw PAUSE_EXCEPTION;
            }
        }
    }

    protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
        Policy.checkCanceled(monitor);
        boolean dispatched = false;
        monitor.beginTask(null, 50);
        dispatched |= this.updateCache(Policy.subMonitorFor(monitor, 20));
        monitor.done();
        return dispatched |= this.processQueuedFetches(Policy.subMonitorFor(monitor, 80));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateCache(IProgressMonitor monitor) {
        if (this.updates.isEmpty()) {
            return false;
        }
        try {
            this.collectedInfos.beginInput();
            Iterator iter = this.updates.iterator();
            while (iter.hasNext()) {
                BackgroundEventHandler.Event event = (BackgroundEventHandler.Event)iter.next();
                Policy.checkCanceled(monitor);
                if (event.getType() == 1) {
                    this.remove(event.getResource(), ((BackgroundEventHandler.ResourceEvent)event).getDepth());
                } else if (event.getType() == 2) {
                    this.change(event.getResource(), ((BackgroundEventHandler.ResourceEvent)event).getDepth());
                }
                iter.remove();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.collectedInfos.endInput(monitor);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.collectedInfos.endInput(monitor);
        return true;
    }

    public void shutdown() {
        RemoteLogOperation.LogEntryCache cache;
        super.shutdown();
        this.collector.dispose();
        if (this.cacheReference != null && (cache = (RemoteLogOperation.LogEntryCache)this.cacheReference.get()) != null) {
            cache.clearEntries();
        }
        this.collectedInfos.clear();
    }

    private void remove(IResource resource, int depth) {
        this.collectedInfos.remove(resource, depth);
    }

    private void remove(SyncInfo info) {
        if (info != null) {
            this.collectedInfos.remove(info.getLocal());
            RemoteLogOperation.LogEntryCache cache = (RemoteLogOperation.LogEntryCache)this.cacheReference.get();
            if (cache != null) {
                cache.clearEntries(this.getRemoteResource(info));
            }
        }
    }

    public ICVSRemoteResource getRemoteResource(SyncInfo info) {
        try {
            ICVSRemoteResource remote = (ICVSRemoteResource)info.getRemote();
            ICVSRemoteResource local = CVSWorkspaceRoot.getRemoteResourceFor((IResource)info.getLocal());
            if (local == null) {
                local = (ICVSRemoteResource)info.getBase();
            }
            boolean useRemote = true;
            if (local != null && remote != null) {
                String remoteRevision = this.getRevisionString(remote);
                String localRevision = this.getRevisionString(local);
                useRemote = this.useRemote(localRevision, remoteRevision);
            } else if (remote == null) {
                useRemote = false;
            }
            if (useRemote) {
                return remote;
            }
            if (local != null) {
                return local;
            }
            return null;
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private boolean useRemote(String localRevision, String remoteRevision) {
        boolean useRemote = remoteRevision == null && localRevision == null ? true : (localRevision == null ? true : (remoteRevision == null ? false : ResourceSyncInfo.isLaterRevision((String)remoteRevision, (String)localRevision)));
        return useRemote;
    }

    private String getRevisionString(ICVSRemoteResource remoteFile) {
        if (remoteFile instanceof RemoteFile) {
            return ((RemoteFile)remoteFile).getRevision();
        }
        return null;
    }

    private void change(IResource resource, int depth) {
        SyncInfo[] collected = this.collectedInfos.getSyncInfos(resource, depth);
        this.change(collected);
    }

    private void change(SyncInfo[] collected) {
        Subscriber subscriber = this.getSubscriber();
        int i = 0;
        while (i < collected.length) {
            try {
                SyncInfo info = collected[i];
                SyncInfo newInfo = subscriber.getSyncInfo(info.getLocal());
                if (newInfo == null || !newInfo.equals((Object)info)) {
                    this.remove(info);
                }
            }
            catch (TeamException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(SyncInfo[] infos) throws CVSException {
        Object object = this.queueLock;
        synchronized (object) {
            Job job = this.getEventHandlerJob();
            if (job.isSystem() && job.getState() != 0) {
                super.queueEvent(new BackgroundEventHandler.Event(4), true);
                int count = 0;
                while (job.getState() != 0 && count < 1000) {
                    count += 10;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (job.getState() != 0) {
                    throw new CVSException(CVSUIMessages.LogEntryCacheUpdateHandler_2);
                }
            }
            this.queueEvent(new FetchRequest(infos), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEvent(BackgroundEventHandler.Event event, boolean front) {
        Object object = this.queueLock;
        synchronized (object) {
            Job job = this.getEventHandlerJob();
            if (job.getState() == 0) {
                job.setSystem(event.getType() != 3);
            }
            super.queueEvent(event, front);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processQueuedFetches(IProgressMonitor monitor) {
        block8: {
            block7: {
                if (this.fetches.isEmpty()) {
                    return false;
                }
                try {
                    Map projectMapping = this.getFetchesByProject();
                    if (projectMapping.isEmpty()) {
                        Object var6_3 = null;
                        this.fetches.clear();
                        break block7;
                    }
                    RemoteLogOperation.LogEntryCache logEntriesCache = (RemoteLogOperation.LogEntryCache)this.cacheReference.get();
                    if (logEntriesCache == null) {
                        logEntriesCache = new RemoteLogOperation.LogEntryCache();
                        this.cacheReference = new SoftReference<RemoteLogOperation.LogEntryCache>(logEntriesCache);
                    }
                    monitor.beginTask(CVSUIMessages.CVSChangeSetCollector_4, 100 * projectMapping.size());
                    monitor.setTaskName(CVSUIMessages.CVSChangeSetCollector_4);
                    Iterator iter = projectMapping.values().iterator();
                    while (iter.hasNext()) {
                        SyncInfoSet set = (SyncInfoSet)iter.next();
                        Policy.checkCanceled(monitor);
                        this.fetchLogEntries(logEntriesCache, set, Policy.subMonitorFor(monitor, 90));
                        this.fireFetchedNotification(logEntriesCache, set, Policy.subMonitorFor(monitor, 10));
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    this.fetches.clear();
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return true;
        }
        Object var6_5 = null;
        this.fetches.clear();
        monitor.done();
        return true;
    }

    private void fireFetchedNotification(RemoteLogOperation.LogEntryCache logEntriesCache, SyncInfoSet set, IProgressMonitor monitor) {
        if (this.listener != null) {
            this.listener.logEntriesFetched(set, logEntriesCache, monitor);
        }
    }

    private Map getFetchesByProject() {
        HashMap<IProject, SyncInfoSet> result = new HashMap<IProject, SyncInfoSet>();
        Iterator iter = this.fetches.iterator();
        while (iter.hasNext()) {
            FetchRequest request = (FetchRequest)((Object)iter.next());
            SyncInfo[] infos = request.getInfos();
            int i = 0;
            while (i < infos.length) {
                SyncInfo info = infos[i];
                IProject project = info.getLocal().getProject();
                SyncInfoSet infoSet = (SyncInfoSet)result.get(project);
                if (infoSet == null) {
                    infoSet = new SyncInfoSet();
                    result.put(project, infoSet);
                }
                infoSet.add(info);
                ++i;
            }
        }
        return result;
    }

    private boolean isFetchRequired(SyncInfo info) {
        return info.getLocal().getType() == 1 && !this.isLogEntryCached(info) && this.isRemoteChange(info);
    }

    private boolean isLogEntryCached(SyncInfo info) {
        SyncInfo collectedInfo = this.collectedInfos.getSyncInfo(info.getLocal());
        if (collectedInfo != null && !collectedInfo.equals((Object)info)) {
            this.remove(collectedInfo);
            collectedInfo = null;
        }
        return collectedInfo != null;
    }

    public boolean isRemoteChange(SyncInfo info) {
        int kind = info.getKind();
        if (info.getLocal().getType() != 1) {
            return false;
        }
        if (info.getComparator().isThreeWay()) {
            return (kind & 0xC) != 4;
        }
        if (info.getRemote() != null) {
            return true;
        }
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)info.getLocal()));
        try {
            return file.getSyncBytes() != null;
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    private void fetchLogEntries(RemoteLogOperation.LogEntryCache logEntriesCache, SyncInfoSet set, IProgressMonitor monitor) {
        try {
            if (this.subscriber instanceof CVSCompareSubscriber) {
                CVSCompareSubscriber compareSubscriber = (CVSCompareSubscriber)this.subscriber;
                this.fetchLogEntries(logEntriesCache, compareSubscriber, set, monitor);
            } else {
                this.fetchLogs(logEntriesCache, set, null, null, monitor);
            }
        }
        catch (CVSException e) {
            this.handleException((CoreException)((Object)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    private void fetchLogEntries(RemoteLogOperation.LogEntryCache logEntriesCache, CVSCompareSubscriber compareSubscriber, SyncInfoSet set, IProgressMonitor monitor) throws CVSException, InterruptedException {
        Map localTagMap = this.getLocalTagMap(set);
        monitor.beginTask(null, 100 * localTagMap.size());
        Iterator iter = localTagMap.keySet().iterator();
        while (iter.hasNext()) {
            CVSTag localTag = (CVSTag)iter.next();
            this.fetchLogEntries(logEntriesCache, compareSubscriber, set, localTag, Policy.subMonitorFor(monitor, 100));
        }
        Policy.checkCanceled(monitor);
        monitor.done();
    }

    private Map getLocalTagMap(SyncInfoSet set) {
        HashMap<CVSTag, SyncInfoSet> result = new HashMap<CVSTag, SyncInfoSet>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            SyncInfo info = (SyncInfo)iter.next();
            CVSTag tag = this.getLocalTag(info);
            SyncInfoSet tagSet = (SyncInfoSet)result.get(tag);
            if (tagSet == null) {
                tagSet = new SyncInfoSet();
                result.put(tag, tagSet);
            }
            tagSet.add(info);
        }
        return result;
    }

    private CVSTag getLocalTag(SyncInfo syncInfo) {
        try {
            IResource local = syncInfo.getLocal();
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)local);
            CVSTag tag = null;
            if (cvsResource.isFolder()) {
                FolderSyncInfo info = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                if (info != null) {
                    tag = info.getTag();
                }
                if (tag != null && tag.getType() == 1) {
                    tag = Util.getAccurateFolderTag((IResource)local, (CVSTag)tag);
                }
            } else {
                tag = Util.getAccurateFileTag((ICVSResource)cvsResource);
            }
            if (tag == null) {
                tag = new CVSTag();
            }
            return tag;
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return new CVSTag();
        }
    }

    private void fetchLogEntries(RemoteLogOperation.LogEntryCache logEntriesCache, CVSCompareSubscriber compareSubscriber, SyncInfoSet set, CVSTag localTag, IProgressMonitor monitor) throws CVSException, InterruptedException {
        if (compareSubscriber.isMultipleTagComparison()) {
            Map rootToInfoMap = this.getRootToInfoMap(compareSubscriber, set);
            monitor.beginTask(null, 100 * rootToInfoMap.size());
            Iterator iterator = rootToInfoMap.keySet().iterator();
            while (iterator.hasNext()) {
                IResource root = (IResource)iterator.next();
                Policy.checkCanceled(monitor);
                this.fetchLogs(logEntriesCache, set, localTag, compareSubscriber.getTag(root), Policy.subMonitorFor(monitor, 100));
            }
            monitor.done();
        } else {
            Policy.checkCanceled(monitor);
            this.fetchLogs(logEntriesCache, set, localTag, compareSubscriber.getTag(), monitor);
        }
    }

    private Map getRootToInfoMap(CVSCompareSubscriber compareSubscriber, SyncInfoSet set) {
        HashMap<IResource, SyncInfoSet> rootToInfosMap = new HashMap<IResource, SyncInfoSet>();
        IResource[] roots = compareSubscriber.roots();
        Iterator iter = set.iterator();
        block0: while (iter.hasNext()) {
            SyncInfo info = (SyncInfo)iter.next();
            IPath localPath = info.getLocal().getFullPath();
            int j = 0;
            while (j < roots.length) {
                IResource resource = roots[j];
                if (resource.getFullPath().isPrefixOf(localPath)) {
                    SyncInfoSet infoList = (SyncInfoSet)rootToInfosMap.get(resource);
                    if (infoList == null) {
                        infoList = new SyncInfoSet();
                        rootToInfosMap.put(resource, infoList);
                    }
                    infoList.add(info);
                    continue block0;
                }
                ++j;
            }
        }
        return rootToInfosMap;
    }

    private void fetchLogs(RemoteLogOperation.LogEntryCache logEntriesCache, SyncInfoSet set, CVSTag localTag, CVSTag remoteTag, IProgressMonitor monitor) throws CVSException, InterruptedException {
        ICVSRemoteResource[] remoteResources = this.getRemotesToFetch(set.getSyncInfos());
        if (remoteResources.length > 0) {
            RemoteLogOperation logOperation = new RemoteLogOperation(this.getConfiguration().getSite().getPart(), remoteResources, localTag, remoteTag, logEntriesCache);
            logOperation.execute(monitor);
        }
    }

    private ICVSRemoteResource[] getRemotesToFetch(SyncInfo[] infos) {
        ArrayList<ICVSRemoteResource> remotes = new ArrayList<ICVSRemoteResource>();
        int i = 0;
        while (i < infos.length) {
            ICVSRemoteResource remote;
            SyncInfo info = infos[i];
            if (this.isFetchRequired(info) && (remote = this.getRemoteResource(info)) != null) {
                remotes.add(remote);
            }
            ++i;
        }
        return remotes.toArray(new ICVSRemoteResource[remotes.size()]);
    }

    public void stopFetching() {
        try {
            this.getEventHandlerJob().cancel();
            this.getEventHandlerJob().join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private class FetchRequest
    extends BackgroundEventHandler.Event {
        private final SyncInfo[] infos;

        public FetchRequest(SyncInfo[] infos) {
            super(3);
            this.infos = infos;
        }

        public SyncInfo[] getInfos() {
            return this.infos;
        }
    }

    public static interface ILogsFetchedListener {
        public void logEntriesFetched(SyncInfoSet var1, RemoteLogOperation.LogEntryCache var2, IProgressMonitor var3);
    }

    private class LogEntryResourceCollector
    extends SubscriberResourceCollector {
        public LogEntryResourceCollector(Subscriber subscriber) {
            super(subscriber);
        }

        protected void remove(IResource resource) {
            LogEntryCacheUpdateHandler.this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent(resource, 1, 2), false);
        }

        protected void change(IResource resource, int depth) {
            LogEntryCacheUpdateHandler.this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent(resource, 2, depth), false);
        }

        protected boolean hasMembers(IResource resource) {
            return LogEntryCacheUpdateHandler.this.collectedInfos.hasMembers(resource);
        }
    }
}

