/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.Arrays;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class UpdateActiveExtensionsOperation
extends AbstractOperation {
    private String[] contentExtensionsToActivate;
    private final CommonViewer commonViewer;
    private final INavigatorContentService contentService;

    public UpdateActiveExtensionsOperation(CommonViewer aCommonViewer, String[] theExtensionsToActivate) {
        super(CommonNavigatorMessages.UpdateFiltersOperation_Update_CommonViewer_Filter_);
        this.commonViewer = aCommonViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
        this.contentExtensionsToActivate = theExtensionsToActivate;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        boolean updateExtensionActivation = false;
        Arrays.sort(this.contentExtensionsToActivate);
        try {
            this.commonViewer.getControl().setRedraw(false);
            INavigatorContentDescriptor[] visibleContentDescriptors = this.contentService.getVisibleExtensions();
            int i = 0;
            while (true) {
                block6: {
                    if (i < visibleContentDescriptors.length && !updateExtensionActivation) break block6;
                    if (updateExtensionActivation) {
                        this.contentService.getActivationService().activateExtensions(this.contentExtensionsToActivate, true);
                        this.contentService.getActivationService().persistExtensionActivations();
                        this.contentService.update();
                        this.commonViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                    break;
                }
                int indexofContentExtensionIdToBeActivated = Arrays.binarySearch(this.contentExtensionsToActivate, visibleContentDescriptors[i].getId());
                if (indexofContentExtensionIdToBeActivated >= 0 ^ this.contentService.isActive(visibleContentDescriptors[i].getId())) {
                    updateExtensionActivation = true;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.commonViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.commonViewer.getControl().setRedraw(true);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }
}

