/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptorManager;
import org.eclipse.ui.internal.navigator.wizards.WizardShortcutAction;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public final class WizardActionGroup
extends ActionGroup {
    public static final String TYPE_NEW = "new";
    public static final String TYPE_IMPORT = "import";
    public static final String TYPE_EXPORT = "export";
    private static final String[] NO_IDS = new String[0];
    private Map actions;
    private IWorkbenchWindow window;
    private IWizardRegistry wizardRegistry;
    private String[] wizardActionIds;
    private boolean disposed = false;
    private String type;
    private INavigatorContentService contentService;

    public WizardActionGroup(IWorkbenchWindow aWindow, IWizardRegistry aWizardRegistry, String aType) {
        Assert.isNotNull((Object)aWindow);
        Assert.isNotNull((Object)aWizardRegistry);
        Assert.isTrue((aType != null && (TYPE_NEW.equals(aType) || TYPE_IMPORT.equals(aType) || TYPE_EXPORT.equals(aType)) ? 1 : 0) != 0);
        this.window = aWindow;
        this.wizardRegistry = aWizardRegistry;
        this.type = aType;
    }

    public WizardActionGroup(IWorkbenchWindow aWindow, IWizardRegistry aWizardRegistry, String aType, INavigatorContentService aContentService) {
        this(aWindow, aWizardRegistry, aType);
        this.contentService = aContentService;
    }

    public void setContext(ActionContext aContext) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        super.setContext(aContext);
        if (aContext != null) {
            ISelection selection = aContext.getSelection();
            Object element = null;
            if (selection instanceof IStructuredSelection) {
                element = ((IStructuredSelection)selection).getFirstElement();
            }
            if (element == null) {
                element = Collections.EMPTY_LIST;
            }
            this.setWizardActionIds(CommonWizardDescriptorManager.getInstance().getEnabledCommonWizardDescriptorIds(element, this.type, this.contentService));
        } else {
            this.setWizardActionIds(NO_IDS);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        IAction action = null;
        if (this.wizardActionIds != null) {
            TreeSet<IAction> sortedWizards = new TreeSet<IAction>(ActionComparator.INSTANCE);
            int i = 0;
            while (i < this.wizardActionIds.length) {
                action = this.getAction(this.wizardActionIds[i]);
                if (action != null) {
                    sortedWizards.add(action);
                }
                ++i;
            }
            Iterator iter = sortedWizards.iterator();
            while (iter.hasNext()) {
                menu.add((IAction)iter.next());
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.actions = null;
        this.window = null;
        this.wizardActionIds = null;
        this.wizardRegistry = null;
        this.disposed = true;
    }

    protected IAction getAction(String id) {
        IWizardDescriptor descriptor;
        if (id == null || id.length() == 0) {
            return null;
        }
        Object action = (IAction)this.getActions().get(id);
        if (action == null && (descriptor = this.wizardRegistry.findWizard(id)) != null) {
            action = new WizardShortcutAction(this.window, descriptor);
            this.getActions().put(id, action);
        }
        return action;
    }

    protected Map getActions() {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        return this.actions;
    }

    public String[] getWizardActionIds() {
        return this.wizardActionIds;
    }

    protected void setWizardActionIds(String[] theWizardActionIds) {
        Arrays.sort(theWizardActionIds);
        this.wizardActionIds = theWizardActionIds;
    }

    private static class ActionComparator
    implements Comparator {
        private static final ActionComparator INSTANCE = new ActionComparator();

        private ActionComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((IAction)arg0).getText().compareTo(((IAction)arg1).getText());
        }
    }
}

