/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui;

import com.ibm.uma.MethodLibrary;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchQuery;
import org.eclipse.epf.search.ui.internal.MethodSearchScope;
import org.eclipse.epf.search.ui.internal.MethodSearchScopeViewer;
import org.eclipse.epf.search.ui.preferences.SearchUIPreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MethodSearchPage
extends DialogPage
implements ISearchPage {
    public static final String SEARCH_PAGE_ID;
    private Combo searchStringCombo;
    private Combo namePatternCombo;
    private Button caseSensitiveCheckbox;
    private MethodSearchScopeViewer searchScopeViewer;
    private ISearchPageContainer container;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.search.ui.MethodSearchPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SEARCH_PAGE_ID = clazz.getName();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label searchStringLabel = new Label(composite, 0);
        searchStringLabel.setText(SearchUIResources.getString("SearchUI.searchStringLabel.text"));
        new Label(composite, 0);
        this.searchStringCombo = new Combo(composite, 0);
        this.searchStringCombo.setLayoutData((Object)new GridData(768));
        String savedSearchString = SearchUIPreferences.getSearchString();
        if (savedSearchString != null && savedSearchString.length() > 0) {
            this.searchStringCombo.setText(savedSearchString);
        }
        this.caseSensitiveCheckbox = new Button(composite, 32);
        this.caseSensitiveCheckbox.setText(SearchUIResources.getString("SearchUI.caseSensitiveCheckbox.text"));
        this.caseSensitiveCheckbox.setSelection(SearchUIPreferences.getCaseSensitive());
        Label elementNameLabel = new Label(composite, 0);
        elementNameLabel.setText(SearchUIResources.getString("SearchUI.elementNameLabel.text"));
        new Label(composite, 0);
        this.namePatternCombo = new Combo(composite, 0);
        this.namePatternCombo.setLayoutData((Object)new GridData(768));
        String savedNamePattern = SearchUIPreferences.getNamePattern();
        if (savedNamePattern != null && savedNamePattern.length() > 0) {
            this.namePatternCombo.setText(savedNamePattern);
        } else {
            this.namePatternCombo.setText("*");
        }
        this.namePatternCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodSearchPage.this.container.setPerformActionEnabled(MethodSearchPage.this.getSearchButtonEnabled());
            }
        });
        this.namePatternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MethodSearchPage.this.container.setPerformActionEnabled(MethodSearchPage.this.getSearchButtonEnabled());
            }
        });
        new Label(composite, 0);
        Group searchScopeGroup = new Group(composite, 0);
        searchScopeGroup.setLayout((Layout)new GridLayout(1, false));
        GridData searchScopeGroupGridData = new GridData(1808);
        searchScopeGroupGridData.heightHint = 200;
        searchScopeGroup.setLayoutData((Object)searchScopeGroupGridData);
        searchScopeGroup.setText(SearchUIResources.getString("SearchUI.scopeGroup.text"));
        this.searchScopeViewer = new MethodSearchScopeViewer((Composite)searchScopeGroup, 0);
        this.container.setPerformActionEnabled(this.getSearchButtonEnabled());
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public boolean performAction() {
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        if (library == null) {
            SearchUIPlugin.getDefault().getMsgDialog().displayError(SearchUIResources.getString("SearchUI.searchError.title"), SearchUIResources.getString("SearchUI.searchError.msg"), SearchUIResources.getString("SearchUI.searchError.reason"));
            return false;
        }
        String searchString = this.searchStringCombo.getText();
        String namePattern = this.namePatternCombo.getText();
        MethodSearchScope searchScope = this.searchScopeViewer.getSearchScope();
        MethodSearchInput searchInput = new MethodSearchInput(searchString, namePattern, this.caseSensitiveCheckbox.getSelection(), false, false, searchScope);
        MethodSearchQuery searchQuery = new MethodSearchQuery(searchInput);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
        SearchUIPreferences.setSearchString(this.searchStringCombo.getText());
        SearchUIPreferences.setNamePattern(this.namePatternCombo.getText());
        SearchUIPreferences.setCaseSensitive(this.caseSensitiveCheckbox.getSelection());
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public boolean performReplace() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private boolean getSearchButtonEnabled() {
        return this.namePatternCombo.getText().trim().length() > 0;
    }
}

