/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import com.ibm.uma.MethodElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.ISearchResultCollector;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchOperation;
import org.eclipse.epf.search.ui.internal.MethodSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class MethodSearchQuery
implements ISearchQuery {
    private MethodSearchInput searchInput;
    private MethodSearchResult searchResult;

    public MethodSearchQuery(MethodSearchInput searchInput) {
        this.searchInput = searchInput;
    }

    public IStatus run(IProgressMonitor processMonitor) {
        final MethodSearchResult searchResult = (MethodSearchResult)this.getSearchResult();
        searchResult.removeAll();
        ISearchResultCollector result = new ISearchResultCollector(){

            public void accept(Object match) {
                if (match instanceof MethodElement && !TngUtil.isPredefined((MethodElement)((MethodElement)match))) {
                    searchResult.addMatch(new Match(match, 1, 1, 1));
                }
            }
        };
        MethodSearchOperation operation = new MethodSearchOperation(this.searchInput, result);
        operation.execute(processMonitor);
        processMonitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return SearchUIResources.getString("SearchUI.searchQuery.text");
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new MethodSearchResult(this);
        }
        return this.searchResult;
    }

    public MethodSearchInput getSearchInput() {
        return this.searchInput;
    }
}

