/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import java.text.MessageFormat;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.MethodSearchQuery;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;

public class MethodSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter {
    private static final String MATCH_LABEL = SearchUIResources.getString("SearchUI.searchResult.match");
    private static final String MATCHES_LABEL = SearchUIResources.getString("SearchUI.searchResult.matches");
    private MethodSearchQuery searchQuery;

    public MethodSearchResult(MethodSearchQuery searchQuery) {
        this.searchQuery = searchQuery;
    }

    public ISearchQuery getQuery() {
        return this.searchQuery;
    }

    public ImageDescriptor getImageDescriptor() {
        return SearchUIPlugin.getDefault().getImageDescriptor("full/obj16/MethodSearch.gif");
    }

    public String getLabel() {
        String searchString = this.searchQuery.getSearchInput().getSearchString();
        int matchCount = this.getMatchCount();
        if (matchCount == 1) {
            return MessageFormat.format(MATCH_LABEL, searchString);
        }
        return MessageFormat.format(MATCHES_LABEL, searchString, "" + matchCount);
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return null;
    }
}

