/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfiguratorFactory;
import org.eclipse.jface.preference.IPreferenceStore;

public final class Providers {
    private static IConfiguratorFactory configuratorFactory;
    private static IConfigurationApplicator configurationApplicator;
    private static IPreferenceStore preferenceStore;
    private static AbstractPlugin authoringPlugin;
    private static Map commandTypeToListenersMap;

    static {
        commandTypeToListenersMap = new HashMap();
    }

    private Providers() {
    }

    public static IConfiguratorFactory getConfiguratorFactory() {
        return configuratorFactory;
    }

    public static void setConfiguratorFactory(IConfiguratorFactory configuratorFactory) {
        Providers.configuratorFactory = configuratorFactory;
    }

    public static IConfigurationApplicator getConfigurationApplicator() {
        return configurationApplicator;
    }

    public static void setConfigurationApplicator(IConfigurationApplicator configurationApplicator) {
        Providers.configurationApplicator = configurationApplicator;
    }

    public static IPreferenceStore getPreferenceStore() {
        return preferenceStore;
    }

    public static void setPreferenceStore(IPreferenceStore preferenceStore) {
        Providers.preferenceStore = preferenceStore;
    }

    public static AbstractPlugin getAuthoringPlugin() {
        return authoringPlugin;
    }

    public static void setAuthoringPlugin(AbstractPlugin plugin) {
        authoringPlugin = plugin;
    }

    public static void registerCommandListener(ICommandListener listener) {
        ArrayList<ICommandListener> listeners = (ArrayList<ICommandListener>)commandTypeToListenersMap.get(listener.getCommandType());
        if (listeners == null) {
            listeners = new ArrayList<ICommandListener>();
            commandTypeToListenersMap.put(listener.getCommandType(), listeners);
        } else if (listeners.contains(listener)) {
            return;
        }
        listeners.add(listener);
    }

    public static void removeCommandListener(ICommandListener listener) {
        List listeners = (List)commandTypeToListenersMap.get(listener.getCommandType());
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                commandTypeToListenersMap.remove(listener.getCommandType());
            }
        }
    }

    public static List getCommandListeners(Class commandType) {
        return (List)commandTypeToListenersMap.get(commandType);
    }
}

