/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.CommandStackChangedEvent;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDragAndDropCommand;
import org.eclipse.epf.library.edit.util.TngUtil;

public class FullyRevertibleCommandStack
extends BasicCommandStack {
    private IErrorReporter errReporter;
    private ActionManager actionMgr;

    public FullyRevertibleCommandStack(ActionManager actionMgr) {
        this.actionMgr = actionMgr;
    }

    public FullyRevertibleCommandStack(ActionManager actionMgr, IErrorReporter errReporter) {
        this(actionMgr);
        this.errReporter = errReporter;
    }

    public void setErrorReporter(IErrorReporter errReporter) {
        this.errReporter = errReporter;
    }

    public boolean doExecute(Command command) {
        boolean ret;
        if (!command.canUndo()) {
            return false;
        }
        super.execute(command);
        if (command instanceof BSDragAndDropCommand && command.getAffectedObjects().isEmpty()) {
            if (this.top != -1) {
                this.commandList.remove(this.top--);
                this.mostRecentCommand = this.top != -1 ? (Command)this.commandList.get(this.top) : null;
            }
            return false;
        }
        boolean bl = ret = this.getMostRecentCommand() != null;
        if (ret && this.actionMgr != null) {
            if (command instanceof IResourceAwareCommand) {
                Iterator iter = ((IResourceAwareCommand)command).getModifiedResources().iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    this.actionMgr.registerAsModifierOf(resource);
                }
            } else {
                EObject modified = TngUtil.getOwner(command);
                if (modified != null) {
                    this.actionMgr.registerAsModifierOf(modified);
                }
            }
        }
        this.notifyListeners(new CommandStackChangedEvent((Object)this, 2));
        return ret;
    }

    public void execute(Command command) {
        this.doExecute(command);
    }

    public void redo() {
        super.redo();
        this.notifyListeners(new CommandStackChangedEvent((Object)this, 2));
    }

    public void undo() {
        if (this.canUndo()) {
            block3: {
                Command command = (Command)this.commandList.get(this.top--);
                try {
                    command.undo();
                    this.mostRecentCommand = command;
                }
                catch (RuntimeException exception) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)exception).fillInStackTrace());
                    this.mostRecentCommand = null;
                    ++this.top;
                    if (this.errReporter == null) break block3;
                    Object[] object = new Object[]{command};
                    object[1] = exception;
                    this.errReporter.showError(LibraryEditResources.formatString("LibraryEdit.undoCommandError.msg", object));
                }
            }
            this.notifyListeners(new CommandStackChangedEvent((Object)this, 4));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean undoAll() {
        try {
            while (this.canUndo()) {
                Command command = (Command)this.commandList.get(this.top--);
                try {
                    command.undo();
                    this.mostRecentCommand = command;
                }
                catch (RuntimeException exception) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)exception).fillInStackTrace());
                    this.mostRecentCommand = null;
                    ++this.top;
                    if (this.errReporter != null) {
                        Object[] object = new Object[]{command};
                        object[1] = exception;
                        this.errReporter.showError(LibraryEditResources.formatString("LibraryEdit.undoCommandError.msg", object));
                    }
                    Object var4_4 = null;
                    this.notifyListeners(new CommandStackChangedEvent((Object)this, 8));
                    return false;
                }
            }
            Object var4_6 = null;
            this.notifyListeners(new CommandStackChangedEvent((Object)this, 8));
            return true;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.notifyListeners(new CommandStackChangedEvent((Object)this, 8));
            throw throwable;
        }
    }

    protected void notifyListeners(EventObject event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((CommandStackListener)i.next()).commandStackChanged(event);
        }
    }

    protected void notifyListeners() {
    }

    public void saveIsDone() {
        super.saveIsDone();
        this.notifyListeners(new CommandStackChangedEvent((Object)this, 1));
        this.commandList.clear();
        this.top = -1;
        this.saveIndex = -1;
    }

    public boolean isSaveNeeded() {
        return super.isSaveNeeded();
    }

    public static interface IErrorReporter {
        public void showError(String var1);
    }
}

